"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "Swiper",
  "comment": "轮播图",
  "cssFiles": "style.css",
  "attrs": [{
    "name": "swiperInfo",
    "comment": "轮播图信息",
    "type": "group",
    "items": [{
      "name": "options",
      "comment": "图片设置",
      "type": "Dataset",
      "columns": [{
        "id": "src",
        "name": "轮播图路径",
        "type": "String",
        "required": true,
        "width": "160px"
      }, {
        "id": "title",
        "name": "轮播图标题",
        "type": "String"
      }, {
        "id": "text",
        "name": "文字提示",
        "type": "String"
      }, {
        "id": "targetTitle",
        "name": "目标页面标题",
        "type": "String"
      }, {
        "id": "href",
        "name": "目标页面地址",
        "type": "String",
        "width": "160px"
      }]
    }, {
      "name": "target",
      "comment": "目标页面",
      "type": "Select",
      "default": "window",
      "options": [{
        "value": "self",
        "text": "当前页面"
      }, {
        "value": "page",
        "text": "新页面"
      }, {
        "value": "window",
        "text": "新窗口"
      }]
    }, {
      "name": "interval",
      "comment": "自动播放间隔时长(ms)",
      "type": "numenumber",
      "default": "3000"
    }, {
      "name": "autoplay",
      "comment": "是否自动播放",
      "type": "Switch",
      "isHtmlAttr": false,
      "default": true
    }, {
      "name": "indicatorDots",
      "comment": "是否展示指示点",
      "type": "Switch",
      "isHtmlAttr": false,
      "default": true
    }]
  }, {
    "name": "dataSourceSetting",
    "comment": "数据源设置",
    "type": "group",
    "items": [{
      "name": "dataQuerySetting",
      "comment": "数据查询设置",
      "type": "Dialog",
      "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
      "width": "800px",
      "height": "640px"
    }, {
      "name": "srcField",
      "comment": "轮播图路径绑定字段",
      "type": "String",
      "showModelFieldList": true
    }, {
      "name": "imgtitleField",
      "comment": "轮播图标题绑定字段",
      "type": "String",
      "showModelFieldList": true
    }, {
      "name": "textField",
      "comment": "文字提示绑定字段",
      "type": "String",
      "showModelFieldList": true
    }, {
      "name": "titleField",
      "comment": "目标页面标题绑定字段",
      "type": "String",
      "showModelFieldList": true
    }, {
      "name": "hrefField",
      "comment": "目标页地址绑定字段",
      "type": "String",
      "showModelFieldList": true
    }]
  }],
  "styles": ["size", "position", "background", "border", "margin", "other"],
  "defaultStyles": {
    "width": "1147px",
    "height": "480px",
    "min-height": "480px"
  },
  "events": [{
    "name": "onClick",
    "comment": "点击时"
  }]
};
exports["default"] = _default;