"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 面板组件
 * @param {[type]} dataModel [description]
 */
var Swiper = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(Swiper, _FormInput);

  var _super = _createSuper(Swiper);

  function Swiper(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, Swiper);
    return _super.call(this, __tfp, "Swiper", dataModel, parent);
  }

  (0, _createClass2["default"])(Swiper, [{
    key: "loadDataService",
    get: function get() {
      return this.dataModel.loadDataService;
    },
    set: function set(value) {
      this.dataModel.loadDataService = value;
    }
  }, {
    key: "dataBindingMember",
    get: function get() {
      return this.dataModel.dataBindingMember;
    },
    set: function set(value) {
      this.dataModel.dataBindingMember = value;
    }
  }, {
    key: "srcField",
    get: function get() {
      return this.dataModel.srcField;
    },
    set: function set(value) {
      this.dataModel.srcField = value;
    }
  }, {
    key: "loadData",
    value: function loadData() {
      if (!this.dataModel.loadDataService) {
        alert("请为[" + this.id + "]设置加载数据服务！");
        return;
      }

      var serviceCpt = this._tfp.get(this.dataModel.loadDataService);

      if (!serviceCpt) {
        alert("ID为[" + this.dataModel.loadDataService + "]的组件不存在！");
        return;
      }

      if (!this.dataModel.dataBindingMember) {
        alert("请为[" + this.id + "]设置数据绑定成员！");
        return;
      }

      if (!this.dataModel.srcField) {
        alert("请为[" + this.id + "]设置图片路径！");
        return;
      }

      var that = this;
      serviceCpt.request(null, function (req, res) {
        var data = res[that.dataModel.dataBindingMember];
        that.bindData(data);
      });
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      if (this.dataModel.loadDataService) {
        this.loadData();
      } else {
        if (this._jqObj) {
          this._jqObj.empty();

          this.addOption(value[0], true, 0);
        }
      }
    } // 选项

  }, {
    key: "options",
    get: function get() {
      return this.dataModel.options;
    },
    set: function set(value) {
      if (!value) return;
      var options = [];

      if (typeof value == "string") {
        var arr = value.split(",");

        for (var i = 0; i < arr.length; i++) {
          var str = arr[i];

          if (str.trim() != "") {
            options.push({
              value: str,
              text: str
            });
          }
        }
      } else if (Array.isArray(value)) {
        for (var i = 0; i < value.length; i++) {
          var val = value[i];

          if (Object.prototype.toString.call(val) === '[object Object]') {
            options.push(val);
          } else {
            options.push({
              value: val,
              text: val
            });
          }
        }
      }

      this.dataModel.options = options;

      if (this._jqObj) {
        this._jqObj.empty();

        if (value.length > 0) {
          this.addOption(value[0], true, 0);
        }
      }
    }
  }, {
    key: "addOption",
    value: function addOption(option, isInit, index) {
      var indent = this.getHtmlIndent();
      var str = "";
      str += this.getOptionHtml(indent, option, index);

      if (str != "") {
        this._jqObj.append(str);

        if (!isInit) this.dataModel.options.push(option);
      }
    }
  }, {
    key: "getOptionHtml",
    value: function getOptionHtml(indent, option, index) {
      var optionHtml = "";

      if (option.swipersrc) {
        optionHtml += indent;
        optionHtml += "<div class=\"swiper_imageBox\" style=\"height: fit-content;\">";
        var src = option.srcJson.url;

        if (option.srcJson.type == 'url') {
          src = this._tfp.getUrlRealPath(src);
        }

        optionHtml += "<img class=\"wx-image\" src=\"" + src + "\" style=\" width:100%; height:100%;user-select:none; \">\n";
        optionHtml += "</div>\r\n";
      }

      return optionHtml;
    } //组件提示

  }, {
    key: "title",
    get: function get() {
      return this.dataModel.title;
    },
    set: function set(value) {
      this.dataModel.title = value;
      if (this._jqObj) this._jqObj.attr("title", value);
    } // 自动播放间隔时长(ms)

  }, {
    key: "interval",
    get: function get() {
      return this.dataModel.interval;
    },
    set: function set(value) {
      this.dataModel.interval = value;
    } // 幻灯片切换时长(ms)

  }, {
    key: "duration",
    get: function get() {
      return this.dataModel.duration;
    },
    set: function set(value) {
      this.dataModel.duration = value;
    } // 前边距(px)

  }, {
    key: "previousMargin",
    get: function get() {
      return this.dataModel.previousMargin;
    },
    set: function set(value) {
      this.dataModel.previousMargin = value;
    } // 后边距(px)

  }, {
    key: "nextMargin",
    get: function get() {
      return this.dataModel.nextMargin;
    },
    set: function set(value) {
      this.dataModel.nextMargin = value;
    } //宽高比

  }, {
    key: "aspectRatio",
    get: function get() {
      return this.dataModel.aspectRatio;
    },
    set: function set(value) {
      this.dataModel.aspectRatio = value;
    } // 是否自动播放

  }, {
    key: "autoplay",
    get: function get() {
      return this.dataModel.autoplay;
    },
    set: function set(value) {
      this.dataModel.autoplay = value;
    } // 是否竖向展示

  }, {
    key: "vertical",
    get: function get() {
      return this.dataModel.vertical;
    },
    set: function set(value) {
      if (value == 'true') {
        this.dataModel.vertical = value;
      } else {
        this.dataModel.vertical = '';
      }
    } // 是否展示指示点

  }, {
    key: "indicatorDots",
    get: function get() {
      return this.dataModel.indicatorDots;
    },
    set: function set(value) {
      this.dataModel.indicatorDots = value;
    } // 是否衔接滑动

  }, {
    key: "circular",
    get: function get() {
      return this.dataModel.circular;
    },
    set: function set(value) {
      this.dataModel.circular = value;
    }
  }]);
  return Swiper;
}(_controller.FormInput);

exports["default"] = Swiper;