"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 步骤条组件
 * @param {[type]} dataModel [describe]
 */
var Steps = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(Steps, _FormInput);

  var _super = _createSuper(Steps);

  function Steps(__tfp, dataModel, parent) {
    var _this;

    (0, _classCallCheck2["default"])(this, Steps);
    _this = _super.call(this, __tfp, "Steps", dataModel, parent);

    if (!_this.dataModel.options) {
      _this.dataModel.options = [{
        text: "steps1",
        describe: "describe1",
        status: "haveInHand"
      }, {
        text: "steps2",
        describe: "describe2",
        status: "notPerformed"
      }, {
        text: "steps3",
        describe: "describe3",
        status: "notPerformed"
      }];
    }

    return _this;
  }

  (0, _createClass2["default"])(Steps, [{
    key: "options",
    get: function get() {
      return this.dataModel.options;
    },
    set: function set(options) {
      if (this._jqObj && options && Array.isArray(options)) {
        this.dataModel.options = options;

        if (this._jqObj) {
          this.reRender();
        }
      }
    }
  }, {
    key: "alignment",
    get: function get() {
      return this.dataModel.alignment;
    },
    set: function set(value) {
      this.dataModel.alignment = value;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "displayMode",
    get: function get() {
      return this.dataModel.displayMode;
    },
    set: function set(value) {
      this.dataModel.displayMode = value;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "vertical",
    get: function get() {
      return this.dataModel.vertical;
    },
    set: function set(value) {
      this.dataModel.vertical = value ? true : false;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "lineStyle",
    get: function get() {
      return this.dataModel.lineStyle;
    },
    set: function set(value) {
      this.dataModel.lineStyle = value ? true : false;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "displayDescription",
    get: function get() {
      return this.dataModel.displayDescription;
    },
    set: function set(value) {
      this.dataModel.displayDescription = value ? true : false;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "onClickStatus",
    get: function get() {
      return this.dataModel.onClickStatus;
    },
    set: function set(value) {
      this.dataModel.onClickStatus = value ? true : false;
    }
  }, {
    key: "backgroundStatus",
    get: function get() {
      return this.dataModel.backgroundStatus;
    },
    set: function set(value) {
      this.dataModel.backgroundStatus = value ? true : false;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "stepsTitleWidth",
    get: function get() {
      return this.dataModel.stepsTitleWidth;
    },
    set: function set(value) {
      this.dataModel.stepsTitleWidth = value;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "stepsLineWidth",
    get: function get() {
      return this.dataModel.stepsLineWidth;
    },
    set: function set(value) {
      this.dataModel.stepsLineWidth = value;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "notColor",
    get: function get() {
      return this.dataModel.notColor;
    },
    set: function set(value) {
      this.dataModel.notColor = value;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "handColor",
    get: function get() {
      return this.dataModel.handColor;
    },
    set: function set(value) {
      this.dataModel.handColor = value;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "compColor",
    get: function get() {
      return this.dataModel.compColor;
    },
    set: function set(value) {
      this.dataModel.compColor = value;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "loadDataListService",
    get: function get() {
      return this.dataModel.loadDataListService;
    },
    set: function set(value) {
      this.dataModel.loadDataListService = value;
    }
  }, {
    key: "dataListBindingMember",
    get: function get() {
      return this.dataModel.dataListBindingMember;
    },
    set: function set(value) {
      this.dataModel.dataListBindingMember = value;
    }
  }, {
    key: "dataListTextFormat",
    get: function get() {
      return this.dataModel.dataListTextFormat;
    },
    set: function set(value) {
      this.dataModel.dataListTextFormat = value;
    }
  }, {
    key: "dataListDescribeFormat",
    get: function get() {
      return this.dataModel.dataListDescribeFormat;
    },
    set: function set(value) {
      this.dataModel.dataListDescribeFormat = value;
    }
  }, {
    key: "dataListIconFormat",
    get: function get() {
      return this.dataModel.dataListIconFormat;
    },
    set: function set(value) {
      this.dataModel.dataListIconFormat = value;
    }
  }, {
    key: "dataListStatusFormat",
    get: function get() {
      return this.dataModel.dataListStatusFormat;
    },
    set: function set(value) {
      this.dataModel.dataListStatusFormat = value;
    }
  }, {
    key: "reRender",
    value: function reRender() {
      this._jqObj.empty();

      this._jqObj.append(this.getBodyHtml());

      if (!this._tfp.isDesigning) this.bindItemEvent();
    }
  }, {
    key: "getBodyHtml",
    value: function getBodyHtml(getComponentsHtml) {
      var indent = this.getHtmlIndent();
      var html = "\r\n";

      if (this.dataModel.vertical) {
        html += indent + "\t<div class=\"tfp-steps-v\">\r\n";
      } else if (this.dataModel.displayMode == "introductionMode") {
        html += indent + "\t<div class=\"tfp-steps-i\">\r\n";
      } else if (this.dataModel.displayMode == "buttonMode") {
        html += indent + "\t<div class=\"tfp-steps-b\">\r\n";
      } else if (this.dataModel.displayMode == "defaultMode" || this.dataModel.displayMode == "") {
        html += indent + "\t<div class=\"tfp-steps-d\">\r\n";
      }

      for (var i = 0; i < this.dataModel.options.length; i++) {
        var option = this.dataModel.options[i];
        var color = "";
        var borColor = "";
        var bgColor = "";
        var textColor = "";
        var width = "200";
        var textWidth = "70";
        if (!option.describe) option.describe = '';
        if (!option.icon) option.icon = '';
        if (!option.status) option.status = '未进行';

        if (option.status == "notPerformed" || option.status == "未进行" || option.status == 0) {
          color = "color: " + this.dataModel.notColor + ";";
          if (this.dataModel.backgroundStatus) color = "color: #636363;";
          borColor = "border: 2px solid " + this.dataModel.notColor + ";";
          bgColor = "background-color: " + this.dataModel.notColor + ";";
          textColor = "color: " + this.dataModel.notColor + ";";
        } else if (option.status == "haveInHand" || option.status == "进行中" || option.status == 1) {
          color = "color: " + this.dataModel.handColor + ";";
          if (this.dataModel.backgroundStatus) color = "color: #636363;";
          borColor = "border: 2px solid " + this.dataModel.handColor + ";";
          bgColor = "background-color: " + this.dataModel.handColor + ";";
          textColor = "color: " + this.dataModel.handColor + ";";
        } else if (option.status == "completed" || option.status == "已完成" || option.status == 2) {
          color = "color:" + this.dataModel.compColor + ";";
          if (this.dataModel.backgroundStatus) color = "color: #636363;";
          borColor = "border: 2px solid " + this.dataModel.compColor + ";";
          bgColor = "background-color: " + this.dataModel.compColor + ";";
          textColor = "color: " + this.dataModel.compColor + ";";
        }

        if (this.dataModel.stepsLineWidth) width = this.dataModel.stepsLineWidth;
        if (this.dataModel.stepsTitleWidth && this.dataModel.stepsTitleWidth > 70) textWidth = this.dataModel.stepsTitleWidth;
        var iconHtml = "<div class=\"tfp-steps-icon\" style=\"" + color + " " + borColor + "";
        if (this.dataModel.displayMode == "introductionMode" && !this.dataModel.vertical) iconHtml += " background-color: transparent;";
        if (this.dataModel.backgroundStatus) iconHtml += "" + bgColor + "";
        iconHtml += "\">" + parseInt(i + 1) + "</div>";
        if (option.icon) iconHtml = "<img src=\"" + option.icon + "\" style=\"width: 24px; height: 24px;\">";
        var topStyle = "";
        var bottomStyle = "";
        var buttonStyle = "";
        var lineStyle = "";

        if (this.dataModel.alignment == 'center') {
          topStyle = "left: calc(50% - 12px);";
          bottomStyle = "text-align: center;";
          buttonStyle = "margin-left: calc(50% - " + textWidth / 2 + "px);";
          lineStyle = "right: " + width / 2 + "px;";
        } else {
          topStyle = "left: 0;";
          bottomStyle = "text-align: left;";
          buttonStyle = "margin-left: 0;";
          lineStyle = "right: " + width + "px;";
        }

        if (this.dataModel.vertical) {
          html += indent + "\t<div class=\"tfp-steps-item-v\" style=\"height:" + width + "px;\">\r\n";
          html += indent + "\t<div class=\"tfp-steps-left-v\">\r\n";
          html += indent + "\t<div class=\"tfp-steps-line-v\" style=\"";

          if (this.dataModel.lineStyle) {
            html += "top:calc(-" + width / 2 + "px + 12px);height:10px;background-color:#636363;";
          } else {
            html += "" + bgColor + "top:calc(-" + width + "px + 12px);";
          }

          html += "\">";
          if (this.dataModel.lineStyle) html += "<div class=\"tfp-steps-arrow-down\"></div>";
          html += "</div>\r\n";
          html += indent + "\t<div>" + iconHtml + "</div>\r\n";
          html += indent + "\t</div>\r\n";
          html += indent + "\t<div class=\"tfp-steps-right-v\" style=\"" + bottomStyle + "\">\r\n";
          html += indent + "\t<div class=\"tfp-steps-text\" style=\"" + textColor + "\"";
          if (!this._tfp.isDesigning && option.onClick) html += " onclick =\"" + option.onClick + "\"";
          html += ">" + option.text + "</div>\r\n";
          if (this.dataModel.displayDescription) html += indent + "\t<div class=\"tfp-steps-describe\">" + option.describe + "</div>\r\n";
          html += indent + "\t</div>\r\n";
          html += indent + "\t</div>\r\n";
        } else if (this.dataModel.displayMode == "introductionMode") {
          html += indent + "\t<div class=\"tfp-steps-item-i\" style=\"width:" + width + "px;\">\r\n";
          html += indent + "\t<div>" + iconHtml + "</div>\r\n";
          html += indent + "\t<div class=\"tfp-steps-center-i\" style=\"width:calc(" + width + "px - 40px)\">\r\n";
          html += indent + "\t<div class=\"tfp-steps-text-i\" style=\"" + textColor + "\"";
          if (!this._tfp.isDesigning && option.onClick) html += " onclick =\"" + option.onClick + "\"";
          html += ">" + option.text + "</div>\r\n";
          if (this.dataModel.displayDescription) html += indent + "\t<div class=\"tfp-steps-describe\">" + option.describe + "</div>\r\n";
          html += indent + "\t</div>\r\n";
          html += indent + "\t<div class=\"tfp-steps-line-i\"></div>\r\n";
          html += indent + "\t</div>\r\n";
        } else if (this.dataModel.displayMode == "buttonMode") {
          html += indent + "\t<div class=\"tfp-steps-item-b\" style=\"width:" + (parseInt(width) + parseInt(textWidth)) + "px;\">\r\n";
          html += indent + "\t<div class=\"tfp-steps-top-b\">\r\n";
          html += indent + "\t<div class=\"tfp-steps-button-b\" style=\"" + color + " " + borColor + " " + buttonStyle + "width:" + textWidth + "px;";
          if (this.dataModel.backgroundStatus) html += "" + bgColor + "";
          html += "\"";
          if (!this._tfp.isDesigning && option.onClick) html += " onclick =\"" + option.onClick + "\"";
          html += ">" + option.text + "</div>\r\n";
          html += indent + "\t<div class=\"tfp-steps-line-b\" style=\"";

          if (this.dataModel.lineStyle) {
            var lineWidth = "";

            if (this.dataModel.alignment == 'center') {
              lineWidth = parseInt(width) + parseInt(textWidth);
            } else {
              lineWidth = parseInt(width) + parseInt(width / 2) + parseInt(textWidth);
            }

            html += "width:10px;right: " + lineWidth + "px;background-color:#636363;";
          } else {
            html += "" + lineStyle + "" + bgColor + "";
          }

          html += "\">";
          if (this.dataModel.lineStyle) html += "<div class=\"tfp-steps-arrow-right\"></div>";
          html += "</div>\r\n";
          html += indent + "\t</div>\r\n";
          html += indent + "\t<div class=\"tfp-steps-bottom-b\" style=\"" + bottomStyle + "\">\r\n";
          if (this.dataModel.displayDescription) html += indent + "\t<div class=\"tfp-steps-describe\">" + option.describe + "</div>\r\n";
          html += indent + "\t</div>\r\n";
          html += indent + "\t</div>\r\n";
        } else {
          html += indent + "\t<div class=\"tfp-steps-item\" style=\"width:" + width + "px;\">\r\n";
          html += indent + "\t<div class=\"tfp-steps-top\" style=\"" + topStyle + "\">\r\n";
          html += indent + "\t<div class=\"tfp-steps-line\" style=\"";

          if (this.dataModel.lineStyle) {
            var _lineWidth = parseInt(width / 2) + parseInt(width);

            html += "right:calc(" + _lineWidth + "px - 12px);width:10px;background-color:#636363;";
          } else {
            html += "" + bgColor + "right:calc(" + width + "px - 12px);";
          }

          html += "\">";
          if (this.dataModel.lineStyle) html += "<div class=\"tfp-steps-arrow-right\"></div>";
          html += "</div>\r\n";
          html += indent + "\t<div>" + iconHtml + "</div>\r\n";
          html += indent + "\t</div>\r\n";
          html += indent + "\t<div class=\"tfp-steps-bottom\" style=\"" + bottomStyle + "\">\r\n";
          html += indent + "\t<div class=\"tfp-steps-text\" style=\"" + textColor + "\"";
          if (!this._tfp.isDesigning && option.onClick) html += " onclick =\"" + option.onClick + "\"";
          html += ">" + option.text + "</div>\r\n";
          if (this.dataModel.displayDescription) html += indent + "\t<div class=\"tfp-steps-describe\">" + option.describe + "</div>\r\n";
          html += indent + "\t</div>\r\n";
          html += indent + "\t</div>\r\n";
        }
      }

      html += indent + "\t</div>\r\n";
      return html + "\t";
    }
    /**
     * 检查数据加载参数是否设置正确
     * @returns 
     */

  }, {
    key: "checkLoadDataArg",
    value: function checkLoadDataArg() {
      if (!this.dataModel.dataListTextFormat) {
        alert("请为[" + this.id + "]设置步骤标题数据格式！");
        return false;
      }

      return true;
    }
  }, {
    key: "bindData",
    value: function bindData(data) {
      if (isNull(data) || !Array.isArray(data)) return;
      var options = [];

      for (var i = 0; i < data.length; i++) {
        var row = data[i];
        var option = {};

        try {
          var titleFormat = "text";
          if (this.dataModel.dataListTextFormat) titleFormat = this.dataModel.dataListTextFormat;
          if (titleFormat.indexOf("{") < 0 && titleFormat.indexOf("#[") < 0) titleFormat = "{" + titleFormat + "}";
          option.text = this._tfp.replaceDataField(row, titleFormat);
          if (option.text) option.text = this._tfp.exeExpress(option.text);
        } catch (e) {
          console.log(e);
          return;
        }

        if (isNull(option.text)) continue;

        try {
          var describeFormat = "describe";
          if (this.dataModel.dataListDescribeFormat) describeFormat = this.dataModel.dataListDescribeFormat;
          if (describeFormat.indexOf("{") < 0 && describeFormat.indexOf("#[") < 0) describeFormat = "{" + describeFormat + "}";
          option.describe = this._tfp.replaceDataField(row, describeFormat);
          if (option.describe) option.describe = this._tfp.exeExpress(option.describe);
        } catch (e) {
          console.log(e);
          return;
        }

        try {
          var iconFormat = "icon";
          if (this.dataModel.dataListIconFormat) iconFormat = this.dataModel.dataListIconFormat;
          if (iconFormat.indexOf("{") < 0 && iconFormat.indexOf("#[") < 0) iconFormat = "{" + iconFormat + "}";
          option.icon = this._tfp.replaceDataField(row, iconFormat);
          if (option.icon) option.icon = this._tfp.exeExpress(option.icon);
        } catch (e) {
          console.log(e);
          return;
        }

        try {
          var statusFormat = "status";
          if (this.dataModel.dataListStatusFormat) statusFormat = this.dataModel.dataListStatusFormat;
          if (statusFormat.indexOf("{") < 0 && statusFormat.indexOf("#[") < 0) statusFormat = "{" + statusFormat + "}";
          option.status = this._tfp.replaceDataField(row, statusFormat);
          if (option.status) option.status = this._tfp.exeExpress(option.status);
        } catch (e) {
          console.log(e);
          return;
        }

        options.push(option);
      }

      this.options = options;
    }
  }, {
    key: "bindItemEvent",
    value: function bindItemEvent() {
      var that = this;

      this._jqObj.find(".tfp-steps-text").click(function () {
        if (that.dataModel.onClickStatus) that.setColor(this);
        var index = $(this).parent().parent().index();
        var option = that.options[index];
        var value = option.text;
        that.dataModel.value = value;
        that.valueOnChange();
        that.exeEventHandler("onChange", value);

        try {
          if (option.onClick) eval(option.onClick);
          if (that.dataModel.onClickOption) eval(that.dataModel.onClickOption);
        } catch (err) {
          console.log(err.message);
        }
      });

      this._jqObj.find(".tfp-steps-text-i").click(function () {
        if (that.dataModel.onClickStatus) that.setColor(this);
        var index = $(this).parent().index();
        var option = that.options[index];
        var value = option.text;
        that.dataModel.value = value;
        that.valueOnChange();
        that.exeEventHandler("onChange", value);

        try {
          if (option.onClick) eval(option.onClick);
          if (that.dataModel.onClickOption) eval(that.dataModel.onClickOption);
        } catch (err) {
          console.log(err.message);
        }
      });

      this._jqObj.find(".tfp-steps-button-b").click(function () {
        if (that.dataModel.onClickStatus) that.setColor(this);
        var index = $(this).parent().index();
        var option = that.options[index];
        var value = option.text;
        that.dataModel.value = value;
        that.valueOnChange();
        that.exeEventHandler("onChange", value);

        try {
          if (option.onClick) eval(option.onClick);
          if (that.dataModel.onClickOption) eval(that.dataModel.onClickOption);
        } catch (err) {
          console.log(err.message);
        }
      });
    }
  }, {
    key: "setStepsProgress",
    value: function setStepsProgress(index) {
      if (this.dataModel.displayMode == "introductionMode") {
        this.setColor(this._jqObj.find(".tfp-steps-text-i").eq(index));
      } else if (this.dataModel.displayMode == "buttonMode") {
        this.setColor(this._jqObj.find(".tfp-steps-button-b").eq(index));
      } else {
        this.setColor(this._jqObj.find(".tfp-steps-text").eq(index));
      }
    }
  }, {
    key: "setColor",
    value: function setColor(el) {
      var notColor = "#c0c4cc";
      var handColor = "#409eff";
      var compColor = "#67c23a";
      if (this.dataModel.notColor) notColor = this.dataModel.notColor;
      if (this.dataModel.handColor) handColor = this.dataModel.handColor;
      if (this.dataModel.compColor) compColor = this.dataModel.compColor;
      var notColorCss = {};
      var handColorCss = {};
      var compColorCss = {};

      if (this.dataModel.backgroundStatus) {
        handColorCss = {
          "color": "#636363",
          "border": "2px solid" + handColor + "",
          "background-color": "" + handColor + ""
        };
        compColorCss = {
          "color": "#636363",
          "border": "2px solid" + compColor + "",
          "background-color": "" + compColor + ""
        };
        notColorCss = {
          "color": "#636363",
          "border": "2px solid" + notColor + "",
          "background-color": "" + notColor + ""
        };
      } else {
        handColorCss = {
          "color": handColor,
          "border": "2px solid" + handColor + ""
        };
        compColorCss = {
          "color": compColor,
          "border": "2px solid" + compColor + ""
        };
        notColorCss = {
          "color": notColor,
          "border": "2px solid" + notColor + ""
        };
      }

      $(el).css("color", handColor); // 默认模式

      $(el).parent().parent().prevAll().find('.tfp-steps-text').css("color", compColor);
      $(el).parent().parent().nextAll().find('.tfp-steps-text').css("color", notColor);

      if (!this.dataModel.lineStyle) {
        $(el).parent().siblings('.tfp-steps-top').find('.tfp-steps-line').css("backgroundColor", handColor);
        $(el).parent().parent().prevAll().find('.tfp-steps-line').css("backgroundColor", compColor);
        $(el).parent().parent().nextAll().find('.tfp-steps-line').css("backgroundColor", notColor);
      }

      $(el).parent().siblings('.tfp-steps-top').find('.tfp-steps-icon').css(handColorCss);
      $(el).parent().parent().prevAll().find('.tfp-steps-icon').css(compColorCss);
      $(el).parent().parent().nextAll().find('.tfp-steps-icon').css(notColorCss); // 简洁模式

      $(el).parent().parent().prevAll().find('.tfp-steps-text-i').css("color", compColor);
      $(el).parent().parent().nextAll().find('.tfp-steps-text-i').css("color", notColor);
      $(el).parent().siblings().find('.tfp-steps-icon').css(handColorCss);
      $(el).parent().parent().prevAll().find('.tfp-steps-icon').css(compColorCss);
      $(el).parent().parent().nextAll().find('.tfp-steps-icon').css(notColorCss); // 按钮模式

      if (!this.dataModel.lineStyle) {
        $(el).siblings('.tfp-steps-line-b').css("backgroundColor", handColor);
        $(el).parent().parent().prevAll().find('.tfp-steps-line-b').css("backgroundColor", compColor);
        $(el).parent().parent().nextAll().find('.tfp-steps-line-b').css("backgroundColor", notColor);
      }

      $(el).parent().find('.tfp-steps-button-b').css(handColorCss);
      $(el).parent().parent().prevAll().find('.tfp-steps-button-b').css(compColorCss);
      $(el).parent().parent().nextAll().find('.tfp-steps-button-b').css(notColorCss); // 竖式步骤条

      if (!this.dataModel.lineStyle) {
        $(el).parent().siblings('.tfp-steps-left-v').find('.tfp-steps-line-v').css("backgroundColor", handColor);
        $(el).parent().parent().prevAll().find('.tfp-steps-line-v').css("backgroundColor", compColor);
        $(el).parent().parent().nextAll().find('.tfp-steps-line-v').css("backgroundColor", notColor);
      }

      $(el).parent().siblings('.tfp-steps-left-v').find('.tfp-steps-icon').css(handColorCss);
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载
      if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService || this.dataModel.dataQuerySetting && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)) {
        this.loadData();
      }

      this.reRender();
    }
  }]);
  return Steps;
}(_controller.FormInput);

exports["default"] = Steps;