"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 滑块组件
 * @param {[type]} dataModel [description]
 */
var Slider = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(Slider, _FormInput);

  var _super = _createSuper(Slider);

  function Slider(__tfp, dataModel, parent, inputType) {
    var _this;

    (0, _classCallCheck2["default"])(this, Slider);

    if (inputType) {
      _this = _super.call(this, __tfp, inputType, dataModel, parent);
    } else {
      _this = _super.call(this, __tfp, "Slider", dataModel, parent);
    }

    return (0, _possibleConstructorReturn2["default"])(_this);
  }

  (0, _createClass2["default"])(Slider, [{
    key: "value",
    get: function get() {
      return this.dataModel.value || 0;
    },
    set: function set(value) {
      var val = value;

      if (isNull(value)) {
        val = 0;
      }

      this.dataModel.value = val;

      if (this._jqObj) {
        var dragBox = this._jqObj.find('.tfp-slider__button-wrapper');

        dragBox.css('left', val + "%");

        this._jqObj.find('.tfp-slider__bar').width(val + "%");

        this._jqObj.find('.tfp-tooltip').text(val);
      }
    }
  }, {
    key: "dataType",
    get: function get() {
      if (!this.dataModel.dataType) this.dataModel.dataType = "text";
      return this.dataModel.dataType;
    },
    set: function set(value) {
      this.dataModel.dataType = value;
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;
      if (this.dataModel.readonly || this.dataModel.disabled) return;

      this._jqObj.mousedown(onMousedown.bind(this));

      function onMousedown() {
        var self = this;
        var event = event || window.event;
        var drag = event.target;

        if (drag.classList.contains('tfp-slider__button')) {
          drag = drag.parentNode;
        }

        if (!drag.classList.contains('tfp-slider__button-wrapper')) return;
        var boxWidth = $(drag).parent().outerWidth();
        var diffX = event.clientX - drag.offsetLeft;
        var diffY = event.clientY - drag.offsetTop;

        if (typeof drag.setCapture !== "undefined") {
          drag.setCapture();
        }

        var percent = '';

        document.onmousemove = function (event) {
          var event = event || window.event;
          var moveX = event.clientX - diffX;

          if (moveX < 0) {
            moveX = 0;
          } else if (moveX > window.innerWidth - drag.offsetWidth) {
            moveX = window.innerWidth - drag.offsetWidth;
          }

          if (moveX < 0 || moveX > boxWidth) return;
          percent = Math.round(moveX / boxWidth * 100);
          self.value = percent;
        };

        document.onmouseup = function (event) {
          this.onmousemove = null;
          this.onmouseup = null; //修复低版本ie bug

          if (typeof drag.releaseCapture != "undefined") {
            drag.releaseCapture();
          }

          if (!that._tfp.isDesigning) {
            that.valueOnChange();
            that.exeEventHandler("onChange", percent);
          }
        };
      }
    }
  }]);
  return Slider;
}(_controller.FormInput);

exports["default"] = Slider;