"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 签名组件
 * @param {[type]} dataModel [description]
 */
var Signatures = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(Signatures, _FormInput);

  var _super = _createSuper(Signatures);

  function Signatures(__tfp, dataModel, parent, inputType) {
    var _this;

    (0, _classCallCheck2["default"])(this, Signatures);

    if (inputType) {
      _this = _super.call(this, __tfp, inputType, dataModel, parent);
    } else {
      _this = _super.call(this, __tfp, "Signatures", dataModel, parent);
    }

    return (0, _possibleConstructorReturn2["default"])(_this);
  }

  (0, _createClass2["default"])(Signatures, [{
    key: "value",
    get: function get() {
      return this.dataModel.value ? this.dataModel.value : "";
    },
    set: function set(value) {
      var _this2 = this;

      if (value) {
        this.dataModel.value = value;

        if (this._jqObj) {
          var canvas = this._jqObj.find(".tfp-signatures-canvas")[0];

          var context = canvas.getContext('2d');
          canvas.width = this._jqObj.width(); // 设置宽度

          canvas.height = this._jqObj.height() - 40; // 设置高度

          var img = new Image();
          img.src = "" + this.dataModel.value + "";

          img.onload = function () {
            context.drawImage(img, 0, 0, _this2._jqObj.width(), _this2._jqObj.height() - 40);
          };
        }
      } else {
        this.dataModel.value = "";
      }
    }
  }, {
    key: "css",
    value: function css(styleName, styleValue) {
      if (arguments.length == 0) return; //获取样式值

      if (arguments.length == 1) {
        if (!this.dataModel.styles) return null;
        return this.dataModel.styles[styleName];
      }

      if (this._jqObj) this._jqObj.css(styleName, styleValue);
      if (!this.dataModel.styles) this.dataModel.styles = {};

      if (styleValue == "" || styleValue == null) {
        delete this.dataModel.styles[styleName];
      } else {
        this.dataModel.styles[styleName] = styleValue;
        if (styleName == 'width' || styleName == 'height') this.initRuntime();
      }
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var _this3 = this;

      var that = this;

      var canvas = this._jqObj.find(".tfp-signatures-canvas")[0];

      var context = canvas.getContext('2d');
      canvas.width = this._jqObj.width(); // 设置宽度

      canvas.height = this._jqObj.height() - 40; // 设置高度

      if (this.dataModel.value) {
        var img = new Image();
        img.src = "" + this.dataModel.value + "";

        img.onload = function () {
          context.drawImage(img, 0, 0, _this3._jqObj.width(), _this3._jqObj.height() - 40);
        };
      }

      if (this.dataModel.disabled) return;
      var isDrawing = false;
      var lastX = 0;
      var lastY = 0;
      canvas.addEventListener('touchstart', startDrawing);
      if (this.dataModel.readonly) return;
      canvas.addEventListener('touchmove', draw);
      canvas.addEventListener('touchend', stopDrawing);

      function startDrawing(e) {
        try {
          if (that.dataModel.onClick) eval(that.dataModel.onClick);
        } catch (err) {
          console.log(err.message);
        }

        if (that.dataModel.readonly) return;
        var touch = e.touches[0];
        isDrawing = true;

        var _canvas$getBoundingCl = canvas.getBoundingClientRect(),
            left = _canvas$getBoundingCl.left,
            top = _canvas$getBoundingCl.top; // 获取Canvas相对于窗口的偏移


        lastX = touch.clientX - left;
        lastY = touch.clientY - top;
      }

      function draw(e) {
        if (!isDrawing) return;
        e.preventDefault();
        var touch = e.touches[0];

        var _canvas$getBoundingCl2 = canvas.getBoundingClientRect(),
            left = _canvas$getBoundingCl2.left,
            top = _canvas$getBoundingCl2.top; // 获取Canvas相对于窗口的偏移


        var offsetX = touch.clientX - left;
        var offsetY = touch.clientY - top; // 检查触摸是否在自定义范围内

        if (offsetX >= 0 && offsetX < canvas.width && offsetY >= 0 && offsetY < canvas.height) {
          context.beginPath();
          context.moveTo(lastX, lastY);
          context.lineTo(offsetX, offsetY);
          context.stroke();
          lastX = offsetX;
          lastY = offsetY;
        }
      }

      function stopDrawing() {
        that.valueOnChange();
        that.exeEventHandler("onChange", that.dataModel.value);
        isDrawing = false;
        var dataURL = canvas.toDataURL();
        that.dataModel.value = dataURL;
      }

      this.mask = true;

      this._jqObj.find(".tfp-signatures-clear").bind("click", function () {
        context.clearRect(0, 0, canvas.width, canvas.height);
        that.dataModel.value = "";

        that._jqObj.find("div").eq(0).remove();

        that.mask = true;
      });

      this._jqObj.find(".tfp-signatures-save").bind("click", function () {
        if (that.mask) {
          that._jqObj.prepend("<div style='width:100%;height:calc(100% - 40px);position:absolute;'></div>");

          that.mask = false;
        }
      });
    }
  }]);
  return Signatures;
}(_controller.FormInput);

exports["default"] = Signatures;