"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var _status = Symbol("status");
/**
 * 服务请求组件
 * @param {[type]} dataModel [description]
 */


var Service = /*#__PURE__*/function (_InvisibleComponent) {
  (0, _inherits2["default"])(Service, _InvisibleComponent);

  var _super = _createSuper(Service);

  function Service(__tfp, dataModel, parent) {
    var _this;

    (0, _classCallCheck2["default"])(this, Service);
    _this = _super.call(this, __tfp, "Service", dataModel, parent);
    _this[_status] = 0;
    _this.tempArgs = []; //用来存用setArg添加的临时参数

    _this.cbFuncs = []; //回调函数

    return _this;
  } //服务请求状态，0：未请求，1：正在请求，2：请求完毕


  (0, _createClass2["default"])(Service, [{
    key: "status",
    get: function get() {
      return this[_status];
    },
    set: function set(value) {} //服务路径

  }, {
    key: "path",
    get: function get() {
      return this.dataModel.path;
    },
    set: function set(value) {
      this.dataModel.path = value;
    }
  }, {
    key: "pathArgs",
    get: function get() {
      return this.dataModel.pathArgs;
    },
    set: function set(value) {
      this.dataModel.pathArgs = value;
    } //请求参数

  }, {
    key: "args",
    get: function get() {
      return this.dataModel.args;
    },
    set: function set(value) {
      this.dataModel.args = value;
    } //请求参数设置

  }, {
    key: "argSettings",
    get: function get() {
      return this.dataModel.argSettings;
    },
    set: function set(value) {
      this.dataModel.argSettings = value;
      this.setArgsAutoReload();
    } //参数变化时自动重载

  }, {
    key: "autoReload",
    get: function get() {
      return this.dataModel.autoReload ? true : false;
    },
    set: function set(value) {
      this.dataModel.autoReload = value ? true : false;
      this.setArgsAutoReload();
    } //是否自动显示错误提示

  }, {
    key: "autoShowError",
    get: function get() {
      return this.dataModel.autoShowError ? true : false;
    },
    set: function set(value) {
      this.dataModel.autoShowError = value ? true : false;
    } //是否显示加载动画

  }, {
    key: "showLoading",
    get: function get() {
      return this.dataModel.showLoading ? true : false;
    },
    set: function set(value) {
      this.dataModel.showLoading = value ? true : false;
    } // 加密请求参数

  }, {
    key: "encryptRequestArgs",
    get: function get() {
      return this.dataModel.encryptRequestArgs;
    },
    set: function set(value) {
      this.dataModel.encryptRequestArgs = value;
    } // 加密响应参数

  }, {
    key: "encryptResponseArgs",
    get: function get() {
      return this.dataModel.encryptResponseArgs;
    },
    set: function set(value) {
      this.dataModel.encryptResponseArgs = value;
    }
    /**
     * 设置临时请求参数，用该方法设置的参数要在请求一次后会自动清空
     * 如果跟服务请求组件的请求参数里设置的参数名相同，则会优先使用此处设置的参数值
     * @param {*} name 
     * @param {*} value 
     * @returns 
     */

  }, {
    key: "setArg",
    value: function setArg(name, value) {
      if (!name) {
        this._tfp.showMsg("请提供参数名称！");

        return;
      }

      this.tempArgs.push({
        name: name,
        value: value
      });
    }
    /**
     * 设置请求参数，这里设置的是服务请求组件的请求参数设置里的参数信息，不是实际发送给后台发参数值
     * @param {[type]} name  [description]
     * @param {[type]} type  [description]
     * @param {[type]} value [description]
     */

  }, {
    key: "setArgSetting",
    value: function setArgSetting(name, type, value, autoReload, encrypt) {
      if (!name) {
        this._tfp.showMsg("请提供参数名称！");

        return;
      }

      if (!this.dataModel.argSettings) this.dataModel.argSettings = [];
      var arg = {
        name: name
      };
      arg.type = "Default";
      if (type) arg.type = type;
      if (value) arg.value = value;
      if (autoReload) arg.autoReload = autoReload;
      if (encrypt) arg.encrypt = encrypt;
      var isExists = false;

      for (var i = 0; i < this.dataModel.argSettings.length; i++) {
        if (this.dataModel.argSettings[i].name == arg.name) {
          isExists = true;
          if (type) this.dataModel.argSettings[i].type = type;
          if (value) this.dataModel.argSettings[i].value = value;
          if (autoReload) this.dataModel.argSettings[i].autoReload = autoReload;
          if (encrypt) this.dataModel.argSettings[i].encrypt = encrypt;
          break;
        }
      }

      if (!isExists) this.dataModel.argSettings.push(arg);
      if (autoReload) this.setArgsAutoReload(arg);

      if (encrypt) {
        if (!this.dataModel.encryptRequestArgs) this.dataModel.encryptRequestArgs = "";
        if (this.dataModel.encryptRequestArgs != "") this.dataModel.encryptRequestArgs += ",";
        this.dataModel.encryptRequestArgs += arg.name;
      }
    }
    /**
     * 删除请求参数设置
     * @param  {[type]} name [description]
     * @return {[type]}      [description]
     */

  }, {
    key: "removeArgSetting",
    value: function removeArgSetting(name) {
      if (!name || !this.dataModel.argSettings) return;

      for (var i = 0; i < this.dataModel.argSettings.length; i++) {
        if (this.dataModel.argSettings[i].name == name) {
          this.dataModel.argSettings.splice(i, 1);
          return;
        }
      }
    }
    /**
     * 显示错误信息
     * @param  {[type]} msg [description]
     * @return {[type]}     [description]
     */

  }, {
    key: "showError",
    value: function showError(msg) {
      console.error(msg);

      if (this.dataModel.autoShowError && typeof window != "undefined") {
        this._tfp.showMsg(msg);
      }

      if (this.onError) {
        this.onError(msg);
      } else if (this.dataModel.onError) {
        eval(this.dataModel.onError);
      }
    }
    /**
     * 获取HTTP请求对象
     * @return {[type]}         [description]
     */

  }, {
    key: "getHttpRequest",
    value: function getHttpRequest() {
      var httpRequest;

      if (window.XMLHttpRequest) {
        httpRequest = new XMLHttpRequest();
      } else if (window.ActiveXObject) {
        httpRequest = new ActiveXObject("Msxml2.XMLHTTP");

        if (!httpRequest) {
          httpRequest = new ActiveXObject("Microsoft.XMLHTTP");
        }
      }

      if (!httpRequest) {
        this.showError("您的浏览器不支持Ajax，无法执行该操作！");
        return null;
      }

      return httpRequest;
    }
    /**
     * 请求服务
     * @param  {[type]}   args 请求参数
     * @param  {Function} cb   回调函数
     */

  }, {
    key: "request",
    value: function request(args, cb) {
      if (!this.path && !this.pathArgs) {
        this.showError("请提供服务路径！");
        return;
      }

      var tpath = "";

      if (this.pathArgs) {
        this.pathArgs.projName = this._tfp.curPage.dataModel.projName;
        tpath = this._tfp.getTBPath(location.pathname, this.pathArgs);
      } else {
        tpath = this.path;
      }

      if (cb) this.cbFuncs.push(cb); //如果当前服务对象正在发送请求，则不重复请求

      if (this[_status] == 1) return;
      this[_status] = 1;

      if (this.dataModel.showLoading) {
        var that = this;

        this._tfp.topWin.$(document).ready(function () {
          // 创建并追加遮罩层
          var overlay = that._tfp.topWin.$('<div id="overlay"><img src="' + that._tfp.rootPath + '/src/components/service/images/loading.gif" style="width:64px;height:64px;"></div>');

          that._tfp.topWin.$('body').append(overlay); // 设置遮罩层样式


          overlay.css({
            'display': 'flex',
            'justify-content': 'center',
            'align-items': 'center',
            'position': 'fixed',
            'top': 0,
            'left': 0,
            'width': '100%',
            'height': '100%',
            'background-color': 'rgba(0, 0, 0, 0)',
            'z-index': 9999
          });
        });
      } //设置请求参数


      if (!args) args = {};
      args.service = tpath;

      if (this.dataModel.args) {
        for (var p in this.dataModel.args) {
          args[p] = this.dataModel.args[p];
        }
      }

      if (this.dataModel.argSettings) {
        this._tfp.getRequestArgs(args, this.dataModel.argSettings);
      } //如果设置里临时参数，则设置临时参数，如果临时参数名与前面设置的参数名同名，则会优先采用临时参数
      //临时参数是指在脚本里用setArg()方法设置的参数


      if (this.tempArgs) {
        for (var i = 0; i < this.tempArgs.length; i++) {
          var tempArg = this.tempArgs[i];
          args[tempArg.name] = tempArg.value;
        }
      } //是否终止请求，如果服务请求有关的事件处理函数返回true
      //则表示终止请求，不再执行后续代码


      var endRequest = false;
      this.exeEventHandler("onRequest"); //如果设置了请求前需要执行的事件处理函数，则执行该函数

      /*if(this.onRequest && typeof this.onRequest == "function") {
        endRequest = this.onRequest(args);
      } else if(this.dataModel.onRequest) {
        endRequest = eval(this.dataModel.onRequest);
        if(endRequest) return;
      }*/
      //设置身份验证信息
      //如果嵌入到第三方系统，会出现跨域错误，需要捕获一下，否则无法执行后续代码

      var haveSetAuth = false; //先判断是否有top对象，且top对象中是否有身份验证对象

      try {
        if (typeof top != "undefined" && top.taskMsgAuthObj) {
          var authObj = {
            args: {}
          };
          top.taskMsgAuthObj.setAuthData(authObj);

          if (this.dataModel.encryptRequestArgs) {
            top.taskMsgAuthObj.encryptRequestData({
              "encryptRequestArgs": this.dataModel.encryptRequestArgs,
              "_auth_ts": authObj.args._auth_ts
            }, args);
          }

          for (var arg in authObj.args) {
            args[arg] = authObj.args[arg];
          }

          haveSetAuth = true;
        }
      } catch (err) {} //判断是否有window.parent对象，且window.parent对象中是否有身份验证对象


      if (!haveSetAuth) {
        try {
          if (typeof window.parent != "undefined" && window.parent.taskMsgAuthObj) {
            var _authObj = {
              args: {}
            };
            window.parent.taskMsgAuthObj.setAuthData(_authObj);

            if (this.dataModel.encryptRequestArgs) {
              window.parent.taskMsgAuthObj.encryptRequestData({
                "encryptRequestArgs": this.dataModel.encryptRequestArgs,
                "_auth_ts": _authObj.args._auth_ts
              }, args);
            }

            for (var _arg in _authObj.args) {
              args[_arg] = _authObj.args[_arg];
            }

            haveSetAuth = true;
          }
        } catch (err2) {}
      }
      /* 手机 */


      if (!haveSetAuth) {
        if (typeof tmClient != "undefined" && tmClient.mobileType == "dingding") {
          var _authObj2 = {
            args: {}
          };
          window.tmClient.setAuthData(_authObj2);

          if (this.dataModel.encryptRequestArgs) {
            window.tmClient.encryptRequestData({
              "encryptRequestArgs": this.dataModel.encryptRequestArgs,
              "_auth_ts": _authObj2.args._auth_ts
            }, args);
          }

          for (var _arg2 in _authObj2.args) {
            args[_arg2] = _authObj2.args[_arg2];
          }

          haveSetAuth = true;
        } else if (typeof tmClient != "undefined" && tmClient.mobileType == "workwx") {
          var _authObj3 = {
            args: {}
          };
          window.tmClient.setAuthData(_authObj3);

          if (this.dataModel.encryptRequestArgs) {
            window.tmClient.encryptRequestData({
              "encryptRequestArgs": this.dataModel.encryptRequestArgs,
              "_auth_ts": _authObj3.args._auth_ts
            }, args);
          }

          for (var _arg3 in _authObj3.args) {
            args[_arg3] = _authObj3.args[_arg3];
          }

          haveSetAuth = true;
        } else if (typeof tmClient != "undefined" && (tmClient.clientOSType == "iOS" && typeof window.webkit != "undefined" || tmClient.clientOSType == "Android" && typeof window.TMAndroidClient != "undefined")) {
          var that = this;
          tmClient.getAuthData(function (authData) {
            if (authData.auth_org) args._auth_org = authData.auth_org;
            args._auth_ts = authData._auth_ts;
            args._auth_data = authData._auth_data;
            that.sendRequest(args);
          });
          return;
        } else {
          if (this._tfp.getUrlArg("_auth_org")) args._auth_org = this._tfp.getUrlArg("_auth_org");
          if (this._tfp.getUrlArg("_auth_ts")) args._auth_ts = this._tfp.getUrlArg("_auth_ts");
          if (this._tfp.getUrlArg("_auth_data")) args._auth_data = this._tfp.getUrlArg("_auth_data");
        }
      } //如果嵌入到第三方系统，会出现跨域错误，需要捕获一下，否则无法执行后续代码


      var topTBObj = false;

      try {
        topTBObj = typeof top != "undefined" && top.taskBuilder;
      } catch (err) {}

      if (topTBObj) {
        var that = this;
        args.encryptRequestArgs = this.dataModel.encryptRequestArgs;
        args.encryptResponseArgs = this.dataModel.encryptResponseArgs;
        top.taskBuilder.requestByIPC(tpath, args, function (req, res) {
          that[_status] = 2;
          that.onResponse(req, res);
        });
      } else {
        this.sendRequest(args, {});
      }
    }
  }, {
    key: "exeResponseFunc",
    value: function exeResponseFunc(req, res, responseFuncStr) {
      if (responseFuncStr.indexOf(".") < 0 && responseFuncStr.indexOf(" ") < 0 && responseFuncStr.indexOf("=") < 0 && responseFuncStr.indexOf("(") < 0 && responseFuncStr.indexOf(")") < 0) {
        eval(responseFuncStr + "(req, res)");
      } else {
        eval(responseFuncStr);
      }
    }
  }, {
    key: "onResponse",
    value: function onResponse(req, res) {
      if (res.code == 0) {
        if (this.srcElement) req.srcElement = this.srcElement;

        if (this.cbFuncs.length > 0) {
          for (var i = 0; i < this.cbFuncs.length; i++) {
            this.cbFuncs[i](req, res);
          } //执行完响应回调函数之后，要清空回调函数数组，否则再次请求时，会重复执行


          this.cbFuncs = [];
        }

        if (this.dataModel.onResponse && typeof this.dataModel.onResponse == "string") {
          this.exeResponseFunc(req, res, this.dataModel.onResponse);
        }
      } else {
        //出错时，要清空回调函数数组，否则再次请求时，会重复执行
        this.cbFuncs = []; //如果是身份验证失败

        if (res.code == 501) {
          try {
            if (this._tfp.isMobile()) {
              alert("请提供有效的身份验证信息！"); //top.location = "/mobile/login.html";
            } else {
              top.location = "/";
            }
          } catch (err) {//嵌入到第三方系统时可能会出现跨域错误
          }

          return;
        }

        this.showError(res.message);
      }
    }
  }, {
    key: "sendRequest",
    value: function sendRequest(args) {
      var that = this;
      var httpRequest = this.getHttpRequest();

      try {
        httpRequest.onreadystatechange = function () {
          if (httpRequest.readyState == 4) {
            that[_status] = 2;

            if (that.dataModel.showLoading) {
              that._tfp.topWin.$(document).ready(function () {
                // 移除遮罩层
                that._tfp.topWin.$('#overlay').remove();
              });
            }

            if (httpRequest.status == 200) {
              var response = JSON.parse(httpRequest.responseText); //如果服务器端访问的响应参数中有加密的参数，则需要自动进行解密

              var encResArgs = that.dataModel.encryptResponseArgs; //let encResArgs = response["_enc_args"];

              if (encResArgs) {
                var haveSetAuth = false;

                try {
                  if (typeof top != "undefined" && top.taskMsgAuthObj) {
                    top.taskMsgAuthObj.decryptResponseData({
                      "encryptResponseArgs": encResArgs,
                      "_auth_ts": args._auth_ts
                    }, response);
                    haveSetAuth = true;
                  }
                } catch (err) {}

                if (!haveSetAuth) {
                  try {
                    if (typeof window.parent != "undefined" && window.parent.taskMsgAuthObj) {
                      window.parent.taskMsgAuthObj.decryptResponseData({
                        "encryptResponseArgs": encResArgs,
                        "_auth_ts": args._auth_ts
                      }, response);
                      haveSetAuth = true;
                    }
                  } catch (err2) {}
                }

                if (!haveSetAuth) {
                  if (typeof tmClient != "undefined" && tmClient.mobileType == "dingding") {
                    window.tmClient.decryptResponseData({
                      "encryptResponseArgs": encResArgs,
                      "_auth_ts": args._auth_ts
                    }, response);
                    haveSetAuth = true;
                  } else if (typeof tmClient != "undefined" && tmClient.mobileType == "workwx") {
                    window.tmClient.decryptResponseData({
                      "encryptResponseArgs": encResArgs,
                      "_auth_ts": args._auth_ts
                    }, response);
                    haveSetAuth = true;
                  } else if (typeof tmClient != "undefined" && (tmClient.clientOSType == "iOS" && typeof window.webkit != "undefined" || tmClient.clientOSType == "Android" && typeof window.TMAndroidClient != "undefined")) {//TODO
                  }
                }
              }

              that.onResponse(args, response);
            } else if (httpRequest.status == 404) {
              that.showError("请求的服务不存在！");
            } else {
              if (httpRequest.status !== 0) that.showError("向服务器发送请求时发生意外错误！\r\n错误代码：" + httpRequest.status);
            }
          }
        };

        var serverPath = location.toString();
        serverPath = serverPath.substr(0, serverPath.indexOf("/", 8) + 1);
        httpRequest.open("POST", serverPath + "Service", true); //将服务路径和身份验证信息放到HTTP头中，以便微服务网关直接获取，不用解析POST数据
        //HTTP头里不能传汉字

        try {
          //httpRequest.setRequestHeader("ServicePath", encodeURIComponent(args.service));
          httpRequest.setRequestHeader("ServicePath", args.service);
        } catch (err) {//
        }

        if (args.sessionId) httpRequest.setRequestHeader("sessionid", args.sessionId);
        if (args._auth_org) httpRequest.setRequestHeader("_auth_org", args._auth_org);
        if (args._auth_ts) httpRequest.setRequestHeader("_auth_ts", args._auth_ts);
        if (args._auth_data) httpRequest.setRequestHeader("_auth_data", args._auth_data); //console.log(args);

        httpRequest.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        httpRequest.send(JSON.stringify(args));
      } catch (e) {
        if (this.dataModel.showLoading) {
          that._tfp.topWin.$(document).ready(function () {
            // 移除遮罩层
            that._tfp.topWin.$('#overlay').remove();
          });
        }

        this.showError("向服务器发送请求时发生意外错误！\r\n错误描述：" + e.message);
      }
    }
    /**
     * 设置自动重载的参数
     * @param {*} arg 
     * @returns 
     */

  }, {
    key: "setArgAutoReload",
    value: function setArgAutoReload(arg) {
      if (arg.type == "ComponentVal" && (this.dataModel.autoReload || arg.autoReload)) {
        var cpt = null;

        if (arg.value) {
          cpt = this._tfp.get(arg.value);
        } else {
          cpt = this._tfp.get(arg.name);
        }

        if (!cpt) return;
        if (!cpt.formulaIpts) cpt.formulaIpts = [];
        if (!cpt.formulaIpts.contains(this.id)) cpt.formulaIpts.push(this.id);
      }
    }
    /**
     * 设置所有自动重载的参数
     */

  }, {
    key: "setArgsAutoReload",
    value: function setArgsAutoReload() {
      if (this.dataModel.argSettings && Array.isArray(this.dataModel.argSettings)) {
        for (var i = 0; i < this.dataModel.argSettings.length; i++) {
          var arg = this.dataModel.argSettings[i];
          this.setArgAutoReload(arg);
        }
      }
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      this.setArgsAutoReload();
      var encryptRequestArgs = [];

      if (this.dataModel.argSettings) {
        for (var i = 0; i < this.dataModel.argSettings.length; i++) {
          var arg = this.dataModel.argSettings[i];
          if (arg.encrypt) encryptRequestArgs.push(arg.name);
        }
      }

      if (encryptRequestArgs.length > 0) {
        if (!this.dataModel.encryptRequestArgs) this.dataModel.encryptRequestArgs = "";
        if (this.dataModel.encryptRequestArgs != "") this.dataModel.encryptRequestArgs += ",";
        this.dataModel.encryptRequestArgs += encryptRequestArgs.join(",");
      }
    }
  }]);
  return Service;
}(_controller.InvisibleComponent);

exports["default"] = Service;