"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 列表组件
 * @param {[type]} dataModel [description]
 */
var Select = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(Select, _FormInput);

  var _super = _createSuper(Select);

  function Select(__tfp, dataModel, parent, inputType) {
    var _this;

    (0, _classCallCheck2["default"])(this, Select);

    if (inputType) {
      _this = _super.call(this, __tfp, inputType, dataModel, parent);
    } else {
      _this = _super.call(this, __tfp, "Select", dataModel, parent);
    }

    return (0, _possibleConstructorReturn2["default"])(_this);
  } //属性


  (0, _createClass2["default"])(Select, [{
    key: "value",
    get: function get() {
      if (!this.dataModel.value) return "";
      return this.dataModel.value;
    },
    set: function set(value) {
      if (value == "") {
        this.dataModel.value = "";

        this._jqObj.val("");
      } else {
        if (this._jqObj && this.dataModel.options) {
          for (var i = 0; i < this.dataModel.options.length; i++) {
            var option = this.dataModel.options[i];

            if (option.value == value) {
              this._jqObj.val(option.text != null && option.text != undefined ? option.text : option.value);

              this.dataModel.value = option.value;
              if (this.dataModel.valueType == "text") this.dataModel.value = option.text;
              if (this.dataModel.valueType == "obj") this.dataModel.value = option;
              break;
            }
          }
        } else if (this._jqObj && this.dataModel.jsonDataSet && this.dataModel.jsonDataSet.options) {
          for (var i = 0; i < this.dataModel.jsonDataSet.options.length; i++) {
            var _option = this.dataModel.jsonDataSet.options[i];

            if (_option.value == value) {
              this._jqObj.val(_option.text != null && _option.text != undefined ? _option.text : _option.value);

              this.dataModel.value = _option.value;
              if (this.dataModel.valueType == "text") this.dataModel.value = _option.text;
              if (this.dataModel.valueType == "obj") this.dataModel.value = _option;
              break;
            }
          }
        }
      }

      if (!this._tfp.isDesigning) {
        this.valueOnChange();
        this.exeEventHandler("onChange", value);
      }
    }
  }, {
    key: "options",
    get: function get() {
      return this.dataModel.options;
    },
    set: function set(value) {
      this.dataModel.options = value;
    }
  }, {
    key: "valueType",
    get: function get() {
      return this.dataModel.valueType;
    },
    set: function set(value) {
      if (!this.checkAttrOption("valueType", value)) {
        this._tfp.showMsg("不支持类型：" + value + "！");

        return;
      }

      this.dataModel.valueType = value;
    }
  }, {
    key: "loadDataService",
    get: function get() {
      return this.dataModel.loadDataService;
    },
    set: function set(value) {
      this.dataModel.loadDataService = value;
    }
  }, {
    key: "dataBindingMember",
    get: function get() {
      return this.dataModel.dataBindingMember;
    },
    set: function set(value) {
      this.dataModel.dataBindingMember = value;
    }
  }, {
    key: "valueField",
    get: function get() {
      return this.dataModel.valueField;
    },
    set: function set(value) {
      this.dataModel.valueField = value;
    }
  }, {
    key: "textField",
    get: function get() {
      return this.dataModel.textField;
    },
    set: function set(value) {
      this.dataModel.textField = value;
    }
  }, {
    key: "addOption",
    value: function addOption(option) {
      if (!this.dataModel.options) this.dataModel.options = [];
      this.dataModel.options.push(option);
    }
  }, {
    key: "bindData",
    value: function bindData(data, cb) {
      if (isNull(data) || !Array.isArray(data)) return;
      this.dataModel.options = [];

      for (var i = 0; i < data.length; i++) {
        var row = data[i];
        var option = {};

        try {
          option.value = this._tfp.replaceDataField(row, "{" + this.dataModel.valueField + "}");
        } catch (e) {
          console.log(e);
          return;
        }

        if (isNull(option.value)) continue;

        if (this.dataModel.textField) {
          try {
            option.text = this._tfp.replaceDataField(row, "{" + this.dataModel.textField + "}");
          } catch (e) {
            console.log(e);
            return;
          }
        }

        this.dataModel.options.push(option); //显示组件当前值对应的文本

        if (option.value == this.dataModel.value && this._jqObj) {
          if (option.text) {
            this._jqObj.val(option.text);
          } else {
            this._jqObj.val(option.value);
          }
        }
      }

      if (cb) cb();
    }
    /**
     * 检查数据加载参数是否设置正确
     * @returns 
     */

  }, {
    key: "checkLoadDataArg",
    value: function checkLoadDataArg() {
      if (!this.dataModel.valueField) {
        alert("请为[" + this.id + "]设置选项值字段格式！");
        return false;
      }

      return true;
    }
  }, {
    key: "onLoadData",
    value: function onLoadData(req, res) {
      var dataBindingMember = this.dataModel.dataBindingMember; //某些老版本的组件使用的该属性，需要兼容

      if (this.dataModel.dataListBindingMember) {
        dataBindingMember = this.dataModel.dataListBindingMember;
      } else if (this.dataModel.dataQuerySetting && this.dataModel.dataQuerySetting.dataMember) {
        dataBindingMember = this.dataModel.dataQuerySetting.dataMember;
      }

      if (!dataBindingMember) {
        this._tfp.showMsg("请为[" + this.id + "]设置数据绑定成员！");

        return;
      }

      var data = res[dataBindingMember];
      var that = this;
      this.bindData(data, function () {
        window.popupList.show([{
          options: that.dataModel.options,
          value: that.dataModel.value
        }], function (vals) {
          if (vals.length > 0) {
            that.value = vals[0];

            for (var i = 0; i < that.dataModel.options.length; i++) {
              var option = that.dataModel.options[i];

              if (option.value == vals[0]) {
                that._jqObj.val(option.text != null && option.text != undefined ? option.text : option.value);

                break;
              }
            }
          } else that.value = "";
        });
      });
    }
  }, {
    key: "showPopupList",
    value: function showPopupList() {
      var that = this;

      if (this.dataModel.loadDataService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.dataQuerySetting && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)) {
        this.loadData();
      } else if (this.dataModel.options) {
        window.popupList.show([{
          options: this.dataModel.options,
          value: this.dataModel.value
        }], function (vals) {
          if (vals.length > 0) {
            that.value = vals[0];

            for (var i = 0; i < that.dataModel.options.length; i++) {
              var option = that.dataModel.options[i];

              if (option.value == vals[0]) {
                that._jqObj.val(option.text != null && option.text != undefined ? option.text : option.value);

                break;
              }
            }
          } else that.value = "";
        });
      } else if (this.dataModel.jsonDataSet && this.dataModel.jsonDataSet.options) {
        window.popupList.show([{
          options: this.dataModel.jsonDataSet.options,
          value: this.dataModel.value
        }], function (vals) {
          if (vals.length > 0) {
            that.value = vals[0];

            for (var i = 0; i < that.dataModel.options.length; i++) {
              var option = that.dataModel.options[i];

              if (option.value == vals[0]) {
                that._jqObj.val(option.text != null && option.text != undefined ? option.text : option.value);

                break;
              }
            }
          } else that.value = "";
        });
      }
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      if (this.dataModel.loadDataService) {//不要在初始化时加载，在点击后弹出列表时加载
        // this.loadData();
      }

      var that = this;

      this._jqObj.click(function () {
        if (that.dataModel.readonly || that.dataModel.disabled) return;

        if (!window.popupList) {
          that._tfp.use(["PopupList"], function () {
            var popupListClass = that._tfp.controllers["PopupList"];
            window.popupList = new popupListClass(that._tfp, {
              "id": "popupList",
              "type": "PopupList"
            });
            that.showPopupList();
          });

          return;
        }

        that.showPopupList();
      });
    }
  }]);
  return Select;
}(_controller.FormInput);

exports["default"] = Select;