"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 日程组件
 * @param {[type]} dataModel [description]
 */
var Schedule = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(Schedule, _FormInput);

  var _super = _createSuper(Schedule);

  function Schedule(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, Schedule);
    return _super.call(this, __tfp, "Schedule", dataModel, parent);
  }

  (0, _createClass2["default"])(Schedule, [{
    key: "loadDataListService",
    get: function get() {
      return this.dataModel.loadDataListService;
    },
    set: function set(value) {
      this.dataModel.loadDataListService = value;
    }
  }, {
    key: "dataListBindingMember",
    get: function get() {
      return this.dataModel.dataListBindingMember;
    },
    set: function set(value) {
      this.dataModel.dataListBindingMember = value;
    }
  }, {
    key: "dataListTitleFormat",
    get: function get() {
      return this.dataModel.dataListTitleFormat;
    },
    set: function set(value) {
      this.dataModel.dataListTitleFormat = value;
    }
  }, {
    key: "dataListContentFormat",
    get: function get() {
      return this.dataModel.dataListContentFormat;
    },
    set: function set(value) {
      this.dataModel.dataListContentFormat = value;
    }
  }, {
    key: "dataListStartTimeFormat",
    get: function get() {
      return this.dataModel.dataListStartTimeFormat;
    },
    set: function set(value) {
      this.dataModel.dataListStartTimeFormat = value;
    }
  }, {
    key: "dataListEndTimeFormat",
    get: function get() {
      return this.dataModel.dataListEndTimeFormat;
    },
    set: function set(value) {
      this.dataModel.dataListEndTimeFormat = value;
    }
  }, {
    key: "dataListLevelFormat",
    get: function get() {
      return this.dataModel.dataListLevelFormat;
    },
    set: function set(value) {
      this.dataModel.dataListLevelFormat = value;
    }
    /**
     * 检查数据加载参数是否设置正确
     * @returns 
     */

  }, {
    key: "checkLoadDataArg",
    value: function checkLoadDataArg() {
      if (!this.dataModel.dataListTitleFormat) {
        alert("请为[" + this.id + "]设置主题数据格式！");
        return false;
      }

      if (!this.dataModel.dataListStartTimeFormat) {
        alert("请为[" + this.id + "]设置开始时间数据格式！");
        return false;
      }

      if (!this.dataModel.dataListEndTimeFormat) {
        alert("请为[" + this.id + "]设置结束时间数据格式！");
        return false;
      }

      return true;
    }
  }, {
    key: "bindData",
    value: function bindData(data) {
      if (isNull(data) || !Array.isArray(data)) return;
      var options = [];

      for (var i = 0; i < data.length; i++) {
        var row = data[i];
        var option = {};

        try {
          var titleFormat = "title";
          if (this.dataModel.dataListTitleFormat) titleFormat = this.dataModel.dataListTitleFormat;
          if (titleFormat.indexOf("{") < 0 && titleFormat.indexOf("#[") < 0) titleFormat = "{" + titleFormat + "}";
          option.title = this._tfp.replaceDataField(row, titleFormat);
          if (option.title) option.title = this._tfp.exeExpress(option.title);
        } catch (e) {
          console.log(e);
          return;
        }

        if (isNull(option.title)) continue;

        try {
          var contentFormat = "content";
          if (this.dataModel.dataListContentFormat) contentFormat = this.dataModel.dataListContentFormat;
          if (contentFormat.indexOf("{") < 0 && contentFormat.indexOf("#[") < 0) contentFormat = "{" + contentFormat + "}";
          option.content = this._tfp.replaceDataField(row, contentFormat);
          if (option.content) option.content = this._tfp.exeExpress(option.content);
        } catch (e) {
          console.log(e);
          return;
        }

        try {
          var startTimeFormat = "startTime";
          if (this.dataModel.dataListStartTimeFormat) startTimeFormat = this.dataModel.dataListStartTimeFormat;
          if (startTimeFormat.indexOf("{") < 0 && startTimeFormat.indexOf("#[") < 0) startTimeFormat = "{" + startTimeFormat + "}";
          option.startTime = this._tfp.replaceDataField(row, startTimeFormat);
          if (option.startTime) option.startTime = this._tfp.exeExpress(option.startTime);
        } catch (e) {
          console.log(e);
          return;
        }

        if (isNull(option.startTime)) continue;

        try {
          var endTimeFormat = "endTime";
          if (this.dataModel.dataListEndTimeFormat) endTimeFormat = this.dataModel.dataListEndTimeFormat;
          if (endTimeFormat.indexOf("{") < 0 && endTimeFormat.indexOf("#[") < 0) endTimeFormat = "{" + endTimeFormat + "}";
          option.endTime = this._tfp.replaceDataField(row, endTimeFormat);
          if (option.endTime) option.endTime = this._tfp.exeExpress(option.endTime);
        } catch (e) {
          console.log(e);
          return;
        }

        if (isNull(option.endTime)) continue;

        try {
          var levelFormat = "level";
          if (this.dataModel.dataListLevelFormat) levelFormat = this.dataModel.dataListLevelFormat;
          if (levelFormat.indexOf("{") < 0 && levelFormat.indexOf("#[") < 0) levelFormat = "{" + levelFormat + "}";
          option.level = this._tfp.replaceDataField(row, levelFormat);
          if (option.level) option.level = this._tfp.exeExpress(option.level);
        } catch (e) {
          console.log(e);
          return;
        }

        options.push(option);
      }

      this.options = options;
      this.value = options;
    }
  }, {
    key: "options",
    get: function get() {
      return this.dataModel.options;
    },
    set: function set(options) {
      if (this._jqObj && options && Array.isArray(options)) {
        this.dataModel.options = options;

        if (this._jqObj) {
          this.reRender();
        }
      }
    }
  }, {
    key: "minHeight",
    get: function get() {
      return this.dataModel.minHeight;
    },
    set: function set(value) {
      this.dataModel.minHeight = value;

      if (this._jqObj) {
        this.reRender();
      }
    } // 重要且紧急状态颜色

  }, {
    key: "importantAndUrgentColor",
    get: function get() {
      return this.dataModel.importantAndUrgentColor;
    },
    set: function set(value) {
      this.dataModel.importantAndUrgentColor = value;

      if (this._jqObj) {
        this.reRender();
      }
    } // 重要不紧急状态颜色

  }, {
    key: "importantButNotUrgentColor",
    get: function get() {
      return this.dataModel.importantButNotUrgentColor;
    },
    set: function set(value) {
      this.dataModel.importantButNotUrgentColor = value;

      if (this._jqObj) {
        this.reRender();
      }
    } // 紧急不重要状态颜色

  }, {
    key: "urgentNotImportantColor",
    get: function get() {
      return this.dataModel.urgentNotImportantColor;
    },
    set: function set(value) {
      this.dataModel.urgentNotImportantColor = value;

      if (this._jqObj) {
        this.reRender();
      }
    } // 不重要不紧急状态颜色

  }, {
    key: "notImportantNotUrgentColor",
    get: function get() {
      return this.dataModel.notImportantNotUrgentColor;
    },
    set: function set(value) {
      this.dataModel.notImportantNotUrgentColor = value;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "reRender",
    value: function reRender(date) {
      this._jqObj.empty();

      this._jqObj.append(this.getBodyHtml(date));

      if (!this._tfp.isDesigning) {
        this.datePickerValueChange();
      }
    }
  }, {
    key: "getBodyHtml",
    value: function getBodyHtml(date) {
      var indent = this.getHtmlIndent();
      var html = "\r\n";
      var val = new Date();
      if (date) val = new Date(date);
      var imgDir = this._tfp.rootPath + "/src/components/schedule/images/";
      html += indent + "<div style=\"width:100%;height:40px;border-bottom: 1px solid #CCCCCC;\" data-value=" + val.format("yyyy-MM-dd") + ">" + "<div class=\"tfp-schedule-header\">" + "<div><div style=\"width:16px;\" title=\"上一年\"><img src=\"" + imgDir + "double-arrow-left-" + this._tfp.curPage.contentColorMode + ".png\"></div>" + "<div style=\"width:16px;\" title=\"上一月\"><img src=\"" + imgDir + "arrow-left-" + this._tfp.curPage.contentColorMode + ".png\"></div><span>本月</span></div>" + "<div style=\"width:166px; text-align:center;\">" + "<input ";
      if (this._tfp.isDesigning) html += "readonly";
      html += " class=\"tfp-schedule-year\" type=\"text\" value=" + val.getFullYear() + " /> 年 ";
      html += "<input ";
      if (this._tfp.isDesigning) html += "readonly";
      html += " class=\"tfp-schedule-month\" type=\"text\" value=" + (val.getMonth() + 1) + " /> 月";
      html += "</div>" + "<div><div style=\"width:16px;\" title=\"下一月\"><img src=\"" + imgDir + "arrow-right-" + this._tfp.curPage.contentColorMode + ".png\"></div>" + "<div style=\"width:16px;\" title=\"下一年\"><img src=\"" + imgDir + "double-arrow-right-" + this._tfp.curPage.contentColorMode + ".png\"></div>" + "</div></div></div>";
      html += "<div style=\"width:100%;\">" + "<div class=\"tfp-schedule-grid\">" + "<div class=\"tfp-schedule-grid-header\">" + "<div>星期一</div><div>星期二</div><div>星期三</div><div>星期四</div><div>星期五</div><div>星期六</div><div>星期日</div>" + "</div>";
      html += this.getDatePickerValue(val);
      html += "</div></div></div>";
      return html + "\t";
    }
  }, {
    key: "getDatePickerValue",
    value: function getDatePickerValue(date) {
      var firstDate = new Date(date.format("yyyy-MM-01"));
      var curWeek = firstDate.getDay();
      if (curWeek == 0) curWeek = 7;
      curWeek--;
      if (curWeek > 0) firstDate.setDate(firstDate.getDate() - curWeek);
      var grid = '';
      var index = 0;
      var minHeight = 60;
      if (this.dataModel.minHeight) minHeight = this.dataModel.minHeight;

      for (var i = 0; i < 6; i++) {
        var rowHtml = "<div class=\"tfp-schedule-grid-row\" style=\"min-height:" + minHeight + "px;\">";

        for (var j = 0; j < 7; j++) {
          var dateTmp = new Date(firstDate.format("yyyy-MM-dd"));
          dateTmp.setDate(dateTmp.getDate() + index);
          var style = "z-index:" + j + ";";

          if (dateTmp.format("yyyy-MM-dd") == new Date().format("yyyy-MM-dd")) {
            style = " background-color:#fcf8e3;";
            if (this._tfp.curPage.bgColorMode == 'dark') style += " background-color:#484848;";
          } else if (dateTmp.format("yyyy-MM") != date.format("yyyy-MM")) {
            style += " color:#999999;";
          }

          rowHtml += "<div data-value=\"" + dateTmp.format("yyyy-MM-dd") + "\" style=\"" + style + "\">" + dateTmp.format("dd") + "</div>";
          index++;
        }

        rowHtml += "</div>";
        grid += rowHtml;
      }

      return grid;
    }
  }, {
    key: "datePickerValueChange",
    value: function datePickerValueChange() {
      var that = this;

      var grid = this._jqObj.find(".tfp-schedule-grid-row div");

      $(".tfp-schedule-header").find("span").click(function () {
        that.reRender(new Date());
      });
      $(".tfp-schedule-header").find("img").each(function (index) {
        $(this).click(function () {
          if (index == 0) {
            that.toPrevYear();
          } else if (index == 1) {
            that.toPrevMonth();
          } else if (index == 2) {
            that.toNextMonth();
          } else if (index == 3) {
            that.toNextYear();
          }

          event.stopPropagation();
        });
      });
      $(".tfp-schedule-header").find("input").eq(0).change(function () {
        var reyear = /^(1949|19[5-9]\d|20\d{2}|2100)$/;
        var date = new Date($(".tfp-schedule").find("div").eq(0).attr("data-value"));
        var dateYear = new Date($(this).val()).getFullYear();

        if (!reyear.test(dateYear)) {
          $(".tfp-schedule-header").find("input").eq(0).val(date.getFullYear());
          that.reRender(date);
          return;
        }

        date.setYear(dateYear);
        that.reRender(date);
      });
      $(".tfp-schedule-header").find("input").eq(1).change(function () {
        var remonth = /0?[0-9]|1[0-2]/;
        var date = new Date($(".tfp-schedule").find("div").eq(0).attr("data-value"));
        var dateMonth = new Date($(this).val()).getMonth();

        if (!remonth.test(dateMonth)) {
          $(".tfp-schedule-header").find("input").eq(1).val(date.getMonth());
          that.reRender(date);
          return;
        }

        date.setMonth(dateMonth);
        that.reRender(date);
      });

      if (this.dataModel.options && this.dataModel.options.length > 0) {
        for (var i = 0; i < this.dataModel.options.length; i++) {
          var option = this.dataModel.options[i];
          var itemHtml = "";
          var date = new Date(option.startTime).toLocaleTimeString().toString();
          var time = date.substring(0, date.length - 3);
          var start = new Date(option.startTime).format("yyyy-MM-dd");
          var end = new Date(option.endTime).format("yyyy-MM-dd");
          var content = '';
          if (option.content) content = option.content;
          var bgColor = this.dataModel.importantAndUrgentColor;
          if (option.level == "重要不紧急") bgColor = this.dataModel.importantButNotUrgentColor;
          if (option.level == "紧急不重要") bgColor = this.dataModel.urgentNotImportantColor;
          if (option.level == "不重要不紧急") bgColor = this.dataModel.notImportantNotUrgentColor;
          itemHtml = "<p style=\"background-color:" + bgColor + ";color:#000;";

          if (start < end) {
            var day = that.DateDiff(start, end);
            var itemWidth = this._jqObj.width() / 7 * (day + 1) - 6;
            itemHtml += "position:absolute;width:" + itemWidth + "px;height:16px;overflow:hidden;";
          }

          if (option.allDayEvent) {
            itemHtml += "\" title=\"" + content + "\">全天计划：" + option.title + "</p>";
          } else {
            itemHtml += "\" title=\"" + content + "\">" + time + "：" + option.title + "</p>";
          }

          for (var j = 0; j < grid.length; j++) {
            var gridDiv = grid.eq(j);

            if (start == gridDiv.attr("data-value")) {
              gridDiv.append(itemHtml);
              break;
            }
          }
        }

        for (var i = 0; i < grid.length; i++) {
          var _gridDiv = grid.eq(i);

          if (_gridDiv.find("p").length > 0) {
            var gridHeight = 30;
            var lastItemTop = 0;

            for (var j = 0; j < _gridDiv.find("p").length; j++) {
              var lastItem = _gridDiv.find("p").eq(j);

              if (lastItem.attr("style").indexOf("position") != -1) {
                lastItemTop += 20;

                var lastItemWidth = parseFloat(lastItem.width()) - this._jqObj.width() / 7 * (7 - _gridDiv.index());

                if (lastItemWidth > 0) {
                  lastItem.parent().parent().next().eq(0).find("div").eq(0).append("<p style=\"background-color:" + lastItem.css("background-color") + ";color:#000;position:absolute;width:" + lastItemWidth + "px;height:16px;overflow:hidden;\"  title=\"" + lastItem.attr("title") + "\">" + lastItem.text() + "</p>");
                }

                _gridDiv.find("p").eq(j + 1).css("margin-top", lastItemTop);

                gridHeight += 8;
              }

              gridHeight += parseFloat(lastItem.height());
              if (_gridDiv.parent().height() < gridHeight) _gridDiv.parent().css("height", gridHeight);
            }
          }
        }
      }

      grid.click(function () {
        var date = $(this).attr("data-value");
        that.valueOnChange();
        that.exeEventHandler("onChange", date);

        try {
          if (that.dataModel.onClickOption) eval(that.dataModel.onClickOption);
        } catch (err) {
          console.log(err.message);
        }
      });
      grid.dblclick(function () {
        var date = $(this).attr("data-value");
        that.valueOnChange();
        that.exeEventHandler("onChange", date);

        try {
          if (that.dataModel.onDblClickOption) eval(that.dataModel.onDblClickOption);
        } catch (err) {
          console.log(err.message);
        }
      });
    }
  }, {
    key: "toPrevYear",
    value: function toPrevYear() {
      var date = new Date($(".tfp-schedule").find("div").eq(0).attr("data-value"));
      date.setYear(date.getFullYear() - 1);
      this.reRender(date);
    }
  }, {
    key: "toPrevMonth",
    value: function toPrevMonth() {
      var date = new Date($(".tfp-schedule").find("div").eq(0).attr("data-value"));
      date.setMonth(date.getMonth() - 1);
      this.reRender(date);
    }
  }, {
    key: "toNextYear",
    value: function toNextYear() {
      var date = new Date($(".tfp-schedule").find("div").eq(0).attr("data-value"));
      date.setYear(date.getFullYear() + 1);
      this.reRender(date);
    }
  }, {
    key: "toNextMonth",
    value: function toNextMonth() {
      var date = new Date($(".tfp-schedule").find("div").eq(0).attr("data-value"));
      date.setMonth(date.getMonth() + 1);
      this.reRender(date);
    }
  }, {
    key: "DateDiff",
    value: function DateDiff(start, end) {
      var sdate = new Date(start);
      var now = new Date(end);
      var days = now.getTime() - sdate.getTime();
      var day = parseInt(days / (1000 * 60 * 60 * 24));
      return day;
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      this.value = this.dataModel.options; //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载

      if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService || this.dataModel.dataQuerySetting && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)) {
        this.loadData();
      }

      this.reRender();
    }
  }]);
  return Schedule;
}(_controller.FormInput);

exports["default"] = Schedule;