"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 面板组件
 * @param {[type]} dataModel [description]
 */
var ScanCode = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(ScanCode, _FormInput);

  var _super = _createSuper(ScanCode);

  function ScanCode(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, ScanCode);
    return _super.call(this, __tfp, "ScanCode", dataModel, parent);
  }

  (0, _createClass2["default"])(ScanCode, [{
    key: "value",
    get: function get() {
      return this.dataModel.value;
    },
    set: function set(value) {
      this.dataModel.value = value;

      if (this._jqObj) {
        this._jqObj.find('.input').value(value);
      }

      if (!this._tfp.isDesigning) {
        this.valueOnChange();
        this.exeEventHandler("onChange", value);
      }
    } // 展示方式

  }, {
    key: "showType",
    get: function get() {
      return this.dataModel.showType;
    },
    set: function set(value) {
      this.dataModel.showType = value;

      if (this._jqObj) {
        this._jqObj.empty();

        var html = '';

        if (value == 'input') {
          if (!this.dataModel.value) {
            this.dataModel.value = '';
          }

          html += "<input class=\"wx-text\" type=\"text\" readonly value=\"" + this.dataModel.value + "\"><view class=\"wx-scancode-icon\"></view>";
        } else {
          html += "<button><view class=\"wx-scancode-icon\"></view></button>";
        }

        this._jqObj.html(html);
      }
    } // 初始化 运行时   页面渲染完成执行

  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      that._jqObj.click(function () {
        if (!that._tfp.isDesigning) {
          console.log(that);

          if (window.tmClient) {
            // alert(window.tmClient.mobileType)
            if (window.tmClient.mobileType == 'dingding') {
              window.tmClient.empower(function () {
                window.tmClient.showCodeScanner(function (text) {
                  if (!text) {
                    return;
                  }

                  that.dataModel.value = text;

                  that._jqObj.find('.input').value(text);
                });
              });
            }

            if (window.tmClient.mobileType == 'workwx') {
              window.tmClient.empower(function () {
                window.tmClient.showCodeScanner(function (text) {
                  if (!text) {
                    return;
                  }

                  that.dataModel.value = text;

                  that._jqObj.find('.input').value(text);
                });
              });
            }

            if (window.tmClient.mobileType == 'renxun') {
              tmClient.showCodeScanner({
                isMulti: true,
                canAlbum: true,
                isRepetition: true
              }, function (text) {
                if (!text) {
                  return;
                }

                that.dataModel.value = text;

                that._jqObj.find('.input').value(text);
              });
            }
          }
        }
      });
    }
  }]);
  return ScanCode;
}(_controller.FormInput);

exports["default"] = ScanCode;