"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 评分组件
 * @param {[type]} dataModel [description]
 */
var Rate = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(Rate, _FormInput);

  var _super = _createSuper(Rate);

  function Rate(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, Rate);
    return _super.call(this, __tfp, "Rate", dataModel, parent);
  }

  (0, _createClass2["default"])(Rate, [{
    key: "value",
    get: function get() {
      return this.dataModel.value;
    },
    set: function set(value) {
      if (value) {
        var val = parseFloat(value).toFixed(1);

        if (val <= 0) {
          val = "";
        } else if (val >= 5) {
          val = 5.0;
        } else {
          if (0 < parseInt((val + "").substring(2)) && parseInt((val + "").substring(2)) < 5) {
            val = parseFloat((val + "").substring(0, 1) + '.5');
          } else if (5 < parseInt((val + "").substring(2)) && parseInt((val + "").substring(2)) <= 9) {
            val = parseFloat((val + "").substring(0, 1) + '.0') + 1;
          }
        }

        this.dataModel.value = val;
      } else {
        this.dataModel.value = "";
      }

      if (!this._tfp.isDesigning) {
        this.setRateData();
      }
    }
  }, {
    key: "showText",
    get: function get() {
      return this.dataModel.showText;
    },
    set: function set(value) {
      this.dataModel.showText = value ? true : false;
      var cptWidth = 132;

      if (this.dataModel.showText || this.dataModel.readonly || this.dataModel.disabled) {
        cptWidth = 165;
      }

      this._jqObj.css("width", cptWidth + "px");

      this._jqObj.css("min-width", cptWidth + "px");

      if (!this.dataModel.styles) this.dataModel.styles = {};
      this.dataModel.styles["width"] = cptWidth + "px";
      this.dataModel.styles["min-width"] = cptWidth + "px";

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "readonly",
    get: function get() {
      return this.dataModel.readonly;
    },
    set: function set(value) {
      this.dataModel.readonly = value ? true : false;
      var cptWidth = 132;

      if (this.dataModel.showText || this.dataModel.readonly || this.dataModel.disabled) {
        cptWidth = 165;
      }

      this._jqObj.css("width", cptWidth + "px");

      this._jqObj.css("min-width", cptWidth + "px");

      if (!this.dataModel.styles) this.dataModel.styles = {};
      this.dataModel.styles["width"] = cptWidth + "px";
      this.dataModel.styles["min-width"] = cptWidth + "px";

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "disabled",
    get: function get() {
      return this.dataModel.disabled;
    },
    set: function set(value) {
      this.dataModel.disabled = value ? true : false;
      var cptWidth = 132;

      if (this.dataModel.showText || this.dataModel.readonly || this.dataModel.disabled) {
        cptWidth = 165;
      }

      this._jqObj.css("width", cptWidth + "px");

      this._jqObj.css("min-width", cptWidth + "px");

      if (!this.dataModel.styles) this.dataModel.styles = {};
      this.dataModel.styles["width"] = cptWidth + "px";
      this.dataModel.styles["min-width"] = cptWidth + "px";

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "halfStar",
    get: function get() {
      return this._tfp.rootPath + "/src/components/" + this.type.toLowerCase() + "/images/halfStar.png";
    },
    set: function set(value) {}
  }, {
    key: "fullStar",
    get: function get() {
      return this._tfp.rootPath + "/src/components/" + this.type.toLowerCase() + "/images/fullStar.png";
    },
    set: function set(value) {}
  }, {
    key: "emptyStar",
    get: function get() {
      return this._tfp.rootPath + "/src/components/" + this.type.toLowerCase() + "/images/emptyStar.png";
    },
    set: function set(value) {}
  }, {
    key: "reRender",
    value: function reRender() {
      this._jqObj.empty();

      this._jqObj.append(this.getBodyHtml());

      if (!this._tfp.isDesigning) {
        this.getRateData();
        this.setRateData();
      }
    }
  }, {
    key: "getBodyHtml",
    value: function getBodyHtml(getComponentsHtml) {
      var indent = this.getHtmlIndent();
      var html = "\r\n";
      html += indent + "<ul>\n              <li style=\"background:url(".concat(this.emptyStar, ");\"><a href=\"javascript:;\">0.5</a><a href=\"javascript:;\">1.0</a></li>\n              <li style=\"background:url(").concat(this.emptyStar, ");\"><a href=\"javascript:;\">1.5</a><a href=\"javascript:;\">2.0</a></li>\n              <li style=\"background:url(").concat(this.emptyStar, ");\"><a href=\"javascript:;\">2.5</a><a href=\"javascript:;\">3.0</a></li>\n              <li style=\"background:url(").concat(this.emptyStar, ");\"><a href=\"javascript:;\">3.5</a><a href=\"javascript:;\">4.0</a></li>\n              <li style=\"background:url(").concat(this.emptyStar, ");\"><a href=\"javascript:;\">4.5</a><a href=\"javascript:;\">5.0</a></li>\n            </ul>");

      if (this.dataModel.readonly || this.dataModel.disabled) {
        html += "<span>\u5206\u503C</span>";
      } else if (this.dataModel.showText) {
        html += "<span>\u63CF\u8FF0</span>";
      }

      return html + "\t";
    }
  }, {
    key: "getRateData",
    value: function getRateData() {
      var that = this;
      var text = {
        "0": "极差",
        "1": "失望",
        "2": "一般",
        "3": "满意",
        "4": "惊喜"
      };

      this._jqObj.find("a").on("mouseenter", function () {
        //判断是全星点还是半星点
        if ($(this).html().substring(2) == "5") {
          $(this).parent().css("background", "url(" + that.halfStar + ")");
        } else {
          $(this).parent().css("background", "url(" + that.fullStar + ")");
        } //对前方的星星进行处理，遍历前方的li使背景图均变为全星


        var prev = $(this).parent();

        for (var i = 0; i <= parseInt($(this).html()) - 1; i++) {
          prev.prev().css("background", "url(" + that.fullStar + ")");
          prev = prev.prev();
        } //对后方星星进行处理，遍历后面的li使背景图均变为空星


        var after = $(this).parent();

        for (var i = 0; i <= 4 - parseInt($(this).html()); i++) {
          after.next().css("background", "url(" + that.emptyStar + ")");
          after = after.next();
        }

        if (that.dataModel.showText) {
          for (var k in text) {
            if ($(this).parent().index() == k) {
              that._jqObj.find("span").text(text[k]);
            }
          }
        }

        that._jqObj.find("a").off('click').on("click", function () {
          that.dataModel.value = $(this).html();
        });
      });

      this._jqObj.find("ul").on("mouseleave", function () {
        that.setRateData();
      });
    }
  }, {
    key: "setRateData",
    value: function setRateData() {
      var that = this;
      var value = that.dataModel.value;
      var text = {
        "0": "极差",
        "1": "失望",
        "2": "一般",
        "3": "满意",
        "4": "惊喜"
      };
      if (that.dataModel.showText || that.dataModel.readonly || that.dataModel.disabled) that._jqObj.find("span").text("");

      if (value) {
        var index = "";

        if ((value + "").substring(2) == "5") {
          index = value - 0.5;
        } else {
          index = value - 1;
        }

        if (that.dataModel.showText) {
          that._jqObj.find("span").text(text[index]);
        }

        if (that.dataModel.readonly || that.dataModel.disabled) {
          that._jqObj.find("span").css("color", "#ffc844").text(value);
        }

        for (var i = 0; i < that._jqObj.find("li").length; i++) {
          if (i == index) {
            if ((value + "").substring(2) == "5") {
              that._jqObj.find("li").eq(i).css("background", "url(" + that.halfStar + ")");
            } else {
              that._jqObj.find("li").eq(i).css("background", "url(" + that.fullStar + ")");
            }
          }

          if (i > index) that._jqObj.find("li").eq(i).css("background", "url(" + that.emptyStar + ")");
          if (i < index) that._jqObj.find("li").eq(i).css("background", "url(" + that.fullStar + ")");
        }
      } else {
        that._jqObj.find("li").css("background", "url(" + that.emptyStar + ")");
      }
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;
      if (that.dataModel.readonly || that.dataModel.disabled) return that.setRateData();
      that.reRender();
    }
  }]);
  return Rate;
}(_controller.FormInput);

exports["default"] = Rate;