"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 单选框组件
 * @param {[type]} dataModel [description]
 */
var Radio = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(Radio, _FormInput);

  var _super = _createSuper(Radio);

  function Radio(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, Radio);
    return _super.call(this, __tfp, "Radio", dataModel, parent);
  } //属性


  (0, _createClass2["default"])(Radio, [{
    key: "value",
    get: function get() {
      return this.dataModel.value;
    },
    set: function set(value) {
      var self = this;
      this.dataModel.value = value;

      if (this._jqObj) {
        this._jqObj.find(".wx-radio-input").each(function () {
          if ($(this).attr("data-option") == value) {
            $(this).attr("checked", "checked");
            $(this).css("background-color", self.dataModel.controlColor);
          } else {
            $(this).removeAttr("checked");
            $(this).css("background-color", "#ffffff");
          }
        });
      }

      if (!this._tfp.isDesigning) {
        this.valueOnChange();
        this.exeEventHandler("onChange", value);
      }
    }
  }, {
    key: "options",
    get: function get() {
      return this.dataModel.options;
    },
    set: function set(value) {
      if (!value) return;
      this.setOptions(value);

      if (this._jqObj) {
        this._jqObj.empty();

        for (var i = 0; i < value.length; i++) {
          this.addOption(value[i], true);
        }
      }
    }
  }, {
    key: "controlColor",
    get: function get() {
      return this.dataModel.controlColor;
    },
    set: function set(value) {
      this.dataModel.controlColor = value;
    } // get flex() { return this.dataModel.flex; }
    // set flex(value) {
    //   this.dataModel.flex = value;
    //   this._jqObj.children().each(function () {
    //     $(this).removeClass()
    //   })
    //   this._jqObj.children().addClass("radio-" + value + "-" + this.dataModel.alignType);
    // }
    // get alignType() { return this.dataModel.alignType; }
    // set alignType(value) {
    //   this.dataModel.alignType = value;
    //   this._jqObj.children().each(function () {
    //     $(this).removeClass()
    //   })
    //   this._jqObj.children().addClass("radio-" + this.dataModel.flex + "-" + value);
    // }

  }, {
    key: "portrait",
    get: function get() {
      return this.dataModel.portrait;
    },
    set: function set(value) {
      this.dataModel.portrait = value ? true : false;

      if (this._jqObj) {
        if (value) {
          this._jqObj.find(".wx-radio-box").removeClass("wx-inlineblock").addClass("wx-inline");
        } else {
          this._jqObj.find(".wx-radio-box").removeClass("wx-inline").addClass("wx-inlineblock");
        }
      }
    }
  }, {
    key: "getOptionHtml",
    value: function getOptionHtml(indent, option) {
      var optionHtml = "";
      optionHtml += indent;
      optionHtml += "\t<div class=\"wx-radio-box";
      if (this.dataModel.portrait) optionHtml += " wx-inline";else optionHtml += " wx-inlineblock";
      optionHtml += "\">";
      optionHtml += "<div class=\"wx-radio-input\" ";
      optionHtml += " data-option=\"" + option.value + "\"";

      if (this.dataModel.value && this.dataModel.value + "" == option.value + "") {
        optionHtml += " checked";
        optionHtml += " style=\"background-color:" + this.dataModel.controlColor + "\"";
      } else {
        optionHtml += " style=\"background-color:#ffffff;\"";
      } // optionHtml += ">";
      // optionHtml += "<div class=\"wx-radio-item\"";


      optionHtml += ">√</div>"; // optionHtml += "</div>";

      if (option.text) {
        optionHtml += "<div class=\"wx-radio-label\">" + option.text + "</div>";
      } else {
        optionHtml += "<div class=\"wx-radio-label\">" + option.value + "</div>";
      }

      optionHtml += "</div>\r\n";
      return optionHtml;
    }
  }, {
    key: "getOptionWx",
    value: function getOptionWx(indent, option, index) {
      var vid = escape(this.dataModel.id).replaceAll("%", "");
      var optionHtml = "";
      optionHtml += indent;
      optionHtml += "\t<view class=\"wx-radio-box";
      if (this.dataModel.portrait) optionHtml += " wx-inline";else optionHtml += " wx-inlineblock";
      optionHtml += "\">";
      optionHtml += "<radio";
      optionHtml += " value=\"" + option.value + "\"";
      optionHtml += " checked=\"{{" + vid + "_" + index + "}}\"";
      optionHtml += ">";

      if (option.text) {
        optionHtml += "<text class=\"wx-radio-text\">" + option.text + "</text>";
      } else {
        optionHtml += "<text class=\"wx-radio-text\">" + option.value + "</text>";
      }

      optionHtml += "</radio>";
      optionHtml += "</view>\r\n";
      return optionHtml;
    }
  }, {
    key: "addOption",
    value: function addOption(option, isInit) {
      var indent = this.getHtmlIndent();
      var str = ""; // if (this.portrait && this._jqObj.children().length > 0)
      //   str += indent + "\t<br>\r\n";

      str += this.getOptionHtml(indent, option);

      if (str != "") {
        this._jqObj.append(str);

        this.bindOptionEvent(this._jqObj.find(".wx-radio-box").last().get(0));
        if (!isInit) this.dataModel.options.push(option);
      }
    } // getOptionWx(indent, option) {
    //   let optionHtml = "";
    //   optionHtml += indent + `\t<label class=\"wx-radio-box\ radio-${this.dataModel.flex}-${this.dataModel.alignType}" > 
    //    <radio value="${option.id}" checked="{{${option.id}}}" ${option.disabled ? 'disabled' : ''} color="${option.color ? option.color : '#09BB07'}"  />${option.name} </label>\r\n`
    //   return optionHtml;
    // }
    // addOptionWx(option, isInit) {
    //   let indent = this.getHtmlIndent();
    //   let str = "";
    //   if (this._jqObj.children().length > 0)
    //     str += indent + "\t\r\n";
    //   str += this.getOptionWx(indent, option);
    //   if (str != "") {
    //     this._jqObj.append(str);
    //     this.bindOptionEvent(this._jqObj.find(".tfp-radio-box").last().get(0));
    //     if (!isInit) this.dataModel.options.push(option);
    //   }
    // }

  }, {
    key: "bindOptionEvent",
    value: function bindOptionEvent(el) {
      var that = this;
      $(el).click(function () {
        if (that.dataModel.disabled || that.dataModel.readonly) return;
        that.value = $(this).attr("data-option");
      });
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      this._jqObj.find(".wx-radio-box").each(function () {
        that.bindOptionEvent(this);
      });
    }
  }]);
  return Radio;
}(_controller.FormInput);

exports["default"] = Radio;