"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 单选框组件
 * @param {[type]} dataModel [description]
 */
var Radio = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(Radio, _FormInput);

  var _super = _createSuper(Radio);

  function Radio(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, Radio);
    return _super.call(this, __tfp, "Radio", dataModel, parent);
  }

  (0, _createClass2["default"])(Radio, [{
    key: "value",
    get: function get() {
      return this.dataModel.value;
    },
    set: function set(value) {
      this.dataModel.value = value;

      if (this.dataModel.readonly) {
        this._jqObj.empty();

        this._jqObj.append(this.addReadonlyOption());
      } else {
        this.checkOptionByValue();
      }

      if (!this._tfp.isDesigning) {
        this.valueOnChange();
        this.exeEventHandler("onChange", value);
      }
    }
  }, {
    key: "text",
    get: function get() {
      var _this = this;

      if (!this.dataModel.value) return "";
      var item = this.dataModel.options.find(function (v) {
        return v.value == _this.dataModel.value;
      });
      if (!item) return "";
      return item.text;
    },
    set: function set(txt) {}
  }, {
    key: "options",
    get: function get() {
      return this.dataModel.options;
    },
    set: function set(value) {
      if (!value) return;
      this.setOptions(value);

      if (this._jqObj) {
        if (this.dataModel.readonly) {
          this._jqObj.empty();

          this._jqObj.append(this.addReadonlyOption());
        } else {
          if (this.dataModel.showStyle == "buttonMode" || this.dataModel.showStyle == "disperseMode") {
            this.reRender();
          } else {
            this._jqObj.empty();

            for (var i = 0; i < value.length; i++) {
              this.addOption(value[i], true, i);
            }
          }
        }
      }
    }
  }, {
    key: "valueField",
    get: function get() {
      return this.dataModel.valueField;
    },
    set: function set(value) {
      this.dataModel.valueField = value;
    }
  }, {
    key: "textField",
    get: function get() {
      return this.dataModel.textField;
    },
    set: function set(value) {
      this.dataModel.textField = value;
    }
  }, {
    key: "jsonDataSet",
    get: function get() {
      return this.dataModel.jsonDataSet;
    },
    set: function set(value) {
      this.dataModel.jsonDataSet = value;
    }
  }, {
    key: "typeCode",
    get: function get() {
      return this.dataModel.typeCode;
    },
    set: function set(value) {
      this.dataModel.typeCode = value;
    }
  }, {
    key: "portrait",
    get: function get() {
      return this.dataModel.portrait;
    },
    set: function set(value) {
      this.dataModel.portrait = value ? true : false;

      if (this._jqObj) {
        if (value && this.dataModel.showStyle == 'defaultMode') {
          var that = this;

          this._jqObj.find("label").each(function (index) {
            if (index < that._jqObj.find("label").length - 1) {
              $("<br/>").insertAfter($(this));
            }
          });
        } else {
          this._jqObj.find("br").remove();
        }
      }
    }
  }, {
    key: "showStyle",
    get: function get() {
      return this.dataModel.showStyle;
    },
    set: function set(value) {
      this.dataModel.showStyle = value;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "reRender",
    value: function reRender() {
      this._jqObj.empty();

      this._jqObj.append(this.getBodyHtml());
    }
  }, {
    key: "checkOptionByValue",
    value: function checkOptionByValue() {
      var that = this;

      if (this._jqObj) {
        if (this.dataModel.showStyle == "buttonMode" || this.dataModel.showStyle == "disperseMode") {
          this._jqObj.find(".tfp-radio-item").each(function () {
            if ($(this).attr("data-option") == that.dataModel.value) {
              $(this).addClass("tfp-radio-item-selected");
            } else {
              $(this).removeClass("tfp-radio-item-selected");
            }
          });
        } else {
          this._jqObj.find(".tfp-radio-box").each(function () {
            if ($(this).attr("data-option") == that.dataModel.value) {
              $(this).find("div").css("display", "block");
            } else {
              $(this).find("div").css("display", "none");
            }
          });
        }
      }
    }
  }, {
    key: "getBodyHtml",
    value: function getBodyHtml(getComponentsHtml) {
      var that = this;
      var bodyHtml = "\r\n";

      if (this.dataModel.jsonDataSet) {
        this.dataModel.options = this.dataModel.jsonDataSet.options;
      }

      if (!this.dataModel.options) return bodyHtml;
      var indent = this.getHtmlIndent();

      if (this.dataModel.readonly) {
        var optionReadonlyHtml = this.addReadonlyOption();
        bodyHtml += optionReadonlyHtml;
      } else {
        if (this.dataModel.showStyle == "buttonMode" || this.dataModel.showStyle == "disperseMode") {
          bodyHtml += "<div class=\"tfp-radio-button\">"; //style=\"width:calc(70px * " + this.dataModel.options.length + ")\">"
        }

        for (var i = 0; i < this.dataModel.options.length; i++) {
          var option = this.dataModel.options[i];
          if (this.dataModel.portrait && this.dataModel.showStyle == 'defaultMode') bodyHtml += indent + "\t<div class=\"tfp-radio-row\">\r\n";
          var optionHtml = this.getOptionHtml(indent + "\t", option, i);

          if (this.dataModel.portrait && this.dataModel.showStyle == 'defaultMode') {
            optionHtml = optionHtml.replaceAll("tfp-radio-box", "tfp-radio-box tfp-radio-box-portrait");
            optionHtml = optionHtml.replaceAll("tfp-radio-label", "tfp-radio-label tfp-radio-label-portrait");
          } else {
            optionHtml = optionHtml.replaceAll("tfp-radio-box", "tfp-radio-box tfp-radio-box-lateral");
            optionHtml = optionHtml.replaceAll("tfp-radio-label", "tfp-radio-label tfp-radio-label-lateral");
          }

          bodyHtml += optionHtml;
          if (this.dataModel.portrait && this.dataModel.showStyle == 'defaultMode') bodyHtml += indent + "\t</div>\r\n";
        }

        if (this.dataModel.showStyle == "buttonMode" || this.dataModel.showStyle == "disperseMode") bodyHtml += "</div>";
      }

      return bodyHtml + indent;
    }
  }, {
    key: "getOption",
    value: function getOption(index) {
      return this.dataModel.options[index];
    }
  }, {
    key: "getOptionByValue",
    value: function getOptionByValue(val) {
      return this.dataModel.options.find(function (v) {
        return v.value == val;
      });
    }
  }, {
    key: "getOptionHtml",
    value: function getOptionHtml(indent, option, index) {
      var optionHtml = "";

      if (this.dataModel.showStyle == "buttonMode" || this.dataModel.showStyle == "disperseMode") {
        var displayColor = "";
        var displayBgColor = "";
        var cursorStyle = "pointer";
        var classSelected = "";

        if (this.value == option.value) {
          classSelected = " tfp-radio-item-selected";
          if (this.dataModel.disabled) displayBgColor = "#f2f6fc";
        }

        if (this.dataModel.disabled) {
          displayColor = "#c0c4cc";
          cursorStyle = "not-allowed";
        }

        optionHtml += indent + "\t<div class=\"tfp-radio-item" + classSelected + "\" data-option=\"" + option.value + "\" style=\"cursor:" + cursorStyle + ";";
        if (displayColor != "") optionHtml += "color:" + displayColor + ";";
        if (displayBgColor != "") optionHtml += "background-color:" + displayBgColor + ";";
        if (this.dataModel.showStyle == "disperseMode") optionHtml += "margin-right: 10px;border-radius: 15px;border:0px;";
        if (this.dataModel.showStyle == "buttonMode" && index == 0) optionHtml += "border-radius: 4px 0 0 4px;";
        if (this.dataModel.showStyle == "buttonMode" && index == this.dataModel.options.length - 1) optionHtml += "border-radius: 0 4px 4px 0;";
        optionHtml += "\">";

        if (option.text) {
          optionHtml += option.text;
        } else {
          optionHtml += option.value;
        }

        optionHtml += "</div>";
      } else {
        var optionDisplay = "none";
        if (this.value == option.value) optionDisplay = "block";
        var disabledStyle = "";
        if (this.dataModel.disabled) disabledStyle = " style=\"background-color:#eeeeee;\"";
        optionHtml += indent + "\t<div class=\"tfp-radio-box\" " + disabledStyle + " data-option=\"" + option.value + "\">" + "<div style=\"display:" + optionDisplay + ";\"></div></div>";

        if (option.text) {
          optionHtml += "<label class=\"tfp-radio-label\">" + option.text + "</label>\r\n";
        } else {
          optionHtml += "<label class=\"tfp-radio-label\">" + option.value + "</label>\r\n";
        }
      }

      return optionHtml;
    }
  }, {
    key: "addReadonlyOption",
    value: function addReadonlyOption() {
      var optionHtml = "";
      var text = "";

      for (var i = 0; i < this.dataModel.options.length; i++) {
        var option = this.dataModel.options[i];

        if (this.value + '' == option.value + '') {
          if (option.text) {
            text += option.text;
          } else {
            text += option.value;
          }
        }
      }

      optionHtml += "<label class=\"tfp-radio-label\" style=\"margin-left:0px;\">" + text + "</label>\r\n";
      return optionHtml;
    }
  }, {
    key: "addOption",
    value: function addOption(option, isInit, i) {
      var indent = this.getHtmlIndent();
      var str = "";
      if (this.portrait && this._jqObj.children().length > 0 && this.dataModel.showStyle == 'defaultMode') str += indent + "\t<br>\r\n";
      str += this.getOptionHtml(indent, option, i);

      if (str != "") {
        if (this.dataModel.showStyle == "buttonMode" || this.dataModel.showStyle == "disperseMode") {
          this._jqObj.find(".tfp-radio-button").append(str);

          this.bindOptionEvent(this._jqObj.find(".tfp-radio-item").last().get(0));
        } else {
          this._jqObj.append(str);

          this.bindOptionEvent(this._jqObj.find(".tfp-radio-box,.tfp-radio-label").last().get(0));
        }

        if (!isInit) this.dataModel.options.push(option);
      }
    }
  }, {
    key: "bindOptionEvent",
    value: function bindOptionEvent(el) {
      var that = this;
      $(el).click(function () {
        if (that.dataModel.disabled || that.dataModel.readonly) return;
        var elHtml = $(el);
        if ($(el).hasClass("tfp-radio-label")) elHtml = $(el).prev();
        var curValue = elHtml.attr("data-option");

        if (that.dataModel.showStyle == "buttonMode" || that.dataModel.showStyle == "disperseMode") {
          $(el).addClass("tfp-radio-item-selected");
          $(el).siblings(".tfp-radio-item").removeClass("tfp-radio-item-selected");
        }

        that.value = curValue;
      });
      /*$(el).next().click(function() {
        if (that.dataModel.disabled || that.dataModel.readonly) return;
        that.value = curValue;
      });*/
    }
  }, {
    key: "bindOptionsEvent",
    value: function bindOptionsEvent() {
      var that = this;

      if (this.dataModel.showStyle == "buttonMode" || this.dataModel.showStyle == "disperseMode") {
        this._jqObj.find(".tfp-radio-item").each(function () {
          that.bindOptionEvent(this);
        });
      } else {
        this._jqObj.find(".tfp-radio-box,.tfp-radio-label").each(function () {
          that.bindOptionEvent(this);
        });
      }
    }
    /**
     * 检查数据加载参数是否设置正确
     * @returns 
     */

  }, {
    key: "checkLoadDataArg",
    value: function checkLoadDataArg() {
      if (!this.dataModel.valueField) {
        alert("请为[" + this.id + "]设置选项值字段格式！");
        return false;
      }

      return true;
    }
  }, {
    key: "bindData",
    value: function bindData(data) {
      if (data.rows && data.rowsCount) {
        data = data.rows;
      }

      if (!Array.isArray(data)) return;
      var options = [];

      for (var i = 0; i < data.length; i++) {
        var row = data[i];
        var option = {
          value: row[this.dataModel.valueField]
        };

        if (this.dataModel.textField) {
          option.text = row[this.dataModel.textField];
        } else {
          option.text = option.value;
        }

        options.push(option);
      }

      this.options = options;
      this.checkOptionByValue();
      this.bindOptionsEvent();

      if (this.dataModel.onBindData) {
        try {
          eval(this.dataModel.onBindData);
        } catch (err) {
          console.log(err);
        }
      }
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this; //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载

      if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService || this.dataModel.dataQuerySetting && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)) {
        this.loadData();
      } else if (this.dataModel.typeCode) {
        this.dataModel.valueField = "code";
        this.dataModel.textField = "name";

        this._tfp.use("Service", function () {
          var service = that._tfp["new"]("Service");

          service.path = "sys/service/data_dic/getList.tbs";
          service.request({
            typeCode: that.dataModel.typeCode
          }, function (req, res) {
            that.bindData(res.data);
          });
        });
      } else if (this.options && this.options.length > 0) {
        this.bindOptionsEvent();
      }
    }
  }]);
  return Radio;
}(_controller.FormInput);

exports["default"] = Radio;