"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 二维码组件
 * @param {[type]} dataModel [description]
 */
var QrCode = /*#__PURE__*/function (_VisibleComponent) {
  (0, _inherits2["default"])(QrCode, _VisibleComponent);

  var _super = _createSuper(QrCode);

  function QrCode(__tfp, dataModel, parent) {
    var _this;

    (0, _classCallCheck2["default"])(this, QrCode);
    _this = _super.call(this, __tfp, "QrCode", dataModel, parent);
    _this.qrCode = null;
    return _this;
  }

  (0, _createClass2["default"])(QrCode, [{
    key: "text",
    get: function get() {
      return this.dataModel.text;
    },
    set: function set(value) {
      this.dataModel.text = value;
      if (value) this.renderQr(value);
    }
  }, {
    key: "width",
    get: function get() {
      return this.dataModel.width;
    },
    set: function set(value) {
      this.dataModel.width = value;

      if (this._jqObj) {
        this._jqObj.css("width", value + "px");

        if (this._tfp.isDesigning) this._jqObj.css("background-size", this.dataModel.width + "px " + this.dataModel.height + "px");
      }
    }
  }, {
    key: "height",
    get: function get() {
      return this.dataModel.height;
    },
    set: function set(value) {
      this.dataModel.height = value;

      if (this._jqObj) {
        this._jqObj.css("height", value + "px");

        if (this._tfp.isDesigning) this._jqObj.css("background-size", this.dataModel.width + "px " + this.dataModel.height + "px");
      }
    }
  }, {
    key: "colorDark",
    get: function get() {
      return this.dataModel.colorDark;
    },
    set: function set(value) {
      this.dataModel.colorDark = value;
    }
  }, {
    key: "colorLight",
    get: function get() {
      return this.dataModel.colorLight;
    },
    set: function set(value) {
      this.dataModel.colorLight = value;
    }
  }, {
    key: "renderQr",
    value: function renderQr(txt) {
      //运行时不生产图片，因为图片无法拖拽调整位置
      if (this._tfp.isDesigning) return;

      this._jqObj.empty();

      this.qrCode = new QRCode(this.el, {
        text: txt,
        width: this.dataModel.width,
        height: this.dataModel.height,
        colorDark: this.dataModel.colorDark,
        colorLight: this.dataModel.colorLight,
        correctLevel: QRCode.CorrectLevel.H
      });
    }
  }, {
    key: "initDesigning",
    value: function initDesigning() {
      if (this._jqObj) {
        if (this._jqObj.parent().get(0).tagName == "TD") {
          this._jqObj.css("vertical-align", "middle");

          if (!(this.dataModel.styles && this.dataModel.styles.display)) this._jqObj.css("display", "inline-block");
        }
      }
    }
    /**
     * 初始化运行时
     * @return {[type]} [description]
     */

  }, {
    key: "initRuntime",
    value: function initRuntime() {
      this.initDesigning();
      var txt = this.dataModel.text;
      if (!txt) txt = "http://www.taskbuilder.org"; //如果不是动态绑定的后台数据，则初始化时即可渲染，否则需要等绑定数据后再渲染

      if (txt.indexOf("{") < 0) this.renderQr(txt);
      var that = this;

      this._jqObj.click(function () {
        if (that.dataModel.onClick) {
          eval(that.dataModel.onClick);
        }
      });

      this._jqObj.mouseover(function () {
        if (that.dataModel.onMouseOver) {
          eval(that.dataModel.onMouseOver);
        }
      });

      this._jqObj.mouseout(function () {
        if (that.dataModel.onMouseOut) {
          eval(that.dataModel.onMouseOut);
        }
      });
    }
  }, {
    key: "clear",
    value: function clear() {
      this.qrCode.clear();
    }
  }, {
    key: "makeCode",
    value: function makeCode(e) {
      console.log(e);
      this.qrCode.makeCode(e);
    }
  }, {
    key: "styleOnChange",
    value: function styleOnChange(styleName, styleValue) {
      if (this._tfp.isDesigning && (styleName == "width" || styleName == "height")) {
        if (styleName == "width") {
          this.width = this._tfp.getPx(styleValue);
        } else if (styleName == "height") {
          this.height = this._tfp.getPx(styleValue);
        }
      }
    }
  }]);
  return QrCode;
}(_controller.VisibleComponent);

exports["default"] = QrCode;