"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 进度条组件
 * @param {[type]} dataModel [description]
 */
var Progress = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(Progress, _FormInput);

  var _super = _createSuper(Progress);

  function Progress(__tfp, dataModel, parent, inputType) {
    var _this;

    (0, _classCallCheck2["default"])(this, Progress);

    if (inputType) {
      _this = _super.call(this, __tfp, inputType, dataModel, parent);
    } else {
      _this = _super.call(this, __tfp, "Progress", dataModel, parent);
    }

    return (0, _possibleConstructorReturn2["default"])(_this);
  }

  (0, _createClass2["default"])(Progress, [{
    key: "value",
    get: function get() {
      return this.dataModel.value || 0;
    },
    set: function set(value) {
      var val = value;

      if (isNull(value)) {
        val = 0;
      }

      this.dataModel.value = val;

      if (this._jqObj) {
        this.reRender();
      }

      if (!this._tfp.isDesigning) {
        this.valueOnChange();
        this.exeEventHandler("onChange", value);
      }
    }
  }, {
    key: "dataType",
    get: function get() {
      if (!this.dataModel.dataType) this.dataModel.dataType = "text";
      return this.dataModel.dataType;
    },
    set: function set(value) {
      this.dataModel.dataType = value;

      if (this._jqObj) {
        this.reRender();
      }

      if (!this._tfp.isDesigning) {
        this.exeEventHandler("onDatatypeChange", value);
      }
    }
  }, {
    key: "circle",
    get: function get() {
      return this.dataModel.circle;
    },
    set: function set(value) {
      this.dataModel.circle = value ? true : false;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "diam",
    get: function get() {
      return this.dataModel.diam;
    },
    set: function set(value) {
      this.dataModel.diam = value;

      if (this._jqObj) {
        this.reRender();

        if (this._tfp.isDesigning) {
          uiDesigner.setSelectedCptStyle("width", value + "px");
          uiDesigner.setSelectedCptStyle("height", value + "px");
          window.parent.$("input[style-setting-id=width]").val(value);
          window.parent.$("input[style-setting-id=height]").val(value);
        }
      }
    }
  }, {
    key: "reRender",
    value: function reRender() {
      this._jqObj.empty();

      this._jqObj.append(this.getBodyHtml());

      if (this.dataModel.circle) this.circleStyle();
    }
  }, {
    key: "getBodyHtml",
    value: function getBodyHtml(getComponentsHtml) {
      var bodyHtml = "";
      var indent = this.getHtmlIndent();
      var val = 0;
      var bgColor = "#6666FF";
      var diam = 200;

      if (this.dataModel.value) {
        val = this.dataModel.value;
      }

      if (this.dataModel.dataType) {
        switch (this.dataModel.dataType) {
          case 'success':
            bgColor = '#67c23a';
            break;

          case 'warning':
            bgColor = '#e6a23c';
            break;

          case 'exception':
            bgColor = '#f56c6c';
            break;

          default:
            break;
        }
      }

      if (this.dataModel.diam) {
        diam = this.dataModel.diam;
      }

      if (this.dataModel.circle) {
        bodyHtml += indent + "<canvas id=\"canvas\" width=\"".concat(diam, "\" height=\"").concat(diam, "\"></canvas>");
      } else {
        bodyHtml += indent + "<div class=\"tfp-progress-bar\">\n                     <div class=\"tfp-progress-bar__outer\">\n                       <div class=\"tfp-progress-bar__inner\" style=\"width: ".concat(val, "%;background-color:").concat(bgColor, ";\"></div>\n                     </div>\n                  </div>");
        bodyHtml += indent + "<div class=\"tfp-progress__text\" style=\"font-size: 14.4px;\">".concat(val, "%</div>");
      }

      return bodyHtml;
    }
  }, {
    key: "circleStyle",
    value: function circleStyle() {
      var that = this;

      var c = that._jqObj.find('#canvas')[0];

      var ctx = c.getContext('2d');
      var precent = that.dataModel.value;
      var dif = this.dataModel.diam / 300;
      drawTrack();
      drawProgress(precent);
      drawText(precent); //绘制轨道

      function drawTrack() {
        ctx.save();
        ctx.beginPath();
        ctx.lineCap = 'round';
        ctx.lineWidth = 12 * dif;
        ctx.strokeStyle = '#ebeef5';
        ctx.arc(150 * dif, 150 * dif, 140 * dif, 0, 2 * Math.PI);
        ctx.stroke();
        ctx.closePath();
        ctx.restore();
      } //绘制进度环


      function drawProgress(num) {
        ctx.save();
        ctx.beginPath();
        ctx.lineCap = 'round';
        ctx.lineWidth = 12 * dif;
        ctx.strokeStyle = '#6666FF';

        switch (that.dataModel.dataType) {
          case 'success':
            ctx.strokeStyle = '#67c23a';
            break;

          case 'warning':
            ctx.strokeStyle = '#e6a23c';
            break;

          case 'exception':
            ctx.strokeStyle = '#f56c6c';
            break;

          default:
            break;
        }

        ctx.arc(150 * dif, 150 * dif, 140 * dif, -Math.PI / 2, -Math.PI / 2 + 2 * num / 100 * Math.PI);
        ctx.stroke();
        ctx.closePath();
        ctx.restore();
      } //绘制文字


      function drawText(num) {
        var textSize = 40 * dif;
        ctx.save();
        ctx.fillStyle = '#606266';
        ctx.font = '' + textSize + 'px Helvetica';
        ctx.textAlign = 'center';
        ctx.fillText(num + '%', 150 * dif, 160 * dif);
        ctx.restore();
      }
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      if (!this.isRendered) this.reRender();
    }
  }, {
    key: "initDesigning",
    value: function initDesigning() {
      if (this.dataModel.circle) this.circleStyle();
    }
  }]);
  return Progress;
}(_controller.FormInput);

exports["default"] = Progress;