"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 打印报表页组件
 * @param {[type]} dataModel [description]
 */
var PrintReportPage = /*#__PURE__*/function (_ContainerComponent) {
  (0, _inherits2["default"])(PrintReportPage, _ContainerComponent);

  var _super = _createSuper(PrintReportPage);

  function PrintReportPage(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, PrintReportPage);
    return _super.call(this, __tfp, "PrintReportPage", dataModel, parent);
  }

  (0, _createClass2["default"])(PrintReportPage, [{
    key: "resetPageSize",
    value: function resetPageSize() {
      var _pageWidth = 794;
      var _pageHeight = 1123;

      if (this.dataModel.pageSize == "Custom") {
        if (this.dataModel.pageWidth) _pageWidth = this.mmToPx(this.dataModel.pageWidth);
        if (this.dataModel.pageHeight) _pageHeight = this.mmToPx(this.dataModel.pageHeight);
      } else {
        var PAGER_SIZES = {
          "A3": {
            "width": 297,
            "height": 420
          },
          "A4": {
            "width": 210,
            "height": 297
          },
          "A5": {
            "width": 148,
            "height": 210
          },
          "B4": {
            "width": 250,
            "height": 352
          },
          "B5": {
            "width": 176,
            "height": 250
          }
        };
        var _pageSize = PAGER_SIZES[this.dataModel.pageSize];

        if (this.dataModel.orientation == "portrait") {
          _pageWidth = _pageSize.width;
          _pageHeight = _pageSize.height;
        } else {
          _pageWidth = _pageSize.height;
          _pageHeight = _pageSize.width;
        }

        _pageWidth = this.mmToPx(_pageWidth);
        _pageHeight = this.mmToPx(_pageHeight);
      }

      this.dataModel.styles["width"] = _pageWidth + "px";
      this.dataModel.styles["height"] = _pageHeight + "px";

      if (this._jqObj) {
        this._jqObj.css("width", _pageWidth + "px");

        this._jqObj.css("height", _pageHeight + "px");
      }
    }
  }, {
    key: "pageSize",
    get: function get() {
      return this.dataModel.pageSize;
    },
    set: function set(value) {
      this.dataModel.pageSize = value;
      if (!value) this.dataModel.pageSize = "A4";

      if (this.dataModel.pageSize == "Custom") {
        this.dataModel.pageWidth = this.pxToMm(this._jqObj.get(0).offsetWidth);
        this.dataModel.pageHeight = this.pxToMm(this._jqObj.get(0).offsetHeight);

        if (this._tfp.isDesigning) {
          window.parent.$(".cpt-attr[attr-name=pageWidth]").find("input").val(this.dataModel.pageWidth);
          window.parent.$(".cpt-attr[attr-name=pageHeight]").find("input").val(this.dataModel.pageHeight);
        }
      } else {
        delete this.dataModel.pageWidth;
        delete this.dataModel.pageHeight;

        if (this._tfp.isDesigning) {
          window.parent.$(".cpt-attr[attr-name=pageWidth]").find("input").val("");
          window.parent.$(".cpt-attr[attr-name=pageHeight]").find("input").val("");
        }
      }

      this.resetPageSize();
    }
  }, {
    key: "orientation",
    get: function get() {
      return this.dataModel.orientation;
    },
    set: function set(value) {
      this.dataModel.orientation = value;
      if (!value) this.dataModel.orientation = "portrait";
      this.resetPageSize();
    }
  }, {
    key: "pageWidth",
    get: function get() {
      return this.dataModel.pageWidth;
    },
    set: function set(value) {
      this.dataModel.pageWidth = value;
      this.resetPageSize();
    }
  }, {
    key: "pageHeight",
    get: function get() {
      return this.dataModel.pageHeight;
    },
    set: function set(value) {
      this.dataModel.pageHeight = value;
      this.resetPageSize();
    }
  }, {
    key: "paddingTop",
    get: function get() {
      return this.dataModel.paddingTop;
    },
    set: function set(value) {
      this.dataModel.paddingTop = value;
      if (!value) value = 5;
      this.dataModel.styles["padding-top"] = this.mmToPx(value) + "px";
      if (this._jqObj) this._jqObj.css("padding-top", this.mmToPx(value) + "px");
    }
  }, {
    key: "paddingBottom",
    get: function get() {
      return this.dataModel.paddingBottom;
    },
    set: function set(value) {
      this.dataModel.paddingBottom = value;
      if (!value) value = 5;
      this.dataModel.styles["padding-bottom"] = this.mmToPx(value) + "px";
      if (this._jqObj) this._jqObj.css("padding-bottom", this.mmToPx(value) + "px");
    }
  }, {
    key: "paddingLeft",
    get: function get() {
      return this.dataModel.paddingLeft;
    },
    set: function set(value) {
      this.dataModel.paddingLeft = value;
      if (!value) value = 5;
      this.dataModel.styles["padding-left"] = this.mmToPx(value) + "px";
      if (this._jqObj) this._jqObj.css("padding-left", this.mmToPx(value) + "px");
    }
  }, {
    key: "paddingRight",
    get: function get() {
      return this.dataModel.paddingRight;
    },
    set: function set(value) {
      this.dataModel.paddingRight = value;
      if (!value) value = 5;
      this.dataModel.styles["padding-right"] = this.mmToPx(value) + "px";
      if (this._jqObj) this._jqObj.css("padding-right", this.mmToPx(value) + "px");
    }
  }, {
    key: "pageHeaderPanel",
    get: function get() {
      return this._tfp.components[this.id + "_page_header"];
    },
    set: function set(value) {}
  }, {
    key: "pageHeaderHeight",
    get: function get() {
      return this.dataModel.pageHeaderHeight;
    },
    set: function set(value) {
      this.dataModel.pageHeaderHeight = parseInt(value);

      var _height = this.mmToPx(value) + "px";

      this.dataModel.components[0].components.forEach(function (cdm) {
        cdm.styles["height"] = _height;
      });

      if (this._jqObj) {
        this._jqObj.find(".tfp-printreport-page-header").css("flex-basis", _height);

        this._jqObj.find(".tfp-printreport-page-header").children("div").css("height", _height);
      }
    }
  }, {
    key: "pageHeaderHidden",
    get: function get() {
      return this.dataModel.pageHeaderHidden ? true : false;
    },
    set: function set(value) {
      this.dataModel.pageHeaderHidden = value ? true : false;

      if (value) {
        this.dataModel.components[0].styles["display"] = "none";
      } else {
        this.dataModel.components[0].styles["display"] = "flex";
      }

      if (this._jqObj) {
        if (!this.dataModel.pageHeaderHidden) {
          this._jqObj.find(".tfp-printreport-page-header").css("display", "flex");
        } else {
          this._jqObj.find(".tfp-printreport-page-header").hide();
        }
      }
    }
  }, {
    key: "reportHeaderPanel",
    get: function get() {
      return this._tfp.components[this.id + "_report_header"];
    },
    set: function set(value) {}
  }, {
    key: "reportHeaderHeight",
    get: function get() {
      return this.dataModel.reportHeaderHeight;
    },
    set: function set(value) {
      this.dataModel.reportHeaderHeight = parseInt(value);

      var _height = this.mmToPx(value) + "px";

      this.dataModel.components[1].styles["height"] = _height;

      if (this._jqObj) {
        this._jqObj.find(".tfp-printreport-report-header").css("flex-basis", _height);
      }
    }
  }, {
    key: "reportHeaderDisplay",
    get: function get() {
      return this.dataModel.reportHeaderDisplay;
    },
    set: function set(value) {
      this.dataModel.reportHeaderDisplay = value;

      if (this._jqObj) {
        if (this.dataModel.reportHeaderDisplay != "none") {
          this._jqObj.find(".tfp-printreport-report-header").show();
        } else {
          this._jqObj.find(".tfp-printreport-report-header").hide();
        }
      }
    }
  }, {
    key: "reportBodyPanel",
    get: function get() {
      return this._tfp.components[this.id + "_report_body"];
    },
    set: function set(value) {}
  }, {
    key: "reportFooterPanel",
    get: function get() {
      return this._tfp.components[this.id + "_report_footer"];
    },
    set: function set(value) {}
  }, {
    key: "reportFooterHeight",
    get: function get() {
      return this.dataModel.reportFooterHeight;
    },
    set: function set(value) {
      this.dataModel.reportFooterHeight = parseInt(value);

      var _height = this.mmToPx(value) + "px";

      this.dataModel.components[3].styles["height"] = _height;

      if (this._jqObj) {
        this._jqObj.find(".tfp-printreport-report-footer").css("flex-basis", _height);
      }
    }
  }, {
    key: "reportFooterDisplay",
    get: function get() {
      return this.dataModel.reportFooterDisplay;
    },
    set: function set(value) {
      this.dataModel.reportFooterDisplay = value;

      if (this._jqObj) {
        if (this.dataModel.reportFooterDisplay != "none") {
          this._jqObj.find(".tfp-printreport-report-footer").show();
        } else {
          this._jqObj.find(".tfp-printreport-report-footer").hide();
        }
      }
    }
  }, {
    key: "pageFooterPanel",
    get: function get() {
      return this._tfp.components[this.id + "_page_footer"];
    },
    set: function set(value) {}
  }, {
    key: "pageFooterHeight",
    get: function get() {
      return this.dataModel.pageFooterHeight;
    },
    set: function set(value) {
      this.dataModel.pageFooterHeight = parseInt(value);

      var _height = this.mmToPx(value) + "px";

      this.dataModel.components[4].components.forEach(function (cdm) {
        cdm.styles["height"] = _height;
      });

      if (this._jqObj) {
        this._jqObj.find(".tfp-printreport-page-footer").css("flex-basis", _height);

        this._jqObj.find(".tfp-printreport-page-footer").children("div").css("height", _height);
      }
    }
  }, {
    key: "pageFooterHidden",
    get: function get() {
      return this.dataModel.pageFooterHidden ? true : false;
    },
    set: function set(value) {
      this.dataModel.pageFooterHidden = value ? true : false;

      if (value) {
        this.dataModel.components[4].styles["display"] = "none";
      } else {
        this.dataModel.components[4].styles["display"] = "flex";
      }

      if (this._jqObj) {
        if (this.dataModel.pageFooterHidden) {
          this._jqObj.find(".tfp-printreport-page-footer").hide();
        } else {
          this._jqObj.find(".tfp-printreport-page-footer").css("display", "flex");
        }
      }
    }
  }, {
    key: "inToPx",
    value: function inToPx(inc) {
      return parseInt(96 * inc, 10);
    }
  }, {
    key: "mmToPx",
    value: function mmToPx(mm) {
      var dpi = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 96;
      // 1 inch = 25.4 millimeters
      var inchPerMillimeter = 1 / 25.4; // 1 inch = dpi pixels

      var pixelsPerInch = dpi; // 转换为英寸

      var inches = mm * inchPerMillimeter; // 转换为像素

      var pixels = inches * pixelsPerInch;
      return parseInt(pixels);
    }
  }, {
    key: "pxToMm",
    value: function pxToMm(px) {
      var dpi = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 96;
      // 转换为英寸
      var inches = px / dpi; // 转换为像素

      var mm = inches * 25.4;
      return parseInt(mm);
    }
    /**
     * 设置指定属性的数据绑定信息
     * @param {*} attr 
     * @param {*} settingData 
     * @param {*} attrSetting 
     */

  }, {
    key: "setDataBindSetting",
    value: function setDataBindSetting(attr, settingData, attrSetting) {
      if (attr.name == "reportHeaderDataQuerySetting") {
        settingData.type = "query";
        settingData.serviceNameSuffix = "query_report_header";
        settingData.serviceComment = "表头数据查询";
        settingData.count = 1;
        attrSetting.dataMember = "data";
      } else if (attr.name == "reportBodyDataQuerySetting") {
        settingData.type = "query";
        settingData.serviceNameSuffix = "query_report_body";
        settingData.serviceComment = "表体数据查询";
        settingData.count = 1;
        attrSetting.dataMember = "data";
      } else if (attr.name == "reportFooterDataQuerySetting") {
        settingData.type = "query";
        settingData.serviceNameSuffix = "query_report_footer";
        settingData.serviceComment = "表尾数据查询";
        settingData.count = 1;
        attrSetting.dataMember = "data";
      }
    }
  }, {
    key: "bindChildCptData",
    value: function bindChildCptData(parentCdm, data) {
      if (!parentCdm.components || parentCdm.components.length == 0 || !data) return;
      var bindData = data; //如果绑定数据是数组，则取数组的第一个元素作为绑定数据对象

      if (Array.isArray(bindData)) {
        if (bindData.length == 0) return;
        bindData = data[0];
      }

      for (var i = 0; i < parentCdm.components.length; i++) {
        var childCdm = parentCdm.components[i];
        if (["Table", "GridView", "DataCard"].includes(childCdm.type)) continue;

        this._tfp.bindCptData(childCdm, bindData);
      }
    }
  }, {
    key: "loadData",
    value: function loadData() {
      var that = this; //加载表头数据

      if (this.dataModel.reportHeaderData) {
        this.bindChildCptData(this.dataModel.components[1], this.dataModel.reportHeaderData);
      } else if (this.dataModel.reportHeaderDataQuerySetting && this.dataModel.reportHeaderDataQuerySetting.servicePath) {
        var querySetting = this.dataModel.reportHeaderDataQuerySetting;
        var options = {
          servicePath: querySetting.servicePath,
          autoShowError: true,
          showLoading: true
        };

        if (querySetting.requestArgs && querySetting.requestArgs.length > 0) {
          options.argSettings = querySetting.requestArgs;
        }

        if (querySetting.encryptRequestArgs) options.encryptRequestArgs = querySetting.encryptRequestArgs;
        if (querySetting.encryptResponseArgs) options.encryptResponseArgs = querySetting.encryptResponseArgs;

        this._tfp.request(options, function (req, res) {
          that.bindChildCptData(that.dataModel.components[1], res.data);
        });
      } //加载表体数据


      if (this.dataModel.reportBodyDataQuerySetting && this.dataModel.reportBodyDataQuerySetting.servicePath) {
        var _querySetting = this.dataModel.reportBodyDataQuerySetting;
        var _options = {
          servicePath: _querySetting.servicePath,
          autoShowError: true,
          showLoading: true
        };

        if (_querySetting.requestArgs && _querySetting.requestArgs.length > 0) {
          _options.argSettings = _querySetting.requestArgs;
        }

        if (_querySetting.encryptRequestArgs) _options.encryptRequestArgs = _querySetting.encryptRequestArgs;
        if (_querySetting.encryptResponseArgs) _options.encryptResponseArgs = _querySetting.encryptResponseArgs;

        this._tfp.request(_options, function (req, res) {
          that.bindChildCptData(that.dataModel.components[2], res.data);
        });
      } //加载表头数据


      if (this.dataModel.reportFooterData) {
        this.bindChildCptData(this.dataModel.components[3], this.dataModel.reportFooterData);
      } else if (this.dataModel.reportFooterDataQuerySetting && this.dataModel.reportFooterDataQuerySetting.servicePath) {
        var _querySetting2 = this.dataModel.reportFooterDataQuerySetting;
        var _options2 = {
          servicePath: _querySetting2.servicePath,
          autoShowError: true,
          showLoading: true
        };

        if (_querySetting2.requestArgs && _querySetting2.requestArgs.length > 0) {
          _options2.argSettings = _querySetting2.requestArgs;
        }

        if (_querySetting2.encryptRequestArgs) _options2.encryptRequestArgs = _querySetting2.encryptRequestArgs;
        if (_querySetting2.encryptResponseArgs) _options2.encryptResponseArgs = _querySetting2.encryptResponseArgs;

        this._tfp.request(_options2, function (req, res) {
          that.bindChildCptData(that.dataModel.components[3], res.data);
        });
      }
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;
      this.loadData();
    }
  }]);
  return PrintReportPage;
}(_controller.ContainerComponent);

exports["default"] = PrintReportPage;