"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "PopupSelection",
  "comment": "弹窗选择",
  "cssFiles": "style.{bgColorMode}.css",
  "attrs": [{
    "name": "inputSetting",
    "comment": "输入项设置",
    "type": "group",
    "items": [{
      "name": "comment",
      "comment": "组件备注",
      "type": "String"
    }, {
      "name": "placeHolder",
      "comment": "输入提示",
      "type": "String",
      "isHtmlAttr": true
    }, {
      "name": "showIcon",
      "comment": "显示图标",
      "type": "Switch",
      "default": true
    }, {
      "name": "dataBindingFormat",
      "comment": "数据绑定格式",
      "type": "String"
    }, {
      "name": "valueType",
      "comment": "值类型",
      "type": "Select",
      "options": [{
        "value": "value",
        "text": "组件值"
      }, {
        "value": "text",
        "text": "组件文本"
      }, {
        "value": "obj",
        "text": "组件对象"
      }],
      "default": "value",
      "notnull": true
    }, {
      "name": "required",
      "comment": "必填",
      "type": "Switch"
    }, {
      "name": "readonly",
      "comment": "只读",
      "type": "Switch"
    }, {
      "name": "disabled",
      "comment": "禁用",
      "type": "Switch"
    }, {
      "name": "encrypted",
      "comment": "加密发送",
      "type": "Switch"
    }]
  }, {
    "name": "dialogSetting",
    "comment": "弹窗设置",
    "type": "group",
    "items": [{
      "name": "dialogPageSetting",
      "comment": "弹窗页面配置",
      "type": "Dialog",
      "path": "taskbuilder-tfp-designer/PopupSelectionDialog.tfp",
      "width": "680px",
      "height": "530px",
      "sendComponents": true
    }]
  }],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
    "width": "120px",
    "height": "30px",
    "line-height": "30px"
  },
  "events": [{
    "name": "onAfterInitRuntime",
    "comment": "组件初始化后",
    "isNotHtmlEvent": true
  }, {
    "name": "onClick",
    "comment": "点击时"
  }, {
    "name": "onChange",
    "comment": "值发生变化时",
    "isNotHtmlEvent": true
  }]
};
exports["default"] = _default;