"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 弹窗选择组件
 * @param {[type]} dataModel [description]
 */
var PopupSelection = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(PopupSelection, _FormInput);

  var _super = _createSuper(PopupSelection);

  function PopupSelection(__tfp, dataModel, parent, inputType) {
    var _this;

    (0, _classCallCheck2["default"])(this, PopupSelection);

    if (inputType) {
      _this = _super.call(this, __tfp, inputType, dataModel, parent);
    } else {
      _this = _super.call(this, __tfp, "PopupSelection", dataModel, parent);
    }

    return (0, _possibleConstructorReturn2["default"])(_this);
  }

  (0, _createClass2["default"])(PopupSelection, [{
    key: "value",
    get: function get() {
      if (this._jqObj && this._jqObj.find("input").val() == "") {
        this.dataModel.value = '';
      }

      return this.dataModel.value;
    },
    set: function set(value) {
      var val = value;

      if (this._tfp.isNull(val)) {
        val = '';
        this.dataModel.value = '';

        this._jqObj.find("input").val('');
      }

      if (val) {
        if (!$.isPlainObject(val)) {
          val = {
            value: val,
            text: val
          };
        } else {
          if (!val.value || !val.text) val = {
            value: val["" + this.dataModel.dialogPageSetting.value + ""],
            text: val["" + this.dataModel.dialogPageSetting.text + ""]
          };
        }

        if (this.dataModel.valueType == 'value') {
          this.dataModel.value = val.value;
        } else if (this.dataModel.valueType == 'text') {
          this.dataModel.value = val.text;
        } else {
          this.dataModel.value = val;
        }

        this._jqObj.find("input").val(val.text);
      }

      if (!this._tfp.isDesigning) {
        this.valueOnChange();
        if (this.dataModel["onChange"]) eval(this.dataModel["onChange"]);
      }
    }
  }, {
    key: "placeHolder",
    get: function get() {
      return this.dataModel.placeHolder;
    },
    set: function set(value) {
      this.dataModel.placeHolder = value;

      this._jqObj.find("input").attr("placeholder", value);
    }
  }, {
    key: "iconUrl",
    get: function get() {
      return this._tfp.rootPath + "/src/components/" + this.dataModel.type.toLowerCase() + "/images/icon.png";
    },
    set: function set(value) {} //数据绑定格式

  }, {
    key: "dataBindingFormat",
    get: function get() {
      return this.dataModel.dataBindingFormat;
    },
    set: function set(value) {
      this.dataModel.dataBindingFormat = value;
    }
  }, {
    key: "valueType",
    get: function get() {
      return this.dataModel.valueType ? this.dataModel.valueType : "";
    },
    set: function set(value) {
      if (!this.checkAttrOption("valueType", value)) {
        this._tfp.showMsg("不支持类型：" + value + "！");

        return;
      }

      this.dataModel.valueType = value;
    }
  }, {
    key: "showIcon",
    get: function get() {
      return this.dataModel.showIcon;
    },
    set: function set(value) {
      this.dataModel.showIcon = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.showIcon) {
          if (this._jqObj.find("img").length == 0) {
            this._jqObj.append("<img src=\"" + this.iconUrl + "\" />");
          }
        } else {
          this._jqObj.find("img").remove();
        }

        var iptWidth = "calc(100% - 5px)";
        if (this.dataModel.showIcon) iptWidth = "calc(100% - 30px)";

        this._jqObj.find("input").css("width", iptWidth + "px");
      }
    }
  }, {
    key: "dialogPageSetting",
    get: function get() {
      return this.dataModel.dialogPageSetting;
    },
    set: function set(value) {
      this.dataModel.dialogPageSetting = value;
    }
  }, {
    key: "showPicker",
    value: function showPicker(cb) {
      if (!this.dataModel.dialogPageSetting) return;
      var dialogPageSetting = this.dataModel.dialogPageSetting;
      var tmpPath = dialogPageSetting.path;

      if (tmpPath.startsWith("/web/")) {
        tmpPath = tmpPath.substr(4);
      }

      this._tfp.openDialog("选择数据", tmpPath, dialogPageSetting.width + 'px', dialogPageSetting.height + 'px', null, function (ret) {
        dialogPageSetting.options.forEach(function (element) {
          tfp.get(element.id).value = ret["" + element.field + ""];
        });
        var value = {
          value: ret["" + dialogPageSetting.value + ""],
          text: ret["" + dialogPageSetting.text + ""]
        };
        cb(value);
      });
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      if (this.readonly) {
        this._jqObj.find("input").css({
          "margin-left": "0px",
          "padding-left": "0px"
        });
      }

      this._jqObj.click(function () {
        if (that.readonly || that.disabled) return;
        that.showPicker(function (ret) {
          that.value = ret;
        });
      });

      this._jqObj.hover(function () {
        if (that.disabled || that.readonly) return;

        if (that._tfp.curPage.bgColorMode == "light") {
          that._jqObj.css("background-color", "#F6F6F6");

          that._jqObj.find("input").css("background-color", "#F6F6F6");
        }
      }, function () {
        if (that.disabled || that.readonly) return;

        if (that._tfp.curPage.bgColorMode == "light" && !that._jqObj.find("input").is(":focus")) {
          that._jqObj.css("background-color", "");

          that._jqObj.find("input").css("background-color", "");
        }
      });

      this._jqObj.find("input").focus(function () {
        if (that.disabled || that.readonly) return;
        if (that._tfp.curPage.bgColorMode == "light") that._jqObj.css("outline", "1px solid var(--sys-theme-color)");

        try {
          if (that.dataModel.onFocus) eval(that.dataModel.onFocus);
        } catch (err) {
          console.log(err.message);
        }
      });

      this._jqObj.find("input").blur(function () {
        if (that.disabled || that.readonly) return;

        if (that._tfp.curPage.bgColorMode == "light") {
          that._jqObj.css("outline", "0");

          that._jqObj.css("background-color", "");

          that._jqObj.find("input").css("background-color", "");
        }

        try {
          if (that.dataModel.onBlur) eval(that.dataModel.onBlur);
        } catch (err) {
          console.log(err.message);
        }
      });
    }
  }]);
  return PopupSelection;
}(_controller.FormInput);

exports["default"] = PopupSelection;