"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = _interopRequireDefault(require("../fileupload/controller.js"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 图片上传组件
 * @param {[type]} dataModel [description]
 */
var PhotoUpload = /*#__PURE__*/function (_FileUpload) {
  (0, _inherits2["default"])(PhotoUpload, _FileUpload);

  var _super = _createSuper(PhotoUpload);

  function PhotoUpload(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, PhotoUpload);
    return _super.call(this, __tfp, dataModel, parent, "PhotoUpload");
  }

  (0, _createClass2["default"])(PhotoUpload, [{
    key: "btnText",
    get: function get() {
      return this.dataModel.btnText ? this.dataModel.btnText : "上传图片";
    },
    set: function set(value) {
      this.dataModel.btnText = value;

      if (this._jqObj) {
        this._jqObj.find("input").val(value);

        this.exeEventHandler("onChange");
      }
    }
  }, {
    key: "value",
    get: function get() {
      //if (!this.dataModel.value) return [];
      //if (this._tfp.curPage.dataModel.mobileType == "TaskMsg") return this.dataModel.value;
      var val = [];
      if (!this.files) this.files = [];

      for (var i = 0; i < this.files.length; i++) {
        var f = this.files[i];
        val.push({
          name: f.name,
          code: f.code,
          size: f.size
        });
      }

      this.dataModel.value = val;
      return val;
    },
    set: function set(value) {
      if (!value) {
        this.dataModel.value = [];
      } else {
        if (typeof value == "string") value = JSON.parse(value);
        if (!Array.isArray(value)) return;
        this.files = value;
        this.dataModel.value = value;

        if (this._tfp.curPage.dataModel.mobileType == "TaskMsg") {
          for (var i = 0; i < value.length; i++) {
            this.setHtml(value[i].code);
          }
        } else {
          if (this._jqObj) {
            this._jqObj.find(".tfp-photoupload-images").empty();

            for (var i = 0; i < this.dataModel.value.length; i++) {
              var fileInfo = this.dataModel.value[i];
              var imgHtml = "<div class=\"tfp-photoupload-image\" style=\"margin:" + this.dataModel.imageMargin + "px; \">" + "<img src=\"/Download?fileCode=" + fileInfo.code + "\" width=\"" + this.dataModel.imageWidth + "\" height=\"" + this.dataModel.imageHeight + "\"";

              if (this.dataModel.allowShowBigImage) {
                imgHtml += " onclick=\"tfp.openImage('/Download?fileCode=" + fileInfo.code + "&showImage=true')\" style=\"cursor:pointer;\"";
              }

              imgHtml += "/>";

              if (this.dataModel.allowDelete) {
                imgHtml += "<p align=\"center\"><a href=\"javascript:void(0)\" " + "file-code=\"" + fileInfo.code + "\">删除</a></p>";
              }

              imgHtml += "</div>";

              this._jqObj.find(".tfp-photoupload-images").append(imgHtml);
            }

            if (this.dataModel.allowDelete) {
              var that = this;

              this._jqObj.find("a").click(function () {
                that.deleteFile(this, $(this).attr("file-code"));
              });
            }
          }
        }

        if (!this._tfp.isDesigning) this.exeEventHandler("onChange");
      }
    } //保持唯一

  }, {
    key: "onlyOne",
    get: function get() {
      return this.dataModel.onlyOne;
    },
    set: function set(value) {
      this.dataModel.onlyOne = value;
      this.dataModel.size = 1;

      if (this._tfp.isDesigning && this.dataModel.onlyOne) {
        uiDesigner.setCurCptAttrSettingVal("size", "1");
      }
    } //是否只读

  }, {
    key: "readonly",
    get: function get() {
      return this.dataModel.readonly;
    },
    set: function set(value) {
      this.dataModel.readonly = value ? true : false;
      if (!this.dataModel.readonly) delete this.dataModel.readonly;

      if (this._jqObj && this.dataModel.readonly && !this._tfp.isDesigning) {
        this._jqObj.find(".tfp-photoupload-row").hide();
      }
    } //是否可以查看大图

  }, {
    key: "allowShowBigImage",
    get: function get() {
      return this.dataModel.allowShowBigImage;
    },
    set: function set(value) {
      this.dataModel.allowShowBigImage = value;
    }
  }, {
    key: "imageWidth",
    get: function get() {
      return this.dataModel.imageWidth;
    },
    set: function set(value) {
      this.dataModel.imageWidth = value;

      if (this._jqObj) {
        this._jqObj.find(".tfp-photoupload-image").find("img").css("width", value + "px");
      }
    }
  }, {
    key: "imageHeight",
    get: function get() {
      return this.dataModel.imageHeight;
    },
    set: function set(value) {
      this.dataModel.imageHeight = value;

      if (this._jqObj) {
        this._jqObj.find(".tfp-photoupload-image").find("img").css("height", value + "px");
      }
    }
  }, {
    key: "imageMargin",
    get: function get() {
      return this.dataModel.imageMargin;
    },
    set: function set(value) {
      this.dataModel.imageMargin = value;

      if (this._jqObj) {
        this._jqObj.find(".tfp-photoupload-image").find("img").css("margin", value + "px");
      }
    } // 文件数量

  }, {
    key: "size",
    get: function get() {
      return this.dataModel.size;
    },
    set: function set(value) {
      this.dataModel.size = value;
    }
  }, {
    key: "appCode",
    get: function get() {
      return this.dataModel.appCode;
    },
    set: function set(value) {
      this.dataModel.appCode = value;
    } // 隐藏允许添加

  }, {
    key: "allowAdd",
    get: function get() {
      return this.dataModel.allowAdd;
    },
    set: function set(value) {
      this.dataModel.allowAdd = value;

      if (this._jqObj) {
        if (value) {
          this._jqObj.find(".addImage_box").css("display", 'none');
        } else {
          this._jqObj.find(".addImage_box").css("display", 'flex');
        }
      }
    } //是否压缩图片

  }, {
    key: "compress",
    get: function get() {
      return this.dataModel.compress ? true : false;
    },
    set: function set(value) {
      this.dataModel.compress = value ? true : false;
    }
  }, {
    key: "maxSize",
    get: function get() {
      return this.dataModel.maxSize;
    },
    set: function set(value) {
      this.dataModel.maxSize = value;
    } // 查询 剩余可上传文件数量

  }, {
    key: "getImagelength",
    value: function getImagelength() {
      var that = this;
      var size = Number(that.dataModel.size);
      var imageLength = Number(that._jqObj.find(".image_box").length);

      if (that.dataModel.allowAdd) {
        size = size - imageLength;
      } else {
        size = size - imageLength + 1;
      }

      return size;
    }
  }, {
    key: "selectFile",
    value: function selectFile(cb) {
      var that = this;
      var size = that.getImagelength();

      if (size <= 0) {
        this._tfp.showMsg("最多上传" + that.dataModel.size + "张图片");

        return;
      }

      if (typeof window.tmClient != "undefined") {
        tmClient.showImagePicker({
          isMutiSelect: true,
          isCompress: true,
          maxCount: size
        }, function (imageList) {
          var fileList = [];

          for (var x = 0; x < imageList.length; x++) {
            fileList.push({
              path: imageList[x].path,
              appCode: that.dataModel.appCode,
              appDataId: 0
            });
          }

          tmClient.uploadAttachs({
            files: fileList,
            isShowProgress: true
          }, function (ret) {
            for (var x = 0; x < ret.length; x++) {
              var file = {
                code: ret[x].code,
                path: fileList[x].path
              };
              if (!that.files) that.files = [];
              that.files.push(file);
              that.setHtml(file.code);
            }
          });
        });
      } else {
        var imagesDiv = this._jqObj.find(".tfp-photoupload-images");

        imagesDiv.append("<div class=\"tfp-photoupload-image\" style=\"margin:" + this.dataModel.imageMargin + "px;display:none\">" + "<img width=\"" + this.dataModel.imageWidth + "\" height=\"" + this.dataModel.imageHeight + "\" />" + "<input type=\"file\" style=\"display:none\" />" + "<p><progress value=\"0\" max=\"100\"></progress>&nbsp;" + "<span class=\"uploaderPercent\">0%</span></p></div>");

        var _that = this;

        var ipt = imagesDiv.find(".tfp-photoupload-image").last().find("input");
        ipt.change(function () {
          _that.uploadFile(this);
        });
        ipt.click();
      }
    }
  }, {
    key: "setHtml",
    value: function setHtml(fileCode) {
      if (!fileCode) return;
      var that = this;

      var imagesDiv = that._jqObj.find(".panel-box");

      var html = '';
      var src = fileCode;
      html += "\n        <div class=\"image_box\" data-code=\"" + src + "\"\n          style=\"width: 100px;height:100px;position: relative;\n          align-items: center;justify-content: center;margin-bottom: 10px;background: #F7F7F7;margin-right: 10px;display:flex;\">\n          <img class=\"tfp-image\" src=\"/Download?fileCode=" + src + "\" style=\" width:100%; height:100%;\" data-code=\"" + src + "\">\n        ";

      if (!this.dataModel.allowDelete) {
        html += "<div class=\"del_box\" \n            style=\"position:absolute;right:0;top:0;background:none;width:0;height:0;border-top:50px solid rgb(0 0 0 / 58%);\n            border-left:50px solid transparent;\" data-code=\"" + src + "\">\n            <div class=\"tfp-photoupload-delete\" style=\"position:absolute;top:-46px;left:-24px;\"><img class='del-icon' src='/node_modules/tfp/src/components/photoupload/images/icon-delete.png'></div>\n          </div>";
      }

      html += "</div>";
      imagesDiv.prepend(html);
      var size = that.getImagelength();

      if (size <= 0) {
        that._jqObj.find(".addImage_box").css("display", 'none');
      } // 删除指定图片


      that._jqObj.find(".del_box[data-code='" + src + "']").click(function () {
        if (!confirm("确定删除？")) return;
        var code = $(this).attr("data-code");
        var newList = [];

        for (var x = 0; x < that.files.length; x++) {
          if (that.files[x].code != code) {
            newList.push(that.files[x]);
          }
        }

        that.files = newList;

        that._jqObj.find(".image_box[data-code='" + code + "']").remove();

        var size = that.getImagelength();

        if (size > 0) {
          that._jqObj.find(".addImage_box").css("display", 'flex');
        }
      });

      if (that.dataModel.allowShowBigImage) {
        // 查看大图
        this._jqObj.find(".image_box[data-code='" + src + "']").find("img").click(function () {
          if ($(this).hasClass('del-icon')) return;
          var code = $(this).attr("data-code");
          tmClient.showImage({
            imageCode: code
          });
        });
      }
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      if (this._tfp.curPage.dataModel.mobileType == "TaskMsg") {
        this._jqObj.find(".addImage_box").click(function () {
          that.selectFile();
        });
      } else {
        this._jqObj.find(".tfp-photoupload-row").find("input").click(function () {
          that.selectFile();
        });
      }
    }
  }]);
  return PhotoUpload;
}(_controller["default"]);

exports["default"] = PhotoUpload;