"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = _interopRequireDefault(require("../fileupload/controller.js"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 图片上传组件
 * @param {[type]} dataModel [description]
 */
var PhotoUpload = /*#__PURE__*/function (_FileUpload) {
  (0, _inherits2["default"])(PhotoUpload, _FileUpload);

  var _super = _createSuper(PhotoUpload);

  function PhotoUpload(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, PhotoUpload);
    return _super.call(this, __tfp, dataModel, parent, "PhotoUpload");
  }

  (0, _createClass2["default"])(PhotoUpload, [{
    key: "btnText",
    get: function get() {
      return this.dataModel.btnText ? this.dataModel.btnText : "上传图片";
    },
    set: function set(value) {
      this.dataModel.btnText = value;

      if (this._jqObj) {
        this._jqObj.find(".tfp-button").val(value);

        this.exeEventHandler("onChange");
      }
    }
  }, {
    key: "value",
    get: function get() {
      var val = [];
      if (!this.files) this.files = [];

      for (var i = 0; i < this.files.length; i++) {
        var f = this.files[i];
        val.push({
          name: f.name,
          code: f.code,
          size: f.size,
          appCode: this.appCode,
          appDataId: this.appDataId
        });
      }

      this.dataModel.value = val;
      return val;
    },
    set: function set(value) {
      if (!value) return;
      var val = value;

      if (typeof val == "string") {
        if (val.startsWith("[") && val.endsWith("]")) {
          val = JSON.parse(val);
        } else {
          //如果绑定的是某一个附件的附件代码，则查询该附件的信息
          var regex = /^[A-Za-z0-9]{32}$/;

          if (regex.test(val)) {
            this.onAfterBindData({
              fileCode: val
            });
            return;
          }
        }
      }

      if (!Array.isArray(val)) return;
      this.files = val;
      this.dataModel.value = val;

      if (this._jqObj) {
        this._jqObj.find(".tfp-photoupload-images").empty();

        var imgList = [];

        for (var i = 0; i < this.dataModel.value.length; i++) {
          var fileInfo = this.dataModel.value[i];
          imgList.push(fileInfo.code);
          var imgHtml = "<div class=\"tfp-photoupload-image\" style=\"margin:" + this.dataModel.imageMargin + "px; \">" + "<img src=\"/Download?fileCode=" + fileInfo.code + "\" data-index=" + i + " width=\"" + this.dataModel.imageWidth + "\" height=\"" + this.dataModel.imageHeight + "\""; // if (this.dataModel.allowShowBigImage) {
          //   imgHtml += " onclick=\"tfp.openImage('/Download?fileCode="
          //     + fileInfo.code + "&showImage=true')\" style=\"cursor:pointer;\"";
          // }

          imgHtml += "/>";

          if (this.dataModel.allowDelete) {
            imgHtml += "<p align=\"center\"><a href=\"javascript:void(0)\" " + "file-code=\"" + fileInfo.code + "\">删除</a></p>";
          }

          imgHtml += "</div>";

          this._jqObj.find(".tfp-photoupload-images").append(imgHtml);
        }

        var that = this;

        if (this.dataModel.allowDelete) {
          this._jqObj.find("a").click(function () {
            that.deleteFile(this, $(this).attr("file-code"));
          });
        }

        if (this.dataModel.allowShowBigImage) {
          this._jqObj.find("img").click(function () {
            tfp.openImage(JSON.stringify(imgList), $(this).attr("data-index"));
          });
        }

        this.exeEventHandler("onChange");
      }
    } //保持唯一

  }, {
    key: "onlyOne",
    get: function get() {
      return this.dataModel.onlyOne;
    },
    set: function set(value) {
      this.dataModel.onlyOne = value;
      this.dataModel.size = 1;

      if (this._tfp.isDesigning && this.dataModel.onlyOne) {
        uiDesigner.setCurCptAttrSettingVal("size", "1");
      }
    } //是否只读

  }, {
    key: "readonly",
    get: function get() {
      return this.dataModel.readonly;
    },
    set: function set(value) {
      this.dataModel.readonly = value ? true : false;
      if (!this.dataModel.readonly) delete this.dataModel.readonly;

      if (this._jqObj && this.dataModel.readonly && !this._tfp.isDesigning) {
        this._jqObj.find(".tfp-photoupload-row").hide();
      }
    } //是否可以查看大图

  }, {
    key: "allowShowBigImage",
    get: function get() {
      return this.dataModel.allowShowBigImage;
    },
    set: function set(value) {
      this.dataModel.allowShowBigImage = value;
    }
  }, {
    key: "imageWidth",
    get: function get() {
      return this.dataModel.imageWidth;
    },
    set: function set(value) {
      this.dataModel.imageWidth = value;

      if (this._jqObj) {
        this._jqObj.find(".tfp-photoupload-image").find("img").css("width", value + "px");
      }
    }
  }, {
    key: "imageHeight",
    get: function get() {
      return this.dataModel.imageHeight;
    },
    set: function set(value) {
      this.dataModel.imageHeight = value;

      if (this._jqObj) {
        this._jqObj.find(".tfp-photoupload-image").find("img").css("height", value + "px");
      }
    }
  }, {
    key: "imageMargin",
    get: function get() {
      return this.dataModel.imageMargin;
    },
    set: function set(value) {
      this.dataModel.imageMargin = value;

      if (this._jqObj) {
        this._jqObj.find(".tfp-photoupload-image").find("img").css("margin", value + "px");
      }
    } //是否压缩图片

  }, {
    key: "compress",
    get: function get() {
      return this.dataModel.compress ? true : false;
    },
    set: function set(value) {
      this.dataModel.compress = value ? true : false;
    }
  }, {
    key: "maxSize",
    get: function get() {
      return this.dataModel.maxSize;
    },
    set: function set(value) {
      this.dataModel.maxSize = value;
    }
  }, {
    key: "selectFile",
    value: function selectFile() {
      if (!this.size) this.size = 10;

      if (this.size && this.files && this.files.length >= this.size) {
        this._tfp.showMsg("最多只能上传" + this.size + "张图片！");

        return;
      }

      var imagesDiv = this._jqObj.find(".tfp-photoupload-images");

      imagesDiv.append("<div class=\"tfp-photoupload-image\" style=\"margin:" + this.dataModel.imageMargin + "px;display:none\">" + "<img width=\"" + this.dataModel.imageWidth + "\" height=\"" + this.dataModel.imageHeight + "\" />" + "<input type=\"file\" style=\"display:none\" />" + "<p><progress value=\"0\" max=\"100\"></progress>&nbsp;" + "<span class=\"uploaderPercent\">0%</span></p></div>");
      var that = this;
      var ipt = imagesDiv.find(".tfp-photoupload-image").last().find("input");
      ipt.change(function () {
        that.uploadFile(this);
      });
      ipt.click();
    }
  }, {
    key: "onAfterBindData",
    value: function onAfterBindData(data) {
      var args = {};

      if (data && data.fileCode) {
        args.file_code = data.fileCode;
      } else if (this.dataModel.appCode && this.dataModel.appDataId) {
        args.app_code = this.dataModel.appCode;
        args.app_data_id = this.dataModel.appDataId;
      } //应用代码和应用数据id都设置了才能自动查询附件信息


      if (!(args.file_code || args.app_code && args.app_data_id)) return;
      var that = this;

      this._tfp.use("Service", function () {
        var service = that._tfp["new"]("Service");

        service.path = "sys/service/app_attach/getUploadCptVal.tbs";
        service.request(args, function (req, res) {
          if (!res.data) return;
          that.value = res.data;
        });
      });
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      this._jqObj.find(".tfp-photoupload-row").find(".tfp-button").click(function () {
        if (that.readonly || that.disabled) return;
        that.selectFile();
      });
    }
  }]);
  return PhotoUpload;
}(_controller["default"]);

exports["default"] = PhotoUpload;