"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = _interopRequireDefault(require("../fileupload/controller.js"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 图片上传组件
 * @param {[type]} dataModel [description]
 */
var PhotoUpload = /*#__PURE__*/function (_FileUpload) {
  (0, _inherits2["default"])(PhotoUpload, _FileUpload);

  var _super = _createSuper(PhotoUpload);

  function PhotoUpload(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, PhotoUpload);
    return _super.call(this, __tfp, dataModel, parent, "PhotoUpload");
  } //保持唯一


  (0, _createClass2["default"])(PhotoUpload, [{
    key: "onlyOne",
    get: function get() {
      return this.dataModel.onlyOne;
    },
    set: function set(value) {
      this.dataModel.onlyOne = value;
      this.dataModel.size = 1;

      if (this._tfp.isDesigning && this.dataModel.onlyOne) {
        uiDesigner.setCurCptAttrSettingVal("size", "1");
      }
    } // 文件数量

  }, {
    key: "size",
    get: function get() {
      return this.dataModel.size;
    },
    set: function set(value) {
      this.dataModel.size = value;
    } // 图片宽度

  }, {
    key: "imageWidth",
    get: function get() {
      return this.dataModel.imageWidth;
    },
    set: function set(value) {
      this.dataModel.imageWidth = value;

      if (this._jqObj) {
        if (value == '19') {
          this._jqObj.find(".image_box").css("height", "70px");

          this.dataModel.imageHeight = 70;
        } else if (value == '24') {
          this._jqObj.find(".image_box").css("height", "90px");

          this.dataModel.imageHeight = 90;
        } else if (value == '32') {
          this._jqObj.find(".image_box").css("height", "115px");

          this.dataModel.imageHeight = 115;
        } else if (value == '49') {
          this._jqObj.find(".image_box").css("height", "175px");

          this.dataModel.imageHeight = 175;
        } else if (value == '99') {
          this._jqObj.find(".image_box").css("height", "175px");

          this.dataModel.imageHeight = 175;
        }

        this._jqObj.find(".image_box").css("width", value + "%");
      }
    } // 图片高度

  }, {
    key: "imageHeight",
    get: function get() {
      return this.dataModel.imageHeight;
    },
    set: function set(value) {
      this.dataModel.imageHeight = value;

      if (this._jqObj) {
        this._jqObj.find(".image_box").css("height", value + "px");
      }
    } // 图片边距

  }, {
    key: "imageMargin",
    get: function get() {
      return this.dataModel.imageMargin;
    },
    set: function set(value) {
      this.dataModel.imageMargin = value;

      if (this._jqObj) {
        this._jqObj.find(".image_box").css("margin-bottom", value + "%");

        this._jqObj.find(".image_box").css("margin-right", value + "%");
      }
    } // 隐藏允许删除

  }, {
    key: "allowDelete",
    get: function get() {
      return this.dataModel.allowDelete;
    },
    set: function set(value) {
      this.dataModel.allowDelete = value;

      if (this._jqObj) {
        if (value) {
          this._jqObj.find(".image_box.delImage_box").css("display", 'none');
        } else {
          this._jqObj.find(".image_box.delImage_box").css("display", 'flex');
        }
      }
    } // 隐藏允许添加

  }, {
    key: "allowAdd",
    get: function get() {
      return this.dataModel.allowAdd;
    },
    set: function set(value) {
      this.dataModel.allowAdd = value;

      if (this._jqObj) {
        if (value) {
          this._jqObj.find(".image_box.addImage_box").css("display", 'none');
        } else {
          this._jqObj.find(".image_box.addImage_box").css("display", 'flex');
        }
      }
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;
      that.dataModel.imageWidth = '24';
    }
  }]);
  return PhotoUpload;
}(_controller["default"]);

exports["default"] = PhotoUpload;