"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "Pay",
  "comment": "支付服务",
  "attrs": [{
    "name": "path",
    "comment": "支付回调路径",
    "type": "ServicePicker"
  }, {
    "name": "argSettings",
    "comment": "请求参数",
    "type": "Dataset",
    "columns": [{
      "id": "name",
      "name": "参数名",
      "type": "String",
      "required": true
    }, {
      "id": "type",
      "name": "参数类型",
      "type": "Select",
      "width": "100px",
      "options": [{
        "value": "Default",
        "text": "默认"
      }, {
        "value": "ComponentVal",
        "text": "组件值"
      }, {
        "value": "ComponentAttr",
        "text": "组件属性"
      }, {
        "value": "QueryString",
        "text": "URL参数"
      }, {
        "value": "DialogArg",
        "text": "对话框参数"
      }, {
        "value": "Expression",
        "text": "表达式"
      }]
    }, {
      "id": "value",
      "name": "参数值",
      "type": "String",
      "width": "150px"
    }]
  }, {
    "name": "autoReload",
    "comment": "参数变化时自动重载",
    "type": "Switch"
  }, {
    "name": "autoShowError",
    "comment": "自动显示错误提示",
    "type": "Switch",
    "default": true
  }, {
    "name": "pathName",
    "comment": "支付路径名称",
    "selectType": "pay",
    "type": "Select",
    "options": []
  }],
  "events": [{
    "name": "onRequest",
    "comment": "请求服务时",
    "isNotHtmlEvent": true,
    "eventArgs": "",
    "args": [{
      "name": "args",
      "type": "Object",
      "comment": "请求参数"
    }]
  }, {
    "name": "onResponse",
    "comment": "服务响应时",
    "isNotHtmlEvent": true,
    "eventArgs": "",
    "args": [{
      "name": "req",
      "type": "Object",
      "comment": "请求参数"
    }, {
      "name": "res",
      "type": "Object",
      "comment": "响应参数"
    }]
  }, {
    "name": "onError",
    "comment": "发生错误时",
    "isNotHtmlEvent": true,
    "eventArgs": "",
    "args": [{
      "name": "msg",
      "type": "String",
      "comment": "错误消息"
    }]
  }],
  "methods": [{
    "name": "confirmOrder",
    "comment": "发送支付请求",
    "args": [{
      "name": "args",
      "comment": "请求参数",
      "type": "Object"
    }, {
      "name": "cb",
      "comment": "回调函数",
      "type": "string"
    }]
  }]
};
exports["default"] = _default;