"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "PathPicker",
  "comment": "路径",
  "cssFiles": ["style.{bgColorMode}.css", {
    "src": "/node_modules/tfp/src/components/pathpicker/PathPicker.css",
    "onlyRuntime": true
  }],
  "attrs": [{
    "name": "inputSetting",
    "comment": "输入项设置",
    "type": "group",
    "items": [{
      "name": "value",
      "comment": "组件值",
      "type": "String",
      "isHtmlAttr": true
    }, {
      "name": "placeHolder",
      "comment": "输入提示",
      "type": "String",
      "isHtmlAttr": true
    }, {
      "name": "length",
      "comment": "输入框长度",
      "type": "Int",
      "isHtmlAttr": true
    }, {
      "name": "dataBindingFormat",
      "comment": "数据绑定格式",
      "type": "String"
    }, {
      "name": "fileTypes",
      "comment": "文件类型",
      "type": "String"
    }]
  }, {
    "name": "onlyDir",
    "comment": "仅选择目录",
    "type": "Switch",
    "default": false
  }, {
    "name": "listServerFile",
    "comment": "选择服务器端文件",
    "type": "Switch",
    "default": false
  }, {
    "name": "listClientFile",
    "comment": "选择前端文件",
    "type": "Switch",
    "default": false
  }],
  "styles": ["position", "margin", "border", "other"],
  "defaultStyles": {},
  "events": [{
    "name": "onAfterInitRuntime",
    "comment": "组件初始化后",
    "isNotHtmlEvent": true
  }, {
    "name": "onClick",
    "comment": "点击时"
  }, {
    "name": "onFocus",
    "comment": "获得焦点时",
    "isNotHtmlEvent": true
  }, {
    "name": "onBlur",
    "comment": "失去焦点时",
    "isNotHtmlEvent": true
  }, {
    "name": "onChange",
    "comment": "值发生变化时",
    "isNotHtmlEvent": true
  }]
};
exports["default"] = _default;