"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 路径选择组件
 * @param {[type]} dataModel [description]
 */
var PathPicker = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(PathPicker, _FormInput);

  var _super = _createSuper(PathPicker);

  function PathPicker(__tfp, dataModel, parent, inputType) {
    var _this;

    (0, _classCallCheck2["default"])(this, PathPicker);

    if (inputType) {
      _this = _super.call(this, __tfp, inputType, dataModel, parent);
    } else {
      _this = _super.call(this, __tfp, "PathPicker", dataModel, parent);
    }

    return (0, _possibleConstructorReturn2["default"])(_this);
  }

  (0, _createClass2["default"])(PathPicker, [{
    key: "value",
    get: function get() {
      return this.dataModel.value;
    },
    set: function set(value) {
      if (this._jqObj.find('.tfp-pathpicker-input').val()) {
        this.dataModel.value = this._jqObj.find('.tfp-pathpicker-input').val();
      }

      if (!value) {
        this._jqObj.find('.tfp-pathpicker-input').val('');

        this.dataModel.value = '';
        return;
      }

      this.dataModel.value = value;
      if (this._jqObj) this._jqObj.find('.tfp-pathpicker-input').val(this.dataModel.value);
    }
  }, {
    key: "length",
    get: function get() {
      return this.dataModel.length;
    },
    set: function set(value) {
      if (!value) {
        this._jqObj.find('.tfp-pathpicker-input').css('width', '320px');

        this.dataModel.length = '';
        return;
      }

      this.dataModel.length = value;
      if (this._jqObj) this._jqObj.find('.tfp-pathpicker-input').css('width', this.dataModel.length);
    }
  }, {
    key: "placeHolder",
    get: function get() {
      return this.dataModel.placeHolder;
    },
    set: function set(value) {
      if (!value) {
        this._jqObj.find('.tfp-pathpicker-input').attr("placeholder", '');

        this.dataModel.placeHolder = '';
        return;
      }

      this.dataModel.placeHolder = value;
      if (this._jqObj) this._jqObj.find('.tfp-pathpicker-input').attr("placeholder", this.dataModel.placeHolder);
    }
  }, {
    key: "fileTypes",
    get: function get() {
      return this.dataModel.fileTypes;
    },
    set: function set(value) {
      this.dataModel.fileTypes = value;
    }
  }, {
    key: "onlyDir",
    get: function get() {
      return this.dataModel.onlyDir;
    },
    set: function set(value) {
      this.dataModel.onlyDir = value ? true : false;
    }
  }, {
    key: "listServerFile",
    get: function get() {
      return this.dataModel.listServerFile;
    },
    set: function set(value) {
      this.dataModel.listServerFile = value ? true : false;
    }
  }, {
    key: "listClientFile",
    get: function get() {
      return this.dataModel.listClientFile;
    },
    set: function set(value) {
      this.dataModel.listClientFile = value ? true : false;
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      var btnPathPicker = this._jqObj.find(".tfp-pathpicker-choose");

      btnPathPicker.click(function () {
        var args = {
          onlyDir: that.dataModel.onlyDir,
          listServerFile: that.dataModel.listServerFile,
          listClientFile: that.dataModel.listClientFile
        };

        that._tfp.openDialog("选择路径", "/node_modules/tfp/src/components/pathpicker/PathPicker.tfp", '502px', '503px', args, function (filePath) {
          var tmpPath = filePath;

          if (tmpPath.startsWith("/app/") && that.dataModel.listServerFile) {
            tmpPath = tmpPath.substr(5);
          } else if (tmpPath.startsWith("/web/")) {
            tmpPath = tmpPath.substr(4);
          }

          that.value = tmpPath;
          that.valueOnChange();
          that.exeEventHandler("onChange", tmpPath);
        }); //sessionStorage.setItem('_OpenDialogArgs', JSON.stringify(args));

      });

      this._jqObj.find(".tfp-pathpicker-input").blur(function () {
        var val = $(this).val().trim();

        if (!isNull(val)) {
          that.dataModel.value = val;
          that.valueOnChange();
          that.exeEventHandler("onChange", val);
        }

        if (that.disabled) return;

        try {
          if (that.dataModel.onBlur) eval(that.dataModel.onBlur);
        } catch (err) {
          console.log(err.message);
        }
      });

      this._jqObj.find("input").focus(function () {
        if (that.disabled) return;

        try {
          if (that.dataModel.onFocus) eval(that.dataModel.onFocus);
        } catch (err) {
          console.log(err.message);
        }
      });
    }
  }]);
  return PathPicker;
}(_controller.FormInput);

exports["default"] = PathPicker;