"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "Page",
  "comment": "页面",
  "attrs": [{
    "name": "common",
    "comment": "页面信息",
    "type": "group",
    "items": [{
      "name": "client",
      "comment": "终端类型",
      "type": "Select",
      "readonly": true,
      "options": [{
        "value": "pc",
        "text": "电脑端"
      }, {
        "value": "phone",
        "text": "手机端"
      }]
    }, {
      "name": "mobileType",
      "comment": "移动端类型",
      "type": "Select",
      "readonly": true,
      "options": [{
        "value": "H5",
        "text": "H5"
      }, {
        "value": "TaskMsg",
        "text": "任讯"
      }, {
        "value": "dingding",
        "text": "阿里钉钉"
      }, {
        "value": "workweixin",
        "text": "企业微信"
      }]
    }, {
      "name": "positionType",
      "comment": "组件默认定位方式",
      "type": "Select",
      "readonly": true,
      "options": [{
        "value": "float",
        "text": "浮动定位"
      }, {
        "value": "absolute",
        "text": "绝对定位"
      }]
    }, {
      "name": "framework",
      "comment": "前端UI框架",
      "type": "String",
      "readonly": true
    }, {
      "name": "pageType",
      "comment": "页面类型",
      "type": "Select",
      "readonly": true,
      "options": [{
        "value": "page",
        "text": "普通页面"
      }, {
        "value": "dialog",
        "text": "弹出窗口"
      }, {
        "value": "drawer",
        "text": "抽屉页"
      }, {
        "value": "component",
        "text": "用户自定义组件"
      }]
    }, {
      "name": "title",
      "comment": "标题",
      "type": "String",
      "hidden": "'{pageType}'=='component'"
    }, // {
    //   "name": "lang",
    //   "comment": "语言",
    //   "type": "Select",
    //   "options": [
    //     {
    //       "value": "zh",
    //       "text": "中文"
    //     },
    //     {
    //       "value": "en",
    //       "text": "英文"
    //     },
    //     {
    //       "value": "en-us",
    //       "text": "美式英文"
    //     },
    //     {
    //       "value": "ja",
    //       "text": "日文"
    //     },
    //     {
    //       "value": "fr",
    //       "text": "法文"
    //     },
    //     {
    //       "value": "da",
    //       "text": "德文"
    //     },
    //     {
    //       "value": "ko",
    //       "text": "韩文"
    //     },
    //     {
    //       "value": "ru",
    //       "text": "俄文"
    //     },
    //     {
    //       "value": "it",
    //       "text": "意大利文"
    //     },
    //     {
    //       "value": "es",
    //       "text": "西班牙文"
    //     }
    //   ]
    // },
    {
      "name": "docType",
      "comment": "文档规范",
      "type": "Select",
      "options": [{
        "value": "HTML5",
        "text": "HTML5规范"
      }, {
        "value": "NONE",
        "text": "无声明"
      }]
    }, {
      "name": "enableCache",
      "comment": "启用缓存",
      "type": "Switch",
      "default": true
    }, {
      "name": "bgColorMode",
      "comment": "页面背景颜色模式",
      "type": "Select",
      "options": [{
        "value": "light",
        "text": "浅色背景"
      }, {
        "value": "dark",
        "text": "深色背景"
      }],
      "default": "light"
    }, {
      "name": "metas",
      "comment": "页面元数据",
      "type": "Dataset",
      "columns": [{
        "id": "name",
        "name": "元数据名称",
        "type": "String",
        "width": "150px",
        "required": true
      }, {
        "id": "content",
        "name": "元数据内容",
        "type": "String",
        "width": "360px",
        "required": true
      }]
    }, {
      "name": "rules",
      "comment": "业务规则",
      "type": "Rules"
    }, {
      "name": "formulas",
      "comment": "计算表达式",
      "type": "Formulas"
    }]
  }, {
    "name": "dialog",
    "comment": "对话框属性",
    "type": "group",
    "hidden": "'{pageType}'!='dialog'",
    "items": [{
      "name": "width",
      "comment": "宽度",
      "type": "String"
    }, {
      "name": "height",
      "comment": "高度",
      "type": "String"
    }]
  }],
  "styles": ["font", "background", "margin", "border"],
  "events": [{
    "name": "onBeforeInitRuntime",
    "comment": "页面加载前",
    "args": [{
      "name": "cb",
      "comment": "页数",
      "type": "Function",
      "required": true
    }]
  }, {
    "name": "onLoad",
    "comment": "页面加载后",
    "isNotHtmlEvent": true
  }, {
    "name": "onClick",
    "comment": "点击页面时"
  }, {
    "name": "onClose",
    "comment": "关闭页面时",
    "isNotHtmlEvent": true
  }, {
    "name": "onClickDrawerOKButton",
    "comment": "点击抽屉页确定按钮时"
  }, {
    "name": "onClickDrawerCancelButton",
    "comment": "点击抽屉页取消按钮时"
  }]
};
exports["default"] = _default;