"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var Page = /*#__PURE__*/function (_ContainerComponent) {
  (0, _inherits2["default"])(Page, _ContainerComponent);

  var _super = _createSuper(Page);

  function Page(__tfp, dataModel) {
    var _this;

    (0, _classCallCheck2["default"])(this, Page);
    _this = _super.call(this, __tfp, "Page", dataModel);

    if (__tfp.isRuntime) {
      if (dataModel.client != 'mini') {
        if (dataModel.pageElId) {
          _this._jqObj = $("#" + dataModel.pageElId);
        } else {
          _this._jqObj = $("body");
        }

        _this.el = _this._jqObj.get(0);
        if (_this.dataModel.title) $("title").text(_this.dataModel.title); //初始化页面样式

        if (_this.dataModel.styles) {
          for (var style in _this.dataModel.styles) {
            _this._jqObj.css(style, _this.dataModel.styles[style]);
          }
        }
      }
    }

    return _this;
  }

  (0, _createClass2["default"])(Page, [{
    key: "client",
    get: function get() {
      return this.dataModel.client;
    }
  }, {
    key: "positionType",
    get: function get() {
      return this.dataModel.positionType;
    }
  }, {
    key: "framework",
    get: function get() {
      return this.dataModel.framework;
    }
  }, {
    key: "pageType",
    get: function get() {
      return this.dataModel.pageType;
    }
  }, {
    key: "cssFiles",
    get: function get() {
      return this.dataModel.cssFiles;
    },
    set: function set(value) {
      this.dataModel.cssFiles = value;
    }
  }, {
    key: "jsFiles",
    get: function get() {
      return this.dataModel.jsFiles;
    },
    set: function set(value) {
      this.dataModel.jsFiles = value;
    }
  }, {
    key: "styleSheets",
    get: function get() {
      return this.dataModel.styleSheets;
    },
    set: function set(value) {
      this.dataModel.styleSheets = value;
    }
  }, {
    key: "title",
    get: function get() {
      return this.dataModel.title;
    },
    set: function set(value) {
      this.dataModel.title = value;
      $("title").text(value);

      if (this._tfp.isDesigning) {
        if (this.client == "phone" || this.client == "mini") {
          // window.parent.$("#divPhonePageTitle").html(value);
          window.parent.$("#uiDesignerPageTitle").html(value);
        } else if (this.pageType == "dialog") {
          window.parent.$("#uiDesignerPageTitle").html("&nbsp;&nbsp;" + value);
        }
      }
    }
    /**
     * 背景颜色模式
     */

  }, {
    key: "bgColorMode",
    get: function get() {
      return this.dataModel.bgColorMode;
    },
    set: function set(value) {
      this.dataModel.bgColorMode = value;
    }
    /**
     * 内容颜色模式，与背景相反
     */

  }, {
    key: "contentColorMode",
    get: function get() {
      return this.dataModel.bgColorMode == "dark" ? "light" : "dark";
    },
    set: function set(value) {}
  }, {
    key: "width",
    get: function get() {
      return this.dataModel.pageType == "dialog" ? this.dataModel.width : null;
    },
    set: function set(value) {
      if (!value || this.dataModel.pageType != "dialog") return;
      this.dataModel.width = value;

      var _width = value + "";

      if (_width.indexOf("px") < 0 && _width.indexOf("%") < 0) {
        _width += "px";
      } //设置设计和运行时宽度


      if (this._tfp.isDesigning) {
        if (this.pageType == "dialog") {
          window.parent.$("#uiDesignerFrame").css("width", _width);
          window.parent.$("#uiDesignerFrame").find("iframe").css("width", _width);
        }
      } else if (this._tfp.isRuntime) {//
      }
    }
  }, {
    key: "height",
    get: function get() {
      return this.dataModel.pageType == "dialog" ? this.dataModel.height : null;
    },
    set: function set(value) {
      if (!value || this.dataModel.pageType != "dialog") return;
      this.dataModel.height = value;

      var _height = value + "";

      if (_height.indexOf("px") < 0 && _height.indexOf("%") < 0) {
        _height += "px";
      } //TODO 设置设计和运行时宽度


      if (this._tfp.isDesigning) {
        if (this.pageType == "dialog") {
          window.parent.$("#uiDesignerFrame").css("height", _height);
          window.parent.$("#uiDesignerFrame").find("iframe").css("height", parseInt(_height.replace("px", "")) - 31 + "px");
        }
      } else if (this._tfp.isRuntime) {//
      }
    }
  }, {
    key: "render",
    value: function render() {
      (0, _get2["default"])((0, _getPrototypeOf2["default"])(Page.prototype), "render", this).call(this);

      if (this._tfp.isDesigning) {
        if (this.dataModel.style) {
          $("body").attr("style", this.dataModel.style);
        }

        if (this.dataModel.styles) {
          var styles = "";

          for (var styleName in this.dataModel.styles) {
            $("body").css(styleName, this.dataModel.styles[styleName]);
          }
        }

        if (this.dataModel["class"]) {
          $("body").attr("class", this.dataModel["class"]);
        }

        if (this.dataModel.styleSheets) {
          var styleCode = "";

          for (var i = 0; i < this.dataModel.styleSheets.length; i++) {
            var styleSheet = this.dataModel.styleSheets[i];
            styleCode += "\t" + styleSheet.id + " {";

            for (var j = 0; j < styleSheet.styles.length; j++) {
              var style = styleSheet.styles[j];
              styleCode += style.name + ": " + style.value + ";";
            }

            styleCode += "}\r\n";
          }

          $("head").append("<style id=\"_tfpPageStyleSetting\">\r\n" + styleCode + "</style>");
        }

        if (this.dataModel.cssFiles) {
          for (var i = 0; i < this.dataModel.cssFiles.length; i++) {
            var cssFile = this.dataModel.cssFiles[i];
            $("head").append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + cssFile + "\">");
          }
        }
      }
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      if (this.dataModel["onLoad"]) {
        eval(this.dataModel["onLoad"]);
      }
    }
  }]);
  return Page;
}(_controller.ContainerComponent);

exports["default"] = Page;