"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _construct2 = _interopRequireDefault(require("@babel/runtime/helpers/construct"));

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var Page = /*#__PURE__*/function (_ContainerComponent) {
  (0, _inherits2["default"])(Page, _ContainerComponent);

  var _super = _createSuper(Page);

  function Page(__tfp, dataModel) {
    var _this;

    (0, _classCallCheck2["default"])(this, Page);
    _this = _super.call(this, __tfp, "Page", dataModel);

    if (__tfp.isRuntime) {
      if (dataModel.client != 'mini') {
        if (dataModel.pageElId) {
          _this._jqObj = $("#" + dataModel.pageElId);
        } else {
          _this._jqObj = $("body");
        }

        _this.el = _this._jqObj.get(0);
        if (_this.dataModel.title) $("title").text(_this.dataModel.title); //初始化页面样式

        if (_this.dataModel.styles) {
          for (var style in _this.dataModel.styles) {
            _this._jqObj.css(style, _this.dataModel.styles[style]);
          }
        }
      }
    } // 计算公式


    _this.formulasDict = {};
    (_this.dataModel.formulas || []).forEach(function (formula) {
      if (!Array.isArray(formula.conditions)) return true; // 寻找当前公式中需要触发的组件

      var cptIds = [];
      var offMarkReg = /\$\{(.*?)\}/g;
      formula.conditions.forEach(function (condition) {
        if (!condition.control) return true;
        cptIds.push(condition.control);
      });
      formula.actions.forEach(function (action) {
        if (!action.formula) return true;
        var fControls = action.formula.match(offMarkReg);
        (fControls || []).forEach(function (fControl) {
          cptIds.push(fControl);
        });
      }); // 去重组件组并遍历组件组添加至页面公式字典中

      (0, _construct2["default"])(Array, (0, _toConsumableArray2["default"])(new Set(cptIds))).forEach(function (cptId) {
        var _getDatasetAndField = getDatasetAndField(cptId),
            _getDatasetAndField2 = (0, _slicedToArray2["default"])(_getDatasetAndField, 2),
            dataset = _getDatasetAndField2[0],
            field = _getDatasetAndField2[1];

        if (field) {
          if (!_this.formulasDict[dataset]) _this.formulasDict[dataset] = {};
          if (!_this.formulasDict[dataset][field]) _this.formulasDict[dataset][field] = [];

          _this.formulasDict[dataset][field].push(formula);
        } else {
          if (!_this.formulasDict[dataset]) _this.formulasDict[dataset] = [];

          _this.formulasDict[dataset].push(formula);
        }
      }); // 获取组件及其字段，${}中带.为子表组件

      function getDatasetAndField(str) {
        str = str.replace(offMarkReg, '$1');
        var temp = str.split('.');
        if (temp.length == 2) return temp;else return [str, null];
      }
    }); // 业务规则

    _this.rulesDict = {};
    (_this.dataModel.rules || []).forEach(function (rule) {
      if (!Array.isArray(rule.conditions)) return true;
      rule.conditions.forEach(function (condition) {
        if (!condition.control) return true;
        if (!_this.rulesDict[condition.control]) _this.rulesDict[condition.control] = [];

        _this.rulesDict[condition.control].push(rule);
      });
    });
    return _this;
  }

  (0, _createClass2["default"])(Page, [{
    key: "client",
    get: function get() {
      return this.dataModel.client;
    }
  }, {
    key: "positionType",
    get: function get() {
      return this.dataModel.positionType;
    }
  }, {
    key: "framework",
    get: function get() {
      return this.dataModel.framework;
    }
  }, {
    key: "pageType",
    get: function get() {
      return this.dataModel.pageType;
    }
  }, {
    key: "mobileType",
    get: function get() {
      return this.dataModel.mobileType;
    }
  }, {
    key: "cssFiles",
    get: function get() {
      return this.dataModel.cssFiles;
    },
    set: function set(value) {
      this.dataModel.cssFiles = value;
    }
  }, {
    key: "jsFiles",
    get: function get() {
      return this.dataModel.jsFiles;
    },
    set: function set(value) {
      this.dataModel.jsFiles = value;
    }
  }, {
    key: "styleSheets",
    get: function get() {
      return this.dataModel.styleSheets;
    },
    set: function set(value) {
      this.dataModel.styleSheets = value;
    }
  }, {
    key: "title",
    get: function get() {
      return this.dataModel.title;
    },
    set: function set(value) {
      this.dataModel.title = value;
      $("title").text(value);

      if (this._tfp.isDesigning) {
        if (this.client == "phone" || this.client == "mini") {
          // window.parent.$("#divPhonePageTitle").html(value);
          window.parent.$("#uiDesignerPageTitle").html(value);
        } else if (this.pageType == "dialog") {
          window.parent.$("#uiDesignerPageTitle").html("&nbsp;&nbsp;" + value);
        }
      }
    }
    /**
     * 背景颜色模式
     */

  }, {
    key: "bgColorMode",
    get: function get() {
      return this.dataModel.bgColorMode;
    },
    set: function set(value) {
      this.dataModel.bgColorMode = value;
    }
    /**
     * 页面语言
     */

  }, {
    key: "lang",
    get: function get() {
      return this.dataModel.lang;
    },
    set: function set(value) {
      this.dataModel.lang = value;
    }
    /**
     * 文档规范
     */

  }, {
    key: "docType",
    get: function get() {
      return this.dataModel.docType;
    },
    set: function set(value) {
      this.dataModel.docType = value;
    }
    /**
     * 内容颜色模式，与背景相反
     */

  }, {
    key: "contentColorMode",
    get: function get() {
      return this.dataModel.bgColorMode == "dark" ? "light" : "dark";
    },
    set: function set(value) {}
  }, {
    key: "width",
    get: function get() {
      return this.dataModel.pageType == "dialog" ? this.dataModel.width : null;
    },
    set: function set(value) {
      if (!value || this.dataModel.pageType != "dialog") return;
      this.dataModel.width = value;

      var _width = value + "";

      if (_width.indexOf("px") < 0 && _width.indexOf("%") < 0) {
        _width += "px";
      } //设置设计和运行时宽度


      if (this._tfp.isDesigning) {
        if (this.pageType == "dialog") {
          window.parent.$("#uiDesignerFrame").css("width", _width);
          window.parent.$("#uiDesignerFrame").find("iframe").css("width", _width);
        }
      } else if (this._tfp.isRuntime) {//
      }
    }
  }, {
    key: "height",
    get: function get() {
      return this.dataModel.pageType == "dialog" ? this.dataModel.height : null;
    },
    set: function set(value) {
      if (!value || this.dataModel.pageType != "dialog") return;
      this.dataModel.height = value;

      var _height = value + "";

      if (_height.indexOf("px") < 0 && _height.indexOf("%") < 0) {
        _height += "px";
      } //TODO 设置设计和运行时宽度


      if (this._tfp.isDesigning) {
        if (this.pageType == "dialog") {
          window.parent.$("#uiDesignerFrame").css("height", _height);
          window.parent.$("#uiDesignerFrame").find("iframe").css("height", parseInt(_height.replace("px", "")) - 40 + "px");
        }
      } else if (this._tfp.isRuntime) {//
      }
    }
  }, {
    key: "metas",
    get: function get() {
      return this.dataModel.metas ? this.dataModel.metas : [];
    },
    set: function set(value) {
      if (this._jqObj && value && Array.isArray(value)) {
        this.dataModel.metas = value;
      }
    }
  }, {
    key: "getContainerEl",
    value: function getContainerEl() {
      if (this.dataModel.pageType == "print-report") {
        return $(".print-page-bg-panel");
      } else if (this.dataModel.pageElId) {
        return $("#" + this.dataModel.pageElId);
      } else {
        return $("body");
      }
    }
  }, {
    key: "render",
    value: function render() {
      (0, _get2["default"])((0, _getPrototypeOf2["default"])(Page.prototype), "render", this).call(this);

      if (this._tfp.isDesigning) {
        if (this.dataModel.style) {
          $("body").attr("style", this.dataModel.style);
        }

        if (this.dataModel.styles) {
          var styles = "";

          for (var styleName in this.dataModel.styles) {
            var styleVal = this._tfp.replaceStyleUrl(this.dataModel.styles[styleName]);

            $("body").css(styleName, styleVal);
          }
        }

        if (this.dataModel["class"]) {
          $("body").attr("class", this.dataModel["class"]);
        }

        if (this.dataModel.styleSheets) {
          var styleCode = "";

          for (var i = 0; i < this.dataModel.styleSheets.length; i++) {
            var styleSheet = this.dataModel.styleSheets[i];
            styleCode += "\t" + styleSheet.id + " {";

            for (var j = 0; j < styleSheet.styles.length; j++) {
              var style = styleSheet.styles[j];
              styleCode += style.name + ": " + style.value + ";";
            }

            styleCode += "}\r\n";
          }

          $("head").append("<style id=\"_tfpPageStyleSetting\">\r\n" + styleCode + "</style>");
        } //设计时在tfp.loadPage()方法里加载页面的css文件了，在这里就不要重复加载了


        if (this.dataModel.cssFiles && !this._tfp.isDesigning) {
          for (var i = 0; i < this.dataModel.cssFiles.length; i++) {
            var cssFile = this.dataModel.cssFiles[i];
            $("head").append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + cssFile + "\">");
          }
        }
      }
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      //如果设置了抽屉页有关的事件
      if (this.dataModel.onClickDrawerOKButton || this.dataModel.onClickDrawerCancelButton) {
        var isDrawer = tfp.getUrlArg("_isDrawer");

        if (isDrawer) {
          try {
            var curDrawer = top.curDrawer;

            if (curDrawer) {
              var that = this;

              if (this.dataModel.onClickDrawerOKButton) {
                curDrawer.find(".divDrawerButtonOK").click(function () {
                  eval(that.dataModel.onClickDrawerOKButton);
                });
              }

              if (this.dataModel.onClickDrawerCancelButton) {
                curDrawer.find(".divDrawerButtonCancel").click(function () {
                  eval(that.dataModel.onClickDrawerCancelButton);
                });
              }
            }
          } catch (err) {
            console.log(err);
          }
        }
      } //设置系统主题色


      var sysThemeColor = "#6666FF";

      if (localStorage.getItem("TaskAdminMainThemeColor")) {
        sysThemeColor = localStorage.getItem("TaskAdminMainThemeColor");
      } else {
        try {
          if (top.local.theme.color.theme_color) sysThemeColor = top.local.theme.color.theme_color;
        } catch (err) {//
        }
      }

      $("#tfp-page-style-var").html("\n\t\t\t:root {\n\t\t\t\t--sys-theme-color: ".concat(sysThemeColor, ";\n\t\t\t}\n\t\t")); //如果设置了页面加载后事件

      if (this.dataModel["onLoad"]) {
        eval(this.dataModel["onLoad"]);
      }
    }
  }]);
  return Page;
}(_controller.ContainerComponent);

exports["default"] = Page;