"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
* 组织结构组件
* @param {[type]} dataModel [description]
*/
var OrgPicker = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(OrgPicker, _FormInput);

  var _super = _createSuper(OrgPicker);

  function OrgPicker(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, OrgPicker);
    return _super.call(this, __tfp, "OrgPicker", dataModel, parent);
  }

  (0, _createClass2["default"])(OrgPicker, [{
    key: "value",
    get: function get() {
      if (this._jqObj && this._jqObj.find("textarea").val() == "") this.dataModel.value = '';
      return this.dataModel.value;
    },
    set: function set(value) {
      if (isNull(value)) {
        this.dataModel.trueId = undefined;
        this.dataModel.value = '';

        if (!this._tfp.isDesigning) {
          this.valueOnChange();
          this.exeEventHandler("onChange", this.dataModel.value);
        }

        return;
      }

      this.dataModel.value = value;

      if (this._jqObj) {
        var names = "";
        var userTureId = [];
        var roleTureId = [];
        var depTureId = [];

        for (var i = 0; i < this.dataModel.value.length; i++) {
          if (this.dataModel.value[i].type == 'user') userTureId.push(this.dataModel.value[i].id);
          if (this.dataModel.value[i].type == 'role') roleTureId.push(this.dataModel.value[i].id);
          if (this.dataModel.value[i].type == 'dep') depTureId.push(this.dataModel.value[i].id);
          if (names != "") names += ",";
          names += this.dataModel.value[i].name;
        }

        this.dataModel.trueId = {
          user: userTureId,
          role: roleTureId,
          dep: depTureId
        };

        this._jqObj.find("textarea").val(names);
      }

      if (!this._tfp.isDesigning) {
        this.valueOnChange();
        this.exeEventHandler("onChange", this.dataModel.value);
      }
    }
  }, {
    key: "placeHolder",
    get: function get() {
      return this.dataModel.placeHolder;
    },
    set: function set(value) {
      this.dataModel.placeHolder = value;
      if (this._jqObj) this._jqObj.find("textarea").attr("placeholder", value);
    }
  }, {
    key: "iconUrl",
    get: function get() {
      return this._tfp.rootPath + "/src/components/" + this.dataModel.type.toLowerCase() + "/images/icon-24-" + this._tfp.curPage.contentColorMode + ".png";
    },
    set: function set(value) {}
  }, {
    key: "showIcon",
    get: function get() {
      return this.dataModel.showIcon;
    },
    set: function set(value) {
      this.dataModel.showIcon = value ? true : false;

      if (this._jqObj) {
        var iptWidth = "100%";

        if (this.dataModel.showIcon) {
          if (this._jqObj.find("img").length == 0) {
            this._jqObj.append("<img src=\"" + this.iconUrl + "\" />");
          }

          iptWidth = "calc(100% - 30px)";
        } else {
          this._jqObj.find("img").remove();
        }

        this._jqObj.find("textarea").css("width", iptWidth);
      }
    }
  }, {
    key: "valueType",
    get: function get() {
      return this.dataModel.valueType;
    },
    set: function set(value) {
      if (!this.checkAttrOption("valueType", value)) {
        this._tfp.showMsg("不支持类型：" + value + "！");

        return;
      }

      this.dataModel.valueType = value;
    }
  }, {
    key: "multiCheck",
    get: function get() {
      return this.dataModel.multiCheck;
    },
    set: function set(value) {
      this.dataModel.multiCheck = value ? true : false;
    }
  }, {
    key: "showPicker",
    value: function showPicker() {
      if (this.dataModel.multiCheck) {
        this._tfp.openDialog("组织结构选择", this._tfp.rootPath + "/src/components/orgpicker/orgsPicker.tfp?cptId=" + this.id + "&trueId=" + JSON.stringify(this.dataModel.trueId), "445px", "540px");
      } else {
        this._tfp.openDialog("组织结构选择", this._tfp.rootPath + "/src/components/orgpicker/orgPicker.tfp?cptId=" + this.id + "&trueId=" + JSON.stringify(this.dataModel.trueId), "445px", "540px");
      }
    }
  }, {
    key: "onSelected",
    value: function onSelected(ret) {
      this.value = ret;
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      this._jqObj.click(function () {
        if (that.readonly || that.disabled) return;
        that.showPicker();
      });
    }
  }]);
  return OrgPicker;
}(_controller.FormInput);

exports["default"] = OrgPicker;