"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _render = _interopRequireDefault(require("../render.js"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var OneAppModule = /*#__PURE__*/function (_TFPComponentRender) {
  (0, _inherits2["default"])(OneAppModule, _TFPComponentRender);

  var _super = _createSuper(OneAppModule);

  function OneAppModule(__tfp, _dataModel, _level) {
    (0, _classCallCheck2["default"])(this, OneAppModule);
    return _super.call(this, __tfp, _dataModel, _level);
  }

  (0, _createClass2["default"])(OneAppModule, [{
    key: "getBodyHtml",
    value: function getBodyHtml(getComponentsHtml, retainStyleAttr) {
      var html = "";
      var indent = this.getHtmlIndent();
      html += indent;
      html += "<div style=\"display:flex;align-items:center;width:100%;justify-content:space-evenly;flex-direction:column;height:100%;\">";

      if (this.dataModel.options) {
        var type = this.dataModel.options.srcJson.type;

        if (type == 'iconfont') {
          html += "<div class=\"" + this.dataModel.options.srcJson["class"] + "\" style=\"font-size: " + this.dataModel.imageWidth + "px;";

          if (this.dataModel.options.srcJson.color) {
            html += "color:" + this.dataModel.options.srcJson.color + ';';
          }

          if (this.dataModel.options.srcJson.bgColor) {
            html += "background-color:" + this.dataModel.options.srcJson.bgColor + ';';
          }

          html += "\"></div>";
        } else if (type == 'httpurl') {
          html += "<img class=\"wx-image\" src=\"" + this.dataModel.options.srcJson.url + "\"\n          style=\"width: " + this.dataModel.imageWidth + "px;height: " + this.dataModel.imageHeight + "px;\">";
        } else if (type == 'url') {
          html += "<img class=\"wx-image\" src=\"" + this._tfp.getUrlRealPath(this.dataModel.options.srcJson.url) + "\"\n          style=\"width: " + this.dataModel.imageWidth + "px;height: " + this.dataModel.imageHeight + "px;\">";
        }

        if (this.dataModel.options.appname) {
          html += " <lable class=\"wx-label OneAppModuleName\" style=\"line-height: 30px;height: 30px;\">\n        " + this.dataModel.options.appname + "\n        </lable>";
        }

        html += "</div>";
      } else {
        this.dataModel.options = {
          "srcJson": {
            "type": "httpurl",
            "url": "http://www.taskbuilder.org/app/bbs/img/headimg.png"
          },
          "appname": "应用名称",
          "appsrc": "http://www.taskbuilder.org/app/bbs/img/headimg.png"
        };
        this.dataModel.imageWidth = 48;
        this.dataModel.imageHeight = 48;
        html += "<img class=\"wx-image\" src=\"" + this.dataModel.options.srcJson.url + "\"\n      style=\"width: " + this.dataModel.imageWidth + "px;height: " + this.dataModel.imageHeight + "px;\">";
        html += " <lable class=\"wx-label OneAppModuleName\" style=\"line-height: 30px;height: 30px;\">\n      " + this.dataModel.options.appname + "\n      </lable></div>";
      }

      return html + indent;
    }
  }, {
    key: "getBodyWX",
    value: function getBodyWX(getComponentsHtml, retainStyleAttr, otherOptions) {
      var cpt_wx = {
        "wxjson": "",
        "wxjs": "",
        "wxml": "",
        "wxss": ""
      };
      var bodyHtml = "\r\n";
      var indent = this.getHtmlIndent();
      bodyHtml += indent + "";
      bodyHtml += "\t<view class=\"wx-oneappmodule-outbox\" bindtap=\"bindclick_toNewPage\" data-url=\"" + this.dataModel.options.appjumpUrl + "\" data-type=\"navigateTo\">\n";
      var type = this.dataModel.options.srcJson.type;

      if (type == 'iconfont') {
        bodyHtml += "<view class=\"" + this.dataModel.options.srcJson["class"] + "\" style=\"font-size: " + this.dataModel.imageWidth * 2 + "rpx;";

        if (this.dataModel.options.srcJson.color) {
          bodyHtml += "color:" + this.dataModel.options.srcJson.color + ';';
        }

        if (this.dataModel.options.srcJson.bgColor) {
          bodyHtml += "background-color:" + this.dataModel.options.srcJson.bgColor + ';';
        }

        bodyHtml += "\"></view>";
      } else if (type == 'httpurl') {
        bodyHtml += "<image class=\"wx-image\" src=\"" + this.dataModel.options.srcJson.url + "\"\n        style=\"width: " + this.dataModel.imageWidth * 2 + "rpx;height: " + this.dataModel.imageHeight * 2 + "rpx;\"/>";
      } else if (type == 'url') {
        bodyHtml += "<image class=\"wx-image\" wx-if=\"{{apiUrl}}\" src=\"{{apiUrl}}" + this._tfp.getUrlRealPath(this.dataModel.options.srcJson.url) + "\"\n        style=\"width: " + this.dataModel.imageWidth * 2 + "rpx;height: " + this.dataModel.imageHeight * 2 + "rpx;\"/>";
      }

      if (this.dataModel.options.appname) {
        bodyHtml += "\t\t\t<text class=\"wx-label\" style=\"line-height: 60rpx;height: 60rpx;\">" + this.dataModel.options.appname + "</text>\n";
      }

      bodyHtml += "\t\t</view>\n";
      cpt_wx.wxml = bodyHtml + indent;
      return cpt_wx;
    }
  }, {
    key: "getHtml",
    value: function getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
      return (0, _get2["default"])((0, _getPrototypeOf2["default"])(OneAppModule.prototype), "getHtml", this).call(this, "div", false, parentIndent, retainStyleAttr);
    }
  }, {
    key: "getWX",
    value: function getWX(getComponentsHtml, parentIndent, retainStyleAttr, otherOptions) {
      return (0, _get2["default"])((0, _getPrototypeOf2["default"])(OneAppModule.prototype), "getWX", this).call(this, "view", false, parentIndent, retainStyleAttr, otherOptions);
    }
  }]);
  return OneAppModule;
}(_render["default"]);

exports["default"] = OneAppModule;