"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

var _tfp = _interopRequireDefault(require("../../tfp.js"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 单应用模块
 * @param {[type]} dataModel [description]
 */
var OneAppModule = /*#__PURE__*/function (_VisibleComponent) {
  (0, _inherits2["default"])(OneAppModule, _VisibleComponent);

  var _super = _createSuper(OneAppModule);

  function OneAppModule(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, OneAppModule);
    return _super.call(this, __tfp, "OneAppModule", dataModel, parent);
  } // 图片宽度


  (0, _createClass2["default"])(OneAppModule, [{
    key: "imageWidth",
    get: function get() {
      return this.dataModel.imageWidth;
    },
    set: function set(value) {
      this.dataModel.imageWidth = value;

      if (this._jqObj) {
        this._jqObj.find("img").css("width", value + 'px');
      }
    } // 图片高度

  }, {
    key: "imageHeight",
    get: function get() {
      return this.dataModel.imageHeight;
    },
    set: function set(value) {
      this.dataModel.imageHeight = value;

      if (this._jqObj) {
        this._jqObj.find("img").css("height", value + 'px');
      }
    } // 选项

  }, {
    key: "options",
    get: function get() {
      return this.dataModel.options;
    },
    set: function set(value) {
      if (!value) return;
      this.dataModel.options = value;
      var options = [];

      if (typeof value == "string") {
        var arr = value.split(",");

        for (var i = 0; i < arr.length; i++) {
          var str = arr[i];

          if (str.trim() != "") {
            options.push({
              value: str,
              text: str
            });
          }
        }
      } else if (Array.isArray(value)) {
        for (var i = 0; i < value.length; i++) {
          var val = value[i];

          if (Object.prototype.toString.call(val) === '[object Object]') {
            options.push(val);
          } else {
            options.push({
              value: val,
              text: val
            });
          }
        }
      }

      this.dataModel.options = options[0];

      if (this._jqObj) {
        this._jqObj.empty();

        if (value.length > 0) {
          this.addOption(value[0]);
        }
      }
    }
  }, {
    key: "addOption",
    value: function addOption(option) {
      var indent = this.getHtmlIndent();
      var str = "";
      str += this.getOptionHtml(indent, option);

      if (str != "") {
        this._jqObj.append(str);
      }
    }
  }, {
    key: "getOptionHtml",
    value: function getOptionHtml(indent, option) {
      var optionHtml = "";
      optionHtml += indent;
      optionHtml += "<div style=\"display:flex;align-items:center;width:100%;justify-content:space-evenly;flex-direction:column;height:100%;\">";
      var type = option.srcJson.type;

      if (type == 'iconfont') {
        optionHtml += "<div class=\"" + option.srcJson["class"] + "\" style=\"font-size: " + this.dataModel.imageWidth + "px;";

        if (option.srcJson.color) {
          optionHtml += "color:" + option.srcJson.color + ';';
        }

        if (option.srcJson.bgColor) {
          optionHtml += "background-color:" + option.srcJson.bgColor + ';';
        }

        optionHtml += "\"></div>";
      } else if (type == 'httpurl') {
        optionHtml += "<img class=\"wx-image\" src=\"" + option.srcJson.url + "\"\n        style=\"width: " + this.dataModel.imageWidth + "px;height: " + this.dataModel.imageHeight + "px;\">";
      } else if (type == 'url') {
        optionHtml += "<img class=\"wx-image\" src=\"" + this._tfp.getUrlRealPath(option.srcJson.url) + "\"\n        style=\"width: " + this.dataModel.imageWidth + "px;height: " + this.dataModel.imageHeight + "px;\">";
      }

      if (option.appname) {
        optionHtml += " <lable class=\"wx-label OneAppModuleName\" style=\"line-height: 30px;height: 30px;\">\n      " + option.appname + "\n      </lable>";
      }

      optionHtml += "</div>";
      return optionHtml;
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;
    }
  }]);
  return OneAppModule;
}(_controller.VisibleComponent);

exports["default"] = OneAppModule;