"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "Marquee",
  "comment": "跑马灯",
  "cssFiles": "style.{bgColorMode}.css",
  "attrs": [{
    "name": "value",
    "comment": "组件文本",
    "type": "String",
    "notnull": true,
    "default": "{id}"
  }, {
    "name": "direction",
    "comment": "滚动方向",
    "type": "Select",
    "default": "left",
    "options": [{
      "value": "left",
      "text": "文字向左"
    }, {
      "value": "right",
      "text": "文字向右"
    }, {
      "value": "up",
      "text": "文字向上"
    }, {
      "value": "down",
      "text": "文字向下"
    }]
  }, {
    "name": "behavior",
    "comment": "滚动方式",
    "type": "Select",
    "default": "scroll",
    "options": [{
      "value": "scroll",
      "text": "循环滚动"
    }, {
      "value": "slide",
      "text": "单次滚动"
    }, {
      "value": "alternate",
      "text": "交替滚动"
    }]
  }, {
    "name": "scrollamount",
    "comment": "滚动速度",
    "type": "Int"
  }, {
    "name": "scrolldelay",
    "comment": "滚动延迟",
    "type": "Int"
  }, {
    "name": "loop",
    "comment": "循环次数",
    "type": "Int"
  }, {
    "name": "bgcolor",
    "comment": "滚动背景颜色",
    "type": "Color",
    "default": "#ffffff"
  }, {
    "name": "onMouse",
    "comment": "鼠标事件",
    "type": "Switch"
  }, {
    "name": "dataBindingFormat",
    "comment": "数据绑定格式",
    "type": "String"
  }],
  "styles": ["size", "position", "font", "background", "border", "margin", "other"],
  "defaultStyles": {
    "width": "100px",
    "height": "30px",
    "line-height": "30px"
  },
  "events": [{
    "name": "onAfterInitRuntime",
    "comment": "组件初始化后",
    "isNotHtmlEvent": true
  }, {
    "name": "onClick",
    "comment": "点击时"
  }, {
    "name": "onMouseOver",
    "comment": "鼠标经过时"
  }, {
    "name": "onMouseOut",
    "comment": "鼠标移出时"
  }]
};
exports["default"] = _default;