"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "List",
  "comment": "列表",
  "cssFiles": ["style.{bgColorMode}.css", {
    "src": "/node_modules/tfp/src/components/iconpicker/iconfont/iconfont.css",
    "onlyRuntime": true
  }, {
    "src": "/node_modules/tfp/src/components/button/iconfont/iconfont.css",
    "onlyRuntime": true
  }, {
    "src": "/node_modules/tfp/src/components/iconpicker/iconfont/iconfont_tb.css",
    "onlyDesigning": true
  }, {
    "src": "/node_modules/tfp/src/components/button/iconfont/iconfont_tb.css",
    "onlyDesigning": true
  }],
  "attrs": [{
    "name": "dataSourceSetting",
    "comment": "数据源设置",
    "type": "group",
    "items": [{
      "name": "dataQuerySetting",
      "comment": "数据查询设置",
      "type": "Dialog",
      "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
      "width": "800px",
      "height": "640px"
    }, {
      "name": "dataListValueFormat",
      "comment": "选项值数据格式",
      "type": "String",
      "showModelFieldList": true
    }, {
      "name": "dataListTextFormat",
      "comment": "选项文本数据格式",
      "type": "String",
      "showModelFieldList": true
    }]
  }, {
    "name": "inputSetting",
    "comment": "列表设置",
    "type": "group",
    "items": [{
      "name": "value",
      "comment": "当前选中选项值",
      "type": "String",
      "isHtmlAttr": true
    }, {
      "name": "options",
      "comment": "选项设置",
      "type": "Dataset",
      "isPro": true,
      "keyCol": "name",
      "width": "640px",
      "height": "600px",
      "columns": [{
        "id": "value",
        "name": "选项值",
        "type": "String",
        "required": true
      }, {
        "id": "text",
        "name": "选项文本",
        "type": "String",
        "required": true
      }, {
        "id": "target",
        "name": "目标页面",
        "type": "Select",
        "default": "self",
        "options": [{
          "value": "self",
          "text": "当前页面"
        }, {
          "value": "page",
          "text": "新页面"
        }, {
          "value": "dialog",
          "text": "对话框"
        }, {
          "value": "window",
          "text": "新窗口"
        }]
      }, {
        "id": "targetTitle",
        "name": "目标页面标题",
        "type": "String"
      }, {
        "id": "href",
        "name": "目标页面地址",
        "type": "String",
        "isHtmlAttr": true,
        "special": true
      }, {
        "id": "dialogWidth",
        "name": "对话框宽度",
        "type": "Int"
      }, {
        "id": "dialogHeight",
        "name": "对话框高度",
        "type": "Int"
      }, {
        "id": "icon",
        "name": "文本前面显示小图标",
        "type": "Icon"
      }, {
        "id": "iconSize",
        "name": "小图标大小",
        "type": "Size",
        "default": 20
      }, {
        "id": "iconRadius",
        "name": "小图标圆角",
        "type": "Size",
        "default": 4
      }, {
        "id": "onClick",
        "name": "点击后执行的脚本",
        "type": "Event",
        "width": "180px",
        "wrap": true
      }]
    }, {
      "name": "orderType",
      "comment": "列表类型",
      "type": "Select",
      "default": "none",
      "options": [{
        "value": "none",
        "text": "无序列表"
      }, {
        "value": "order",
        "text": "有序列表"
      }]
    }, {
      "name": "icon",
      "comment": "列表图标",
      "type": "String"
    }, {
      "name": "color",
      "comment": "选中字体颜色",
      "type": "String"
    }, {
      "name": "bgColor",
      "comment": "选中背景颜色",
      "type": "String",
      "bgColor": "#E6F2FE"
    }, {
      "name": "showVerticalBar",
      "comment": "选中显示竖条",
      "type": "Switch",
      "default": true
    }, {
      "name": "multiCheck",
      "comment": "多选",
      "type": "Switch"
    }]
  }],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
    "width": "100%",
    "height": "120px",
    "overflow": "auto",
    "border": "0"
  },
  "events": [{
    "name": "onAfterInitRuntime",
    "comment": "组件初始化后",
    "isNotHtmlEvent": true
  }, {
    "name": "onClickOption",
    "comment": "点击列表项时",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "index",
      "comment": "选项索引",
      "type": "Int",
      "required": true
    }, {
      "name": "value",
      "comment": "选项值",
      "type": "String",
      "required": true
    }]
  }, {
    "name": "onDblClickOption",
    "comment": "双击列表项时",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "index",
      "comment": "选项索引",
      "type": "Int",
      "required": true
    }, {
      "name": "value",
      "comment": "选项值",
      "type": "String",
      "required": true
    }]
  }, {
    "name": "onChange",
    "comment": "值发生变化时",
    "isNotHtmlEvent": true
  }],
  "methods": [{
    "name": "bindData",
    "comment": "绑定数据",
    "args": [{
      "name": "data",
      "comment": "数据",
      "type": "Array"
    }]
  }, {
    "name": "getOption",
    "comment": "获得指定索引的选项",
    "args": [{
      "name": "index",
      "comment": "选项索引",
      "type": "Int"
    }]
  }, {
    "name": "getOptionByValue",
    "comment": "获得指定值的选项",
    "args": [{
      "name": "val",
      "comment": "选项值",
      "type": "String"
    }]
  }, {
    "name": "loadData",
    "comment": "加载数据",
    "args": []
  }, {
    "name": "setOptions",
    "comment": "设置可选项",
    "args": [{
      "name": "options",
      "comment": "可选项",
      "type": "String"
    }]
  }]
};
exports["default"] = _default;