"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 弹出列表组件
 * @param {[type]} dataModel [description]
 */
var List = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(List, _FormInput);

  var _super = _createSuper(List);

  function List(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, List);
    return _super.call(this, __tfp, "List", dataModel, parent);
  }

  (0, _createClass2["default"])(List, [{
    key: "value",
    get: function get() {
      if (!this.dataModel.value) return "";
      return this.dataModel.value;
    },
    set: function set(value) {
      var val = value;

      if (isNull(value)) {
        val = "";
        this.dataModel.value = null;
      } else {
        this.dataModel.value = val;
      }

      if (this._jqObj) {
        this.reRender();
      }

      if (!this._tfp.isDesigning) {
        this.valueOnChange();
        this.exeEventHandler("onChange", val);
      }
    }
  }, {
    key: "text",
    get: function get() {
      var _this = this;

      if (!this.dataModel.value) return "";
      var item = this.dataModel.options.find(function (v) {
        return v.value == _this.dataModel.value;
      });
      if (!item) return "";
      return item.text;
    },
    set: function set(txt) {}
  }, {
    key: "options",
    get: function get() {
      return this.dataModel.options;
    },
    set: function set(options) {
      if (this._jqObj && options && Array.isArray(options)) {
        this.dataModel.options = options;

        if (this._jqObj) {
          this.reRender();
        }
      }
    }
  }, {
    key: "orderType",
    get: function get() {
      return this.dataModel.orderType;
    },
    set: function set(value) {
      this.dataModel.orderType = value;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "icon",
    get: function get() {
      return this.dataModel.icon;
    },
    set: function set(value) {
      this.dataModel.icon = value;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "color",
    get: function get() {
      return this.dataModel.color;
    },
    set: function set(value) {
      this.dataModel.color = value;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "bgColor",
    get: function get() {
      return this.dataModel.bgColor;
    },
    set: function set(value) {
      this.dataModel.bgColor = value;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "loadDataListService",
    get: function get() {
      return this.dataModel.loadDataListService;
    },
    set: function set(value) {
      this.dataModel.loadDataListService = value;
    }
  }, {
    key: "dataListBindingMember",
    get: function get() {
      return this.dataModel.dataListBindingMember;
    },
    set: function set(value) {
      this.dataModel.dataListBindingMember = value;
    }
  }, {
    key: "dataListValueFormat",
    get: function get() {
      return this.dataModel.dataListValueFormat;
    },
    set: function set(value) {
      this.dataModel.dataListValueFormat = value;
    }
  }, {
    key: "dataListTextFormat",
    get: function get() {
      return this.dataModel.dataListTextFormat;
    },
    set: function set(value) {
      this.dataModel.dataListTextFormat = value;
    }
  }, {
    key: "showVerticalBar",
    get: function get() {
      return this.dataModel.showVerticalBar;
    },
    set: function set(value) {
      this.dataModel.showVerticalBar = value ? true : false;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "multiCheck",
    get: function get() {
      return this.dataModel.multiCheck;
    },
    set: function set(value) {
      this.dataModel.multiCheck = value ? true : false;

      if (this._jqObj) {
        this.reRender();
      }
    }
  }, {
    key: "getOption",
    value: function getOption(index) {
      return this.dataModel.options[index];
    }
  }, {
    key: "getOptionByValue",
    value: function getOptionByValue(val) {
      return this.dataModel.options.find(function (v) {
        return v.value == val;
      });
    }
  }, {
    key: "reRender",
    value: function reRender() {
      this._jqObj.empty();

      this._jqObj.append(this.getBodyHtml());

      if (!this._tfp.isDesigning) this.bindItemEvent();
    }
  }, {
    key: "getBodyHtml",
    value: function getBodyHtml(getComponentsHtml) {
      var indent = this.getHtmlIndent();
      var html = "\r\n";
      var bgColor = '';
      var color = '#666';
      if (this.dataModel.bgColor) bgColor = "background-color:" + this.dataModel.bgColor + ";";
      if (this.dataModel.color) color = this.dataModel.color;

      if (this.dataModel.options) {
        for (var i = 0; i < this.dataModel.options.length; i++) {
          var option = this.dataModel.options[i];
          html += indent + "\t<div data-value=\"" + option.value + "\"";

          if (option.value + "" == this.dataModel.value + "") {
            if (this.dataModel.showVerticalBar && !this.dataModel.color) html += " class=\"tfp-list-border\"";
            html += " style=\"" + bgColor + "";
            if (this.dataModel.showVerticalBar && this.dataModel.color) html += " border-left: 3.5px solid " + color + ";";
            html += "\"";
          } // if (!this._tfp.isDesigning && option.onClick) html += " onclick=\"" + option.onClick + "\"";


          var dot = "";

          if (this.dataModel.orderType == "order") {
            dot = "<label";
            if (this.dataModel.color) dot += " style=\"color:" + color + ";\"";
            dot += " class=\"tfp-list-color\"";
            dot += "> " + (i + 1) + ".</label> ";
          }

          if (this.dataModel.icon) {
            var imgUrl = '';

            if (this.dataModel.icon[0] == '/') {
              imgUrl = this._tfp.rootPath + "" + this.dataModel.icon + "";
            } else {
              imgUrl = this.dataModel.icon;
            }

            dot = "<img width=\"16\" height=\"16\" align=\"absmiddle\" src=\"" + imgUrl + "\" />";
          }

          if (option.icon) {
            var iconSize = 20;
            if (option.iconSize) iconSize = option.iconSize;
            iconSize = this._tfp.getPx(iconSize);
            var iconRadius = 4;
            if (option.iconRadius || option.iconRadius + "" == "0") iconRadius = option.iconRadius;
            iconRadius = this._tfp.getPx(iconRadius);

            if (option.icon.type == "url") {
              dot = "<img src=\"" + option.icon.url + "\" style=\"width:" + iconSize + "px; height:" + iconSize + "px; border-radius: " + iconRadius + "px;\">";
            } else {
              dot = "<span class=\"" + option.icon["class"] + "\" style=\"margin-right:3px;border-radius: " + iconRadius + "px; " + "font-size:" + iconSize + "px;height:" + iconSize + "px;line-height:" + iconSize + "px;" + "background-color:" + option.icon.bgColor + ";color:" + option.icon.color + ";\"></span>";
            }
          }

          html += ">";

          if (option.href) {
            html += "<a ";

            if (!this._tfp.isDesigning) {
              if (option.target == "self") {
                html += " href=\"" + option.href + "\"";
              } else {
                html += " href=\"javascript:void(0)\" onclick=\"";
                var title = "Tasgine - 任擎";
                if (option.targetTitle) title = option.targetTitle;

                if (option.target == "page") {
                  html += "tfp.openPage('" + title + "', '" + option.href + "')";
                } else if (option.target == "dialog") {
                  var width = option.dialogWidth;
                  if (!width) width = "480px";
                  if ((width + "").indexOf("px") < 0) width += "px";
                  var height = option.dialogHeight;
                  if (!height) height = "480px";
                  if ((height + "").indexOf("px") < 0) height += "px";
                  html += "tfp.openDialog('" + title + "', '" + option.href + "'" + ", '" + width + "', '" + height + "')";
                } else if (option.target == "window") {
                  html += "window.open('" + option.href + "', '" + title + "')";
                }

                html += "\"";
              }
            }

            html += ">";
          }

          if (this.dataModel.multiCheck) {
            html += "" + dot + "<input type=\"checkbox\"><label";
            if (option.value + "" == this.dataModel.value + "") if (this.dataModel.color) html += " style=\"color:" + color + ";\"";else html += " class=\"tfp-list-color\"";
            html += ">" + (option.text ? option.text : option.value) + "</label > ";
          } else {
            html += "" + dot + " <label ";
            if (option.value + "" == this.dataModel.value + "") if (this.dataModel.color) html += " style=\"color:" + color + ";\"";else html += " class=\"tfp-list-color\"";
            html += ">" + (option.text ? option.text : option.value) + "</label>";
          }

          if (option.href) {
            html += "</a>";
          }

          html += "</div>\r\n";
        }
      }

      return html + "\t";
    }
  }, {
    key: "setSelectOptionColor",
    value: function setSelectOptionColor(el) {
      if (!this.dataModel.multiCheck) {
        var color = "#666";
        if (this.dataModel.color) color = this.dataModel.color;

        if (this._tfp.curPage.bgColorMode == "dark") {
          this._jqObj.find("label").css("color", "#FFFFFF");

          this._jqObj.find("label").attr("class", "");
        } else {
          this._jqObj.find("label").css("color", "#333333");

          this._jqObj.find("label").attr("class", "");
        }

        if (this.dataModel.bgColor) $(el).css("background-color", this.dataModel.bgColor).siblings("div").css("background-color", "");

        if (this.dataModel.showVerticalBar) {
          if (this.dataModel.color) {
            $(el).css({
              "border-left": "3.5px solid " + color + ""
            }).siblings("div").css({
              "border-left": "none"
            });
          } else {
            $(el).attr({
              "class": "tfp-list-border"
            }).siblings("div").attr({
              "class": ""
            });
          }
        } else {
          $(el).css({
            "border-left": "none"
          }).siblings("div").css({
            "border-left": "none"
          });
        }

        if (this.dataModel.color) $(el).find("label").css("color", color);else $(el).find("label").attr("class", "tfp-list-color");
      }
    }
  }, {
    key: "bindItemEvent",
    value: function bindItemEvent() {
      var that = this;

      this._jqObj.children("div").click(function () {
        that.setSelectOptionColor(this);
        var index = $(this).index();
        var option = that.dataModel.options[index];
        var value = "";

        if (that.dataModel.multiCheck) {
          var listItems = that._jqObj.find('div');

          for (var i = 0; i < listItems.length; i++) {
            if (listItems.eq(i).children("input").prop("checked")) {
              if (value == '') {
                value += listItems.eq(i).attr("data-value");
              } else {
                value += ',';
                value += listItems.eq(i).attr("data-value");
              }
            }
          }
        } else {
          if (option) value = option.value;
        }

        that.dataModel.value = value;
        that.valueOnChange();
        that.exeEventHandler("onChange", value);

        try {
          if (option.onClick) eval(option.onClick);
          if (that.dataModel.onClickOption) eval(that.dataModel.onClickOption);
        } catch (err) {
          console.log(err.message);
        }
      });

      this._jqObj.children("div").dblclick(function () {
        that.setSelectOptionColor(this);
        var index = $(this).index();
        var option = that.dataModel.options[index];
        var value = "";

        if (that.dataModel.multiCheck) {
          var listItems = that._jqObj.find('div');

          for (var i = 0; i < listItems.length; i++) {
            if (listItems.eq(i).children("input").prop("checked")) {
              if (value == '') {
                value += listItems.eq(i).attr("data-value");
              } else {
                value += ',';
                value += listItems.eq(i).attr("data-value");
              }
            }
          }
        } else if (option) {
          value = option.value;
        }

        that.dataModel.value = value;
        that.valueOnChange();
        that.exeEventHandler("onChange", value);

        if (that.dataModel.onDblClickOption) {
          try {
            eval(that.dataModel.onDblClickOption);
          } catch (err) {
            console.log(err.message);
          }
        }
      });
    }
  }, {
    key: "bindData",
    value: function bindData(data) {
      if (isNull(data) || !Array.isArray(data)) return;
      var options = [];

      for (var i = 0; i < data.length; i++) {
        var row = data[i];
        var option = {};

        try {
          var valueFormat = this.dataModel.dataListValueFormat;
          if (valueFormat.indexOf("{") < 0 && valueFormat.indexOf("#[") < 0) valueFormat = "{" + valueFormat + "}";
          option.value = this._tfp.replaceDataField(row, valueFormat);
          if (option.value) option.value = this._tfp.exeExpress(option.value);
        } catch (e) {
          console.log(e);
          return;
        }

        if (isNull(option.value)) continue;
        option.text = option.value;

        if (this.dataModel.dataListTextFormat) {
          try {
            var textFormat = this.dataModel.dataListTextFormat;
            if (textFormat.indexOf("{") < 0 && textFormat.indexOf("#[") < 0) textFormat = "{" + textFormat + "}";
            option.text = this._tfp.replaceDataField(row, textFormat);
            if (option.text) option.text = this._tfp.exeExpress(option.text);
          } catch (e) {
            console.log(e);
            return;
          }
        }

        if (isNull(option.text)) continue;
        options.push(option);
      }

      this.options = options;
    }
    /**
     * 检查数据加载参数是否设置正确
     * @returns 
     */

  }, {
    key: "checkLoadDataArg",
    value: function checkLoadDataArg() {
      if (!this.dataModel.dataListValueFormat) {
        alert("请为[" + this.id + "]设置选项值数据格式！");
        return false;
      }

      return true;
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载
      if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService || this.dataModel.dataQuerySetting && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)) {
        this.loadData();
      }

      this.bindItemEvent();
    }
  }]);
  return List;
}(_controller.FormInput);

exports["default"] = List;