"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "Layout",
  "comment": "布局",
  "cssFiles": ["style.css"],
  "attrs": [{
    "name": "topPanelSetting",
    "comment": "顶部面板设置",
    "type": "group",
    "items": [{
      "name": "topPanelHeight",
      "comment": "高度",
      "type": "Int",
      "default": 120
    }, {
      "name": "topPanelShow",
      "comment": "默认显示",
      "type": "Switch",
      "default": true
    }, {
      "name": "topPanelToggle",
      "comment": "允许显示或隐藏",
      "type": "Switch",
      "default": true
    }]
  }, {
    "name": "leftPanelSetting",
    "comment": "左侧面板设置",
    "type": "group",
    "items": [{
      "name": "leftPanelWidth",
      "comment": "宽度",
      "type": "Int",
      "default": 200
    }, {
      "name": "leftPanelShow",
      "comment": "默认显示",
      "type": "Switch",
      "default": true
    }, {
      "name": "leftPanelToggle",
      "comment": "允许显示或隐藏",
      "type": "Switch",
      "default": true
    }]
  }, {
    "name": "rightPanelSetting",
    "comment": "右侧面板设置",
    "type": "group",
    "items": [{
      "name": "rightPanelWidth",
      "comment": "宽度",
      "type": "Int",
      "default": 200
    }, {
      "name": "rightPanelShow",
      "comment": "默认显示",
      "type": "Switch",
      "default": true
    }, {
      "name": "rightPanelToggle",
      "comment": "允许显示或隐藏",
      "type": "Switch",
      "default": true
    }]
  }, {
    "name": "bottomPanelSetting",
    "comment": "底部面板设置",
    "type": "group",
    "items": [{
      "name": "bottomPanelHeight",
      "comment": "高度",
      "type": "Int",
      "default": 120
    }, {
      "name": "bottomPanelShow",
      "comment": "默认显示",
      "type": "Switch",
      "default": true
    }, {
      "name": "bottomPanelToggle",
      "comment": "允许显示或隐藏",
      "type": "Switch",
      "default": true
    }]
  }],
  "styles": ["size", "position", "background", "border", "margin", "other"],
  "defaultStyles": {
    "position": "absolue",
    "z-index": 1,
    "left": "10px",
    "top": "10px",
    "right": "10px",
    "bottom": "10px"
  },
  "events": [{
    "name": "onAfterInitRuntime",
    "comment": "组件初始化后",
    "isNotHtmlEvent": true
  }]
};
exports["default"] = _default;