"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 布局组件
 * @param {[type]} dataModel [description]
 */
var Layout = /*#__PURE__*/function (_ContainerComponent) {
  (0, _inherits2["default"])(Layout, _ContainerComponent);

  var _super = _createSuper(Layout);

  function Layout(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, Layout);
    return _super.call(this, __tfp, "Layout", dataModel, parent);
  }

  (0, _createClass2["default"])(Layout, [{
    key: "mainPanel",
    get: function get() {
      return this._tfp.components[this.id + "_main_panel"];
    },
    set: function set(value) {}
  }, {
    key: "topPanel",
    get: function get() {
      return this._tfp.components[this.id + "_top_panel"];
    },
    set: function set(value) {}
  }, {
    key: "topPanelHeight",
    get: function get() {
      return this.dataModel.topPanelHeight;
    },
    set: function set(value) {
      this.dataModel.topPanelHeight = this._tfp.getPx(value);

      if (this._jqObj) {
        this._jqObj.find(".tfp-layout-top").css("flex-basis", value + "px");
      }
    }
  }, {
    key: "topPanelShow",
    get: function get() {
      return this.dataModel.topPanelShow ? true : false;
    },
    set: function set(value) {
      this.dataModel.topPanelShow = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.topPanelShow) {
          this._jqObj.find(".tfp-layout-top").show(); //if(this.dataModel.topPanelToggle) this._jqObj.find(".tfp-layout-top-toggle").show();

        } else {
          this._jqObj.find(".tfp-layout-top").hide(); //this._jqObj.find(".tfp-layout-top-toggle").hide();

        }
      }
    }
  }, {
    key: "topPanelToggle",
    get: function get() {
      return this.dataModel.topPanelToggle ? true : false;
    },
    set: function set(value) {
      this.dataModel.topPanelToggle = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.topPanelToggle) {
          this._jqObj.find(".tfp-layout-top-toggle").show();
        } else {
          this._jqObj.find(".tfp-layout-top-toggle").hide();
        }
      }
    }
  }, {
    key: "leftPanel",
    get: function get() {
      return this._tfp.components[this.id + "_left_panel"];
    },
    set: function set(value) {}
  }, {
    key: "leftPanelWidth",
    get: function get() {
      return this.dataModel.leftPanelWidth;
    },
    set: function set(value) {
      this.dataModel.leftPanelWidth = this._tfp.getPx(value);
      if (this._jqObj) this._jqObj.find(".tfp-layout-left").css("flex-basis", value + "px");
    }
  }, {
    key: "leftPanelShow",
    get: function get() {
      return this.dataModel.leftPanelShow ? true : false;
    },
    set: function set(value) {
      this.dataModel.leftPanelShow = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.leftPanelShow) {
          this._jqObj.find(".tfp-layout-left").show(); //if(this.dataModel.leftPanelToggle) this._jqObj.find(".tfp-layout-left-toggle").show();

        } else {
          this._jqObj.find(".tfp-layout-left").hide(); //this._jqObj.find(".tfp-layout-left-toggle").hide();

        }
      }
    }
  }, {
    key: "leftPanelToggle",
    get: function get() {
      return this.dataModel.leftPanelToggle ? true : false;
    },
    set: function set(value) {
      this.dataModel.leftPanelToggle = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.leftPanelToggle) {
          this._jqObj.find(".tfp-layout-left-toggle").show();
        } else {
          this._jqObj.find(".tfp-layout-left-toggle").hide();
        }
      }
    }
  }, {
    key: "rightPanel",
    get: function get() {
      return this._tfp.components[this.id + "_right_panel"];
    },
    set: function set(value) {}
  }, {
    key: "rightPanelWidth",
    get: function get() {
      return this.dataModel.rightPanelWidth;
    },
    set: function set(value) {
      this.dataModel.rightPanelWidth = this._tfp.getPx(value);
      if (this._jqObj) this._jqObj.find(".tfp-layout-right").css("flex-basis", value + "px");
    }
  }, {
    key: "rightPanelShow",
    get: function get() {
      return this.dataModel.rightPanelShow ? true : false;
    },
    set: function set(value) {
      this.dataModel.rightPanelShow = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.rightPanelShow) {
          this._jqObj.find(".tfp-layout-right").show(); //if(this.dataModel.rightPanelToggle) this._jqObj.find(".tfp-layout-right-toggle").show();

        } else {
          this._jqObj.find(".tfp-layout-right").hide(); //this._jqObj.find(".tfp-layout-right-toggle").hide();

        }
      }
    }
  }, {
    key: "rightPanelToggle",
    get: function get() {
      return this.dataModel.rightPanelToggle ? true : false;
    },
    set: function set(value) {
      this.dataModel.rightPanelToggle = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.rightPanelToggle) {
          this._jqObj.find(".tfp-layout-right-toggle").show();
        } else {
          this._jqObj.find(".tfp-layout-right-toggle").hide();
        }
      }
    }
  }, {
    key: "bottomPanel",
    get: function get() {
      return this._tfp.components[this.id + "_bottom_panel"];
    },
    set: function set(value) {}
  }, {
    key: "bottomPanelHeight",
    get: function get() {
      return this.dataModel.bottomPanelHeight;
    },
    set: function set(value) {
      this.dataModel.bottomPanelHeight = this._tfp.getPx(value);
      if (this._jqObj) this._jqObj.find(".tfp-layout-bottom").css("flex-basis", value + "px");
    }
  }, {
    key: "bottomPanelShow",
    get: function get() {
      return this.dataModel.bottomPanelShow ? true : false;
    },
    set: function set(value) {
      this.dataModel.bottomPanelShow = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.bottomPanelShow) {
          this._jqObj.find(".tfp-layout-bottom").show(); //if(this.dataModel.bottomPanelToggle) this._jqObj.find(".tfp-layout-bottom-toggle").show();

        } else {
          this._jqObj.find(".tfp-layout-bottom").hide(); //this._jqObj.find(".tfp-layout-bottom-toggle").hide();

        }
      }
    }
  }, {
    key: "bottomPanelToggle",
    get: function get() {
      return this.dataModel.bottomPanelToggle ? true : false;
    },
    set: function set(value) {
      this.dataModel.bottomPanelToggle = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.bottomPanelToggle) {
          this._jqObj.find(".tfp-layout-bottom-toggle").show();
        } else {
          this._jqObj.find(".tfp-layout-bottom-toggle").hide();
        }
      }
    }
  }, {
    key: "hasAttachedChilds",
    get: function get() {
      return true;
    }
  }, {
    key: "getContainerEl",
    value: function getContainerEl(cptId) {
      var panelType = cptId.substring(cptId.indexOf("_") + 1, cptId.lastIndexOf("_"));
      if (panelType == "top") return this._jqObj.find(".tfp-layout-top").get(0);
      if (panelType == "left") return this._jqObj.find(".tfp-layout-left").get(0);
      if (panelType == "main") return this._jqObj.find(".tfp-layout-main").get(0);
      if (panelType == "right") return this._jqObj.find(".tfp-layout-right").get(0);
      if (panelType == "bottom") return this._jqObj.find(".tfp-layout-bottom").get(0);
      return null;
    }
  }, {
    key: "toggleTopPanel",
    value: function toggleTopPanel() {
      this.topPanelShow = !this.topPanelShow;

      var toggleEl = this._jqObj.find(".tfp-layout-top-toggle");

      var toggleImg = toggleEl.find("img");

      if (!this.topPanelShow) {
        toggleEl.attr("title", "显示");
        toggleImg.attr("src", toggleImg.attr("src").replace("arrow-up.png", "arrow-down.png"));
      } else {
        toggleEl.attr("title", "隐藏");
        toggleImg.attr("src", toggleImg.attr("src").replace("arrow-down.png", "arrow-up.png"));
      }

      toggleEl.show();
    }
  }, {
    key: "toggleLeftPanel",
    value: function toggleLeftPanel() {
      this.leftPanelShow = !this.leftPanelShow;

      var toggleEl = this._jqObj.find(".tfp-layout-left-toggle");

      var toggleImg = toggleEl.find("img");

      if (!this.leftPanelShow) {
        toggleEl.attr("title", "显示");
        toggleImg.attr("src", toggleImg.attr("src").replace("arrow-left.png", "arrow-right.png"));
      } else {
        toggleEl.attr("title", "隐藏");
        toggleImg.attr("src", toggleImg.attr("src").replace("arrow-right.png", "arrow-left.png"));
      }

      toggleEl.show();
    }
  }, {
    key: "toggleRightPanel",
    value: function toggleRightPanel() {
      this.rightPanelShow = !this.rightPanelShow;

      var toggleEl = this._jqObj.find(".tfp-layout-right-toggle");

      var toggleImg = toggleEl.find("img");

      if (!this.rightPanelShow) {
        toggleEl.attr("title", "显示");
        toggleImg.attr("src", toggleImg.attr("src").replace("arrow-right.png", "arrow-left.png"));
      } else {
        toggleEl.attr("title", "隐藏");
        toggleImg.attr("src", toggleImg.attr("src").replace("arrow-left.png", "arrow-right.png"));
      }

      toggleEl.show();
    }
  }, {
    key: "toggleBottomPanel",
    value: function toggleBottomPanel() {
      this.bottomPanelShow = !this.bottomPanelShow;

      var toggleEl = this._jqObj.find(".tfp-layout-bottom-toggle");

      var toggleImg = toggleEl.find("img");

      if (!this.bottomPanelShow) {
        toggleEl.attr("title", "显示");
        toggleImg.attr("src", toggleImg.attr("src").replace("arrow-down.png", "arrow-up.png"));
      } else {
        toggleEl.attr("title", "隐藏");
        toggleImg.attr("src", toggleImg.attr("src").replace("arrow-up.png", "arrow-down.png"));
      }

      toggleEl.show();
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      this._jqObj.find(".tfp-layout-top-toggle").click(function () {
        that.toggleTopPanel();
      });

      this._jqObj.find(".tfp-layout-left-toggle").click(function () {
        that.toggleLeftPanel();
      });

      this._jqObj.find(".tfp-layout-right-toggle").click(function () {
        that.toggleRightPanel();
      });

      this._jqObj.find(".tfp-layout-bottom-toggle").click(function () {
        that.toggleBottomPanel();
      });
    }
  }]);
  return Layout;
}(_controller.ContainerComponent);

exports["default"] = Layout;