"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 标签组件
 * @param {[type]} dataModel [description]
 */
var Label = /*#__PURE__*/function (_VisibleComponent) {
  (0, _inherits2["default"])(Label, _VisibleComponent);

  var _super = _createSuper(Label);

  function Label(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, Label);
    return _super.call(this, __tfp, "Label", dataModel, parent);
  } //标签值


  (0, _createClass2["default"])(Label, [{
    key: "value",
    get: function get() {
      if (!this.dataModel.value) return "";
      return this.dataModel.value;
    },
    set: function set(value) {
      this.dataModel.value = value;

      if (this._jqObj) {
        this._jqObj.html(this.getBodyHtml());

        this.exeEventHandler("onChange");
      }
    }
  }, {
    key: "size",
    get: function get() {
      return this.dataModel.size;
    },
    set: function set(value) {
      this.dataModel.size = value;

      if (this._jqObj) {
        var labelEl = this._jqObj; //this.dataModel.attach ? this._jqObj.find("label") : this._jqObj;

        labelEl.removeClass(function (index, className) {
          var ss = className.split(' ');

          for (var s = 0; s < ss.length; s++) {
            if (ss[s].indexOf('tfp-label-') >= 0) return ss[s];
          }

          return "";
        });
        if (value) labelEl.addClass("tfp-label-" + value);
      }
    }
  }, {
    key: "attach",
    get: function get() {
      return this.dataModel.attach;
    },
    set: function set(value) {
      this.dataModel.attach = value;

      if (this._jqObj) {
        var color = '#f56c6c';
        if (this.dataModel.attachColor) color = this.dataModel.attachColor;
        var colorClass = '';

        if (this.dataModel.attach == 'vertical-bar-prefix' && !this.dataModel.attachColor) {
          colorClass = 'vertical-bar-prefix-color';
          color = '';
        }

        this._jqObj.find(".tfp-label-attach").remove();

        if (this.dataModel.attach == 'asterisk-prefix') {
          this._jqObj.prepend('<span class="tfp-label-attach" style=\"float:left;margin-right:5px;color:' + color + ';\">*</span>');
        } else if (this.dataModel.attach == 'asterisk-suffix') {
          this._jqObj.append('<span class="tfp-label-attach" style=\"float:right;margin-left:5px;color:' + color + ';\">*</span>');
        } else if (this.dataModel.attach == 'vertical-bar-prefix') {
          this._jqObj.prepend('<span class="tfp-label-attach  ' + colorClass + '" style=\"float:left;width:4px;height:24px;margin-right:10px;background-color:' + color + ';\"></span>');
        }
      }
    }
  }, {
    key: "attachColor",
    get: function get() {
      return this.dataModel.attachColor;
    },
    set: function set(value) {
      this.dataModel.attachColor = value;

      if (this.dataModel.attach) {
        if (this.dataModel.attach == 'vertical-bar-prefix') {
          this._jqObj.find(".tfp-label-attach").css("background-color", value);
        } else {
          this._jqObj.find(".tfp-label-attach").css("color", value);
        }
      }
    }
  }, {
    key: "showImage",
    get: function get() {
      return this.dataModel.showImage;
    },
    set: function set(value) {
      this.dataModel.showImage = value ? true : false;

      if (this._jqObj) {
        if (value) {
          var iconClass = 'iconfont icon-album';
          var iconColor = '#000';
          var iconBgColor = '#fff';
          var iconSize = '20';
          var iconRadius = '4';

          if (this.dataModel.attach && this.dataModel.attach != 'asterisk-suffix') {
            this._jqObj.find(".tfp-label-attach").after("<span class=\"" + iconClass + "\"  style=\"margin-right:3px;font-size:" + iconSize + "px;border-radius:" + iconRadius + "px;color:" + iconColor + ";background-color:" + iconBgColor + ";\"></span>");
          } else {
            this._jqObj.prepend("<span class=\"" + iconClass + "\"  style=\"line-height: normal;margin-right:3px;font-size:" + iconSize + "px;border-radius:" + iconRadius + "px;color:" + iconColor + ";background-color:" + iconBgColor + ";\"></span>");
          }
        } else {
          this.dataModel.iconSize = 20;
          this.dataModel.iconRadius = 4;
          this.dataModel.icon = undefined;

          this._jqObj.find(".iconfont").remove();
        }
      }
    }
  }, {
    key: "icon",
    get: function get() {
      return this.dataModel.icon;
    },
    set: function set(value) {
      if (JSON.stringify(value) == '{}') value = undefined;
      this.dataModel.icon = value;
      var iconClass = 'iconfont icon-album';
      if (value && value["class"] !== 'undefined') iconClass = value["class"];
      var iconColor = '#000';
      if (value && value.color !== 'undefined') iconColor = value.color;
      var iconBgColor = '#fff';
      if (value && value.bgColor !== 'undefined') iconBgColor = value.bgColor;
      var iconSize = this.dataModel.iconSize;
      if (!iconSize) iconSize = '20';
      var iconRadius = this.dataModel.iconRadius;
      if (!iconRadius) iconRadius = '4';

      this._jqObj.find(".iconfont").remove();

      if (this.dataModel.attach && this.dataModel.attach != 'asterisk-suffix') {
        this._jqObj.find(".tfp-label-attach").after("<span class=\"" + iconClass + "\"  style=\"line-height: normal;margin-right:3px;font-size:" + iconSize + "px;border-radius:" + iconRadius + "px;color:" + iconColor + ";background-color:" + iconBgColor + ";\"></span>");
      } else {
        this._jqObj.prepend("<span class=\"" + iconClass + "\"  style=\"line-height: normal;margin-right:3px;font-size:" + iconSize + "px;border-radius:" + iconRadius + "px;color:" + iconColor + ";background-color:" + iconBgColor + ";\"></span>");
      }
    }
  }, {
    key: "iconSize",
    get: function get() {
      return this.dataModel.iconSize;
    },
    set: function set(value) {
      this.dataModel.iconSize = value;

      if (this._jqObj) {
        this._jqObj.find(".iconfont").css("font-size", "" + value + "px");
      }
    }
  }, {
    key: "iconRadius",
    get: function get() {
      return this.dataModel.iconRadius;
    },
    set: function set(value) {
      this.dataModel.iconRadius = value;

      if (this._jqObj) {
        this._jqObj.find(".iconfont").css("border-radius", "" + value + "px");
      }
    } //数据绑定格式

  }, {
    key: "dataBindingFormat",
    get: function get() {
      return this.dataModel.dataBindingFormat;
    },
    set: function set(value) {
      this.dataModel.dataBindingFormat = value;
    }
  }, {
    key: "getBodyHtml",
    value: function getBodyHtml(getComponentsHtml) {
      var html = '';
      var val = '';
      var iconClass = 'iconfont icon-album';
      if (this.dataModel.icon && this.dataModel.icon["class"] !== 'undefined') iconClass = this.dataModel.icon["class"];
      var iconColor = '#000';
      if (this.dataModel.icon && this.dataModel.icon.color !== 'undefined') iconColor = this.dataModel.icon.color;
      var iconBgColor = '#fff';
      if (this.dataModel.icon && this.dataModel.icon.bgColor !== 'undefined') iconBgColor = this.dataModel.icon.bgColor;
      var iconSize = this.dataModel.iconSize;
      if (!iconSize) iconSize = '20';
      var iconRadius = this.dataModel.iconRadius;
      if (!iconRadius) iconRadius = '4';

      if (!this._tfp.isNull(this.dataModel.value)) {
        val = this.dataModel.value;
      } else if (this._tfp.isDesigning && !this._tfp.isNull(this.dataModel.dataBindingFormat)) {
        val = this.dataModel.dataBindingFormat;
      }

      var color = '#f56c6c';
      if (this.dataModel.attachColor) color = this.dataModel.attachColor;
      var colorClass = '';

      if (this.dataModel.attach == 'vertical-bar-prefix' && !this.dataModel.attachColor) {
        colorClass = 'vertical-bar-prefix-color';
        color = '';
      }

      if (this.dataModel.attach) {
        if (this.dataModel.attach == 'asterisk-prefix') {
          html += '<span class="tfp-label-attach" style=\"float:left;margin-right:5px;color:' + color + ';\">*</span>';
          if (this.dataModel.showImage) html += "<span class=\"" + iconClass + "\"  style=\"line-height: normal;margin-right:3px;font-size:" + iconSize + "px;border-radius:" + iconRadius + "px;color:" + iconColor + ";background-color:" + iconBgColor + ";\"></span>";
          html += val;
        } else if (this.dataModel.attach == 'asterisk-suffix') {
          if (this.dataModel.showImage) html += "<span class=\"" + iconClass + "\"  style=\"line-height: normal;margin-right:3px;font-size:" + iconSize + "px;border-radius:" + iconRadius + "px;color:" + iconColor + ";background-color:" + iconBgColor + ";\"></span>";
          html += val;
          html += '<span class="tfp-label-attach" style=\"float:right;margin-left:5px;color:' + color + ';\">*</span>';
        } else if (this.dataModel.attach == 'vertical-bar-prefix') {
          html += '<span class="tfp-label-attach ' + colorClass + '" style=\"float:left;width:4px;height:24px;margin-right:10px;background-color:' + color + ';\"></span>';
          if (this.dataModel.showImage) html += "<span class=\"" + iconClass + "\"  style=\"line-height: normal;margin-right:3px;font-size:" + iconSize + "px;border-radius:" + iconRadius + "px;color:" + iconColor + ";background-color:" + iconBgColor + ";\"></span>";
          html += val;
        }

        return html;
      } else {
        if (this.dataModel.showImage) html += "<span class=\"" + iconClass + "\"  style=\"line-height: normal;margin-right:3px;font-size:" + iconSize + "px;border-radius:" + iconRadius + "px;color:" + iconColor + ";background-color:" + iconBgColor + ";\"></span>";
        html += val;
        return html;
      }
    }
  }, {
    key: "css",
    value: function css(styleName, styleValue) {
      if (arguments.length == 0) return; //获取样式值

      if (arguments.length == 1) {
        if (!this.dataModel.styles) return null;
        return this.dataModel.styles[styleName];
      }

      (0, _get2["default"])((0, _getPrototypeOf2["default"])(Label.prototype), "css", this).call(this, styleName, styleValue);

      if (styleName == "text-align" && styleValue) {
        if (this._jqObj) {
          if (styleValue == "left" || styleValue == "start") {
            this._jqObj.css("justify-content", "flex-start");
          } else if (styleValue == "right" || styleValue == "end") {
            this._jqObj.css("justify-content", "flex-end");
          } else if (styleValue == "center") {
            this._jqObj.css("justify-content", "center");
          } else if (styleValue == "justify") {
            this._jqObj.css("justify-content", "space-between");
          }
        }
      }
    }
  }, {
    key: "show",
    value: function show() {
      if (this._jqObj) this._jqObj.css("display", "inline-flex");
    }
  }, {
    key: "initDesigning",
    value: function initDesigning() {
      if (this._jqObj) {
        var parentEl = this._jqObj.parent();

        if (parentEl.length > 0 && parentEl.get(0).tagName == "TD") {
          this._jqObj.css("vertical-align", "middle");
        }
      }
    }
  }]);
  return Label;
}(_controller.VisibleComponent);

exports["default"] = Label;