"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "InputNumber",
  "comment": "计数器",
  "cssFiles": "style.{bgColorMode}.css",
  "attrs": [{
    "name": "inputSetting",
    "comment": "输入项设置",
    "type": "group",
    "items": [{
      "name": "value",
      "comment": "默认值",
      "type": "int",
      "default": 1
    }, {
      "name": "maxValue",
      "comment": "最大值",
      "type": "int"
    }, {
      "name": "minValue",
      "comment": "最小值",
      "type": "int"
    }, {
      "name": "stepsNumber",
      "comment": "步数",
      "type": "int",
      "default": 1
    }, {
      "name": "accuracy",
      "comment": "精度",
      "type": "Switch"
    }, {
      "name": "comment",
      "comment": "组件备注",
      "type": "String"
    }, {
      "name": "dataBindingFormat",
      "comment": "数据绑定格式",
      "type": "String"
    }, {
      "name": "required",
      "comment": "必填",
      "type": "Switch"
    }, {
      "name": "readonly",
      "comment": "只读",
      "type": "Switch"
    }, {
      "name": "disabled",
      "comment": "禁用",
      "type": "Switch"
    }, {
      "name": "encrypted",
      "comment": "加密发送",
      "type": "Switch"
    }]
  }],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
    "width": "130px",
    "height": "30px"
  },
  "events": [{
    "name": "onAfterInitRuntime",
    "comment": "组件初始化后",
    "isNotHtmlEvent": true
  }, {
    "name": "onClick",
    "comment": "点击时"
  }, {
    "name": "onChange",
    "comment": "值发生变化时",
    "isNotHtmlEvent": true
  }]
};
exports["default"] = _default;