"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 计数器组件
 * @param {[type]} dataModel [description]
 */
var InputNumber = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(InputNumber, _FormInput);

  var _super = _createSuper(InputNumber);

  function InputNumber(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, InputNumber);
    return _super.call(this, __tfp, "InputNumber", dataModel, parent);
  }

  (0, _createClass2["default"])(InputNumber, [{
    key: "value",
    get: function get() {
      return this.dataModel.value;
    },
    set: function set(value) {
      if (value) {
        this.dataModel.value = value;
      } else {
        this.dataModel.value = 0;
      }

      if (this._jqObj) {
        this._jqObj.find("input").val(this.dataModel.value);
      }
    }
  }, {
    key: "maxValue",
    get: function get() {
      return this.dataModel.maxValue;
    },
    set: function set(value) {
      if (value) {
        this.dataModel.maxValue = value;
      } else {
        this.dataModel.maxValue = "";
      }
    }
  }, {
    key: "minValue",
    get: function get() {
      return this.dataModel.minValue;
    },
    set: function set(value) {
      if (value) {
        this.dataModel.minValue = value;
      } else {
        this.dataModel.minValue = "";
      }
    }
  }, {
    key: "stepsNumber",
    get: function get() {
      return this.dataModel.stepsNumber;
    },
    set: function set(value) {
      if (value) {
        this.dataModel.stepsNumber = value;
      } else {
        this.dataModel.stepsNumber = 1;
      }
    }
  }, {
    key: "accuracy",
    get: function get() {
      return this.dataModel.accuracy;
    },
    set: function set(value) {
      this.dataModel.accuracy = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.accuracy) {
          this._jqObj.find("input").val(parseFloat(this.dataModel.value).toFixed(2));
        } else {
          this._jqObj.find("input").val(this.dataModel.value);
        }
      }
    }
  }, {
    key: "inputNumberChange",
    value: function inputNumberChange() {
      var that = this;

      this._jqObj.find("button").eq(0).click(function () {
        var reduceVal = null;
        $(this).siblings("button").css("cursor", "pointer");

        if (parseFloat(that.dataModel.value) - parseFloat(that.dataModel.stepsNumber) < parseFloat(that.dataModel.minValue)) {
          reduceVal = parseFloat(that.dataModel.value);
          $(this).css("cursor", "not-allowed");
        } else {
          reduceVal = parseFloat(parseFloat(that.dataModel.value) - parseFloat(that.dataModel.stepsNumber));
        }

        if (that.dataModel.accuracy) {
          that._jqObj.find("input").val(reduceVal.toFixed(2));
        } else {
          that._jqObj.find("input").val(reduceVal);
        }

        that.dataModel.value = that._jqObj.find("input").val();

        if (!that._tfp.isDesigning) {
          that.valueOnChange();
          that.exeEventHandler("onChange", that.dataModel.value);
        }
      });

      this._jqObj.find("button").eq(1).click(function () {
        var addVal = null;
        $(this).siblings("button").css("cursor", "pointer");

        if (parseFloat(that.dataModel.value) + parseFloat(that.dataModel.stepsNumber) > parseFloat(that.dataModel.maxValue)) {
          addVal = parseFloat(that.dataModel.value);
          $(this).css("cursor", "not-allowed");
        } else {
          addVal = parseFloat(parseFloat(that.dataModel.value) + parseFloat(that.dataModel.stepsNumber));
        }

        if (that.dataModel.accuracy) {
          that._jqObj.find("input").val(addVal.toFixed(2));
        } else {
          that._jqObj.find("input").val(addVal);
        }

        that.dataModel.value = that._jqObj.find("input").val();

        if (!that._tfp.isDesigning) {
          that.valueOnChange();
          that.exeEventHandler("onChange", that.dataModel.value);
        }
      });

      this._jqObj.find("input").blur(function () {
        var inputVal = $(this).val();
        var val = null;

        if (!/(^[\-0-9][0-9]*(\.[0-9]+)?)$/.test(inputVal)) {
          if (inputVal == '') {
            val = 0;
          } else {
            val = parseFloat(that.dataModel.value);
          }
        } else {
          if (parseFloat(inputVal) < parseFloat(that.dataModel.minValue) && inputVal != '') {
            val = parseFloat(that.dataModel.minValue);
          } else if (parseFloat(inputVal) > parseFloat(that.dataModel.maxValue)) {
            val = parseFloat(that.dataModel.maxValue);
          } else {
            val = parseFloat(inputVal);
          }
        }

        if (that.dataModel.accuracy) {
          $(this).val(val.toFixed(2));
        } else {
          $(this).val(val);
        }

        that.dataModel.value = $(this).val();

        if (!that._tfp.isDesigning) {
          that.valueOnChange();
          that.exeEventHandler("onChange", that.dataModel.value);
        }
      });

      this._jqObj.find("input").keypress(function (even) {
        if (even.which == 13) {
          var inputVal = $(this).val();
          var val = null;

          if (!/(^[\-0-9][0-9]*(\.[0-9]+)?)$/.test(inputVal)) {
            if (inputVal == '') {
              val = 0;
            } else {
              val = parseFloat(that.dataModel.value);
            }
          } else {
            if (parseFloat(inputVal) < parseFloat(that.dataModel.minValue) && inputVal != '') {
              val = parseFloat(that.dataModel.minValue);
            } else if (parseFloat(inputVal) > parseFloat(that.dataModel.maxValue)) {
              val = parseFloat(that.dataModel.maxValue);
            } else {
              val = parseFloat(inputVal);
            }
          }

          if (that.dataModel.accuracy) {
            $(this).val(val.toFixed(2));
          } else {
            $(this).val(val);
          }

          that.dataModel.value = $(this).val();

          if (!that._tfp.isDesigning) {
            that.valueOnChange();
            that.exeEventHandler("onChange", that.dataModel.value);
          }
        }
      });
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      if (that.dataModel.readonly || that.dataModel.disabled) {
        that._jqObj.find("input").attr("disabled", "disabled");

        that._jqObj.find("button").css("cursor", "not-allowed");

        return;
      }

      ;
      this.inputNumberChange();
    }
  }]);
  return InputNumber;
}(_controller.FormInput);

exports["default"] = InputNumber;