"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 图片组组件
 * @param {[type]} dataModel [description]
 */
var ImageList = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(ImageList, _FormInput);

  var _super = _createSuper(ImageList);

  function ImageList(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, ImageList);
    return _super.call(this, __tfp, "ImageList", dataModel, parent);
  }

  (0, _createClass2["default"])(ImageList, [{
    key: "value",
    get: function get() {
      if (!this.dataModel.value) return [];
      return this.dataModel.value;
    },
    set: function set(value) {
      if (!value) {
        this.dataModel.value = [];
      } else {
        if (value.indexOf(",") >= 0) {
          this.setHtml(value.split(','));
        } else {
          this.setHtml([value]);
        }
      }

      if (!this._tfp.isDesigning) {
        this.exeEventHandler("onChange");
      }
    }
  }, {
    key: "setHtml",
    value: function setHtml(data) {
      var that = this;

      if (data) {
        var imagesDiv = that._jqObj.find(".panel-box");

        if (!that.dataModel.value) {
          that.dataModel.value = [];
        }

        var imagesize = data.length > 4 ? "100" : "150";

        for (var x = 0; x < data.length; x++) {
          var html = '';

          var src = that._tfp.getUrlRealPath(data[x]);

          var beforesrc = '/Download?showImage=true&fileCode=';
          html += "\n        <div class=\"image_box\" data-code=\"" + src + x + "\"\n          style=\"width: " + imagesize + "px;height:" + imagesize + "px;position: relative;\n          align-items: center;justify-content: center;margin-bottom: 5px;background: #F7F7F7;margin-right: 5px;display:flex;\">\n          <img class=\"tfp-image\" src=\"" + (src.indexOf('http') == -1 ? beforesrc + src : src) + "\" style=\" width:100%; height:100%;\" data-code=\"" + src + "\">\n        ";
          html += "</div>";
          that.dataModel.value.push(src);
          imagesDiv.prepend(html); // 查看大图

          this._jqObj.find(".image_box[data-code='" + src + x + "']").find("img").click(function () {
            var code = $(this).attr("data-code");

            if (window.tmClient) {
              alert(window.tmClient.mobileType);

              if (window.tmClient.mobileType == 'renxun') {
                // 任讯
                tmClient.showImage({
                  imageCode: code
                });
              } else if (window.tmClient.mobileType == 'dingding') {
                // 钉钉
                window.tmClient.empower(function () {
                  window.tmClient.showImage({
                    imageList: data,
                    imageCode: code
                  }, function () {});
                });
              } else if (window.tmClient.mobileType == 'workwx') {
                // 企业微信
                window.tmClient.empower(function () {
                  window.tmClient.showImage({
                    imageList: data,
                    imageCode: code
                  }, function () {});
                });
              }
            } else {
              if ($(this).css("height") == imagesize + "px") {
                $(this).parent().css({
                  "top": "0",
                  "left": "0",
                  "right": "0",
                  "bottom": "0",
                  "position": "fixed",
                  "z-index": "99",
                  "width": "100%",
                  "height": "100%",
                  "background": "black"
                });
                $(this).css({
                  "height": "auto"
                });
              } else {
                $(this).parent().css({
                  "top": "0",
                  "left": "0",
                  "right": "0",
                  "bottom": "0",
                  "position": "relative",
                  "z-index": "1",
                  "width": imagesize + "px",
                  "height": imagesize + "px",
                  "background": "#F7F7F7"
                });
                $(this).css({
                  "height": imagesize + "px"
                });
              }
            }
          });
        }
      } else {
        return;
      }
    }
  }]);
  return ImageList;
}(_controller.FormInput);

exports["default"] = ImageList;