"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 图片组组件
 * @param {[type]} dataModel [description]
 */
var ImageList = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(ImageList, _FormInput);

  var _super = _createSuper(ImageList);

  function ImageList(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, ImageList);
    return _super.call(this, __tfp, "ImageList", dataModel, parent);
  }

  (0, _createClass2["default"])(ImageList, [{
    key: "value",
    get: function get() {
      if (!this.dataModel.value) return [];
      return this.dataModel.value;
    },
    set: function set(value) {
      if (!value) {
        this.dataModel.value = [];
      } else {
        if (value.indexOf(",") >= 0) {
          this.dataModel.value = value.split(',');
          this.setHtml(value.split(','), 0);
        } else {
          this.dataModel.value = [value];
          this.setHtml([value], 0);
        }
      }

      if (!this._tfp.isDesigning) {
        this.exeEventHandler("onChange");
      }
    }
  }, {
    key: "appCode",
    get: function get() {
      return this.dataModel.appCode;
    },
    set: function set(value) {
      this.dataModel.appCode = value;
    }
  }, {
    key: "appDataId",
    get: function get() {
      return this.dataModel.appDataId;
    },
    set: function set(value) {
      this.dataModel.appDataId = value;
    }
  }, {
    key: "setHtml",
    value: function setHtml(data) {
      var that = this;

      if (data) {
        var imagesDiv = that._jqObj.find(".panel-box");

        var imagesize = data.length > 4 ? "100" : "150";
        imagesDiv.children(".image_box").remove();

        for (var x = 0; x < data.length; x++) {
          var html = '';

          var src = that._tfp.getUrlRealPath(data[x]);

          var beforesrc = '/Download?showImage=true&fileCode=';
          html += "\n          <div class=\"image_box\" data-code=\"" + src + x + "\"\n          style=\"width: " + imagesize + "px;height:" + imagesize + "px;position: relative;\n          align-items: center;justify-content: center;margin-bottom: 5px;background: #F7F7F7;margin-right: 5px;display:flex;\">\n          <img class=\"tfp-image\" src=\"" + (src.indexOf('http') == -1 ? beforesrc + src : src) + "\" style=\" width:100%; height:100%;\" data-code=\"" + src + "\"  data-index=\"" + x + "\">";
          html += "</div>";
          imagesDiv.append(html);
        }

        this._jqObj.find(".image_box").find("img").click(function () {
          tfp.openImage(JSON.stringify(data), $(this).attr("data-index"));
        });
      } else {
        return;
      }
    }
  }, {
    key: "onAfterBindData",
    value: function onAfterBindData() {
      var args = {};

      if (this.dataModel.appCode && this.dataModel.appDataId) {
        args.app_code = this.dataModel.appCode;
        args.app_data_id = this.dataModel.appDataId;
      } //应用代码和应用数据id都设置了才能自动查询附件信息


      if (!args.app_code || !args.app_data_id) return;
      var that = this;

      this._tfp.use("Service", function () {
        var service = that._tfp["new"]("Service");

        service.path = "sys/service/app_attach/getUploadCptVal.tbs";
        service.request(args, function (req, res) {
          if (!res.data) return;
          var val = [];
          res.data.forEach(function (item) {
            val.push(item.code);
          });
          that.value = val.join(',');
        });
      });
    }
  }]);
  return ImageList;
}(_controller.FormInput);

exports["default"] = ImageList;