"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _render = _interopRequireDefault(require("../render.js"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var ImageRender = /*#__PURE__*/function (_TFPComponentRender) {
  (0, _inherits2["default"])(ImageRender, _TFPComponentRender);

  var _super = _createSuper(ImageRender);

  function ImageRender(__tfp, _dataModel, _level) {
    (0, _classCallCheck2["default"])(this, ImageRender);
    return _super.call(this, __tfp, _dataModel, _level);
  }

  (0, _createClass2["default"])(ImageRender, [{
    key: "getImageUrl",
    value: function getImageUrl() {
      var imgUrl = this.dataModel.src;

      if (this._tfp.isDesigning && (!imgUrl || imgUrl.indexOf('{') > -1)) {
        imgUrl = this._tfp.rootPath + "/src/components/image/images/default-photo.png";
      } else {
        imgUrl = this._tfp.getUrlRealPath(imgUrl);
      }

      return imgUrl;
    }
  }, {
    key: "getAttrHtml",
    value: function getAttrHtml(retainStyleAttr) {
      var attrHtml = (0, _get2["default"])((0, _getPrototypeOf2["default"])(ImageRender.prototype), "getAttrHtml", this).call(this, retainStyleAttr);

      if (!this._tfp.isDesigning || this.parentModel && this.parentModel.type == "Table") {
        attrHtml += " src=\"" + this.getImageUrl() + "\"";
      }

      if (!this.dataModel.alt) attrHtml += " alt=\"" + this.dataModel.id + "\"";
      return attrHtml;
    } //设计时，为了实现拖拽调整位置，需要用div+背景图片的形式，直接用图片无法拖拽

  }, {
    key: "getCustomStyleHtml",
    value: function getCustomStyleHtml() {
      if (this._tfp.isDesigning) {
        return "background-image:url(" + this.getImageUrl() + ");display:inline-block;background-size:" + this.dataModel.styles["width"] + " " + this.dataModel.styles["height"] + ";";
      }

      return "";
    }
  }, {
    key: "getHtml",
    value: function getHtml(getComponentsHtml, parentIndent, retainStyleAttr, parentModel) {
      if (this._tfp.isDesigning) {
        return (0, _get2["default"])((0, _getPrototypeOf2["default"])(ImageRender.prototype), "getHtml", this).call(this, "div", false, parentIndent, retainStyleAttr);
      } else {
        return (0, _get2["default"])((0, _getPrototypeOf2["default"])(ImageRender.prototype), "getHtml", this).call(this, "img", false, parentIndent, retainStyleAttr);
      }
    }
  }]);
  return ImageRender;
}(_render["default"]);

exports["default"] = ImageRender;