"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 图片组件
 * @param {[type]} dataModel [description]
 */
var Image = /*#__PURE__*/function (_VisibleComponent) {
  (0, _inherits2["default"])(Image, _VisibleComponent);

  var _super = _createSuper(Image);

  function Image(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, Image);
    return _super.call(this, __tfp, "Image", dataModel, parent);
  }

  (0, _createClass2["default"])(Image, [{
    key: "src",
    get: function get() {
      return this.dataModel.src;
    },
    set: function set(value) {
      this.dataModel.src = value;

      if (value && value.indexOf("{") > -1 && value.indexOf("}") > -1) {
        this.dataModel.dataBindingFormat = value;
      }

      if (!this._tfp.isDesigning && value) {
        if (value && (value.indexOf("http") > -1 || value.indexOf("?") > -1 || value.indexOf("&") > -1 || value.indexOf("/") > -1 || value.indexOf(".") > -1 || value.indexOf("{") > -1)) {
          value = this._tfp.getUrlRealPath(value);
        } else {
          value = "/Download?showImage=true&fileCode=" + value;
        }

        this._jqObj.attr("src", value);
      } else {
        if (value && value.indexOf("{") > -1 && value.indexOf("}") > -1) {
          value = this._tfp.rootPath + "/src/components/image/images/default-photo.png";
        } else {
          value = this._tfp.getUrlRealPath(value);
        }

        if (this._tfp.isDesigning) {
          this._jqObj.css("background-image", "url(" + value + ")");
        } else {
          this._jqObj.attr("src", value);
        }
      }
    }
  }, {
    key: "alt",
    get: function get() {
      return this.dataModel.alt;
    },
    set: function set(value) {
      this.dataModel.alt = value;

      if (this._jqObj) {
        this._jqObj.attr("alt", value);
      }
    }
  }, {
    key: "title",
    get: function get() {
      return this.dataModel.title;
    },
    set: function set(value) {
      this.dataModel.title = value;

      if (this._jqObj) {
        this._jqObj.attr("title", value);
      }
    }
  }, {
    key: "styleOnChange",
    value: function styleOnChange(styleName, styleValue) {
      if (this._tfp.isDesigning && (styleName == "width" || styleName == "height")) this._jqObj.css("background-size", this.dataModel.styles["width"] + " " + this.dataModel.styles["height"]);
    }
  }, {
    key: "initDesigning",
    value: function initDesigning() {
      if (this._jqObj) {
        if (this._jqObj.parent().length > 0 && this._jqObj.parent().get(0).tagName == "TD") {
          this._jqObj.css("vertical-align", "middle");

          if (!(this.dataModel.styles && this.dataModel.styles.display)) this._jqObj.css("display", "inline-block");
        }
      }
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      this.initDesigning();
    }
  }]);
  return Image;
}(_controller.VisibleComponent);

exports["default"] = Image;