"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _render = _interopRequireDefault(require("../render.js"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var IframeRender = /*#__PURE__*/function (_TFPComponentRender) {
  (0, _inherits2["default"])(IframeRender, _TFPComponentRender);

  var _super = _createSuper(IframeRender);

  function IframeRender(__tfp, _dataModel, _level) {
    (0, _classCallCheck2["default"])(this, IframeRender);
    return _super.call(this, __tfp, _dataModel, _level);
  }

  (0, _createClass2["default"])(IframeRender, [{
    key: "getAttrHtml",
    value: function getAttrHtml() {
      var attrHtml = "";

      if (!this._tfp.isDesigning) {
        attrHtml += " frameborder=\"" + this.dataModel.frameBorder + "\" marginwidth=\"" + this.dataModel.marginWidth + "\" marginheight=\"" + this.dataModel.marginHeight + "\"";
        if (this.dataModel.src) attrHtml += " src=\"" + this.dataModel.src + "\"";
        if (this.dataModel.scrolling) attrHtml += " scrolling=\"" + this.dataModel.scrolling + "\"";

        if (this.metadata.events) {
          for (var i = 0; i < this.metadata.events.length; i++) {
            var eventInfo = this.metadata.events[i];

            if (eventInfo.name in this.dataModel) {
              attrHtml += " " + eventInfo.name.toLowerCase() + "=\"" + this.dataModel[eventInfo.name] + "\"";
            }
          }
        }
      }

      return attrHtml;
    }
  }, {
    key: "getBodyHtml",
    value: function getBodyHtml(getComponentsHtml) {
      var bodyHtml = "\r\n";
      var indent = this.getHtmlIndent();

      if (this._tfp.isDesigning) {
        bodyHtml += indent + "\t<iframe frameborder=\"" + this.dataModel.frameBorder + "\" marginwidth=\"" + this.dataModel.marginWidth + "\" marginheight=\"" + this.dataModel.marginHeight + "\" width=\"100%\" height=\"100%\"";
        if (this.dataModel.src) bodyHtml += " src=\"" + this.dataModel.src + "\"";
        if (this.dataModel.scrolling) bodyHtml += " scrolling=\"" + this.dataModel.scrolling + "\"";
        bodyHtml += "></iframe>\r\n";
        bodyHtml += indent + "\t<div style=\"position: absolute; z-index:2; top:0; left:0; " + "right:0; bottom:0; opacity: 0.1; background-color:#ffffff;\">\r\n";
      }

      return bodyHtml;
    }
  }, {
    key: "getHtml",
    value: function getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
      if (this._tfp.isDesigning) {
        return (0, _get2["default"])((0, _getPrototypeOf2["default"])(IframeRender.prototype), "getHtml", this).call(this, "div", false, parentIndent, retainStyleAttr);
      } else {
        return (0, _get2["default"])((0, _getPrototypeOf2["default"])(IframeRender.prototype), "getHtml", this).call(this, "iframe", false, parentIndent, retainStyleAttr);
      }
    }
  }]);
  return IframeRender;
}(_render["default"]);

exports["default"] = IframeRender;