"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 图标组件
 * @param {[type]} dataModel [description]
 */
var IconPicker = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(IconPicker, _FormInput);

  var _super = _createSuper(IconPicker);

  function IconPicker(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, IconPicker);
    return _super.call(this, __tfp, "IconPicker", dataModel, parent);
  }

  (0, _createClass2["default"])(IconPicker, [{
    key: "value",
    get: function get() {
      return this.dataModel.value;
    },
    set: function set(value) {
      var val = value;

      if (!val) {
        this._jqObj.find(".tfp-iconpicker-image").empty();

        this._jqObj.find(".tfp-iconpicker-image").css("background-color", "#ffffff");

        this.dataModel.value = null;
        return;
      }

      if (typeof val == "string") {
        if (val.indexOf("{") == 0 && val.indexOf("\"type\"") > 0) {
          val = JSON.parse(val);
        } else {
          //TODO url
          val = {
            type: "url",
            url: val
          };
        }
      }

      this.dataModel.value = val;
      if (!this._jqObj) return;
      var html = "";

      if (val.type == "iconfont") {
        html = '<span class="' + this.dataModel.value["class"] + '"></span>';

        this._jqObj.find(".tfp-iconpicker-image").empty().append(html);

        this._jqObj.find(".tfp-iconpicker-image").children("span").css({
          "font-size": "calc(" + this.dataModel.size + "px / 1.3)",
          "color": this.dataModel.value.color
        });

        this._jqObj.find(".tfp-iconpicker-image").css("background-color", this.dataModel.value.bgColor);
      } else {
        html = '<img src="' + this.dataModel.value.url + '" style="width:' + this.dataModel.size + '; height:' + this.dataModel.size + ';"></img>';

        this._jqObj.find(".tfp-iconpicker-image").empty().append(html);

        this._jqObj.find(".tfp-iconpicker-image").css("background-color", "#ffffff");
      }

      if (!this._tfp.isDesigning) {
        this.valueOnChange();
        this.exeEventHandler("onChange", this.dataModel.value);
      }
    }
  }, {
    key: "iconChoose",
    get: function get() {
      return this.dataModel.iconChoose;
    },
    set: function set(value) {
      this.dataModel.iconChoose = value ? true : false;
    }
  }, {
    key: "localChoose",
    get: function get() {
      return this.dataModel.localChoose;
    },
    set: function set(value) {
      this.dataModel.localChoose = value ? true : false;
    }
  }, {
    key: "urlChoose",
    get: function get() {
      return this.dataModel.urlChoose;
    },
    set: function set(value) {
      this.dataModel.urlChoose = value ? true : false;
    }
  }, {
    key: "showChooseBtn",
    get: function get() {
      return this.dataModel.showChooseBtn;
    },
    set: function set(value) {
      this.dataModel.showChooseBtn = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.showChooseBtn) {
          this._jqObj.find(".tfp-iconpicker-choose").show();
        } else {
          this._jqObj.find(".tfp-iconpicker-choose").hide();
        }
      }
    }
  }, {
    key: "size",
    get: function get() {
      return this.dataModel.size;
    },
    set: function set(value) {
      var size = "64";
      if (value) size = value;
      this.dataModel.size = parseInt(size);

      if (this._jqObj) {
        this._jqObj.find(".tfp-iconpicker-image").css({
          "width": this.dataModel.size + "px",
          "height": this.dataModel.size + "px",
          "margin-left": "calc(50% - " + this.dataModel.size / 2 + "px)"
        });

        if (this._tfp.isDesigning && !this.dataModel.value) {
          var _imgSize = Math.round(this.dataModel.size / 1.3);

          this._jqObj.find(".tfp-iconpicker-image").children("img").css({
            "width": _imgSize + "px",
            "height": _imgSize + "px"
          });
        } else {
          if (this.dataModel.value.type == "url") {
            this._jqObj.find(".tfp-iconpicker-image").children("img").css({
              "width": this.dataModel.size + "px",
              "height": this.dataModel.size + "px"
            });
          } else {
            this._jqObj.find(".iconfont").css("font-size", imgSize + "px");
          }
        }
      }
    }
  }, {
    key: "showIconPicker",
    value: function showIconPicker() {
      if (this.readonly) return;
      var args = {
        iconChoose: this.dataModel.iconChoose,
        localChoose: this.dataModel.localChoose,
        urlChoose: this.dataModel.urlChoose
      }; //sessionStorage.setItem('_OpenDialogArgs', JSON.stringify(args));

      var that = this;

      this._tfp.openDialog("选择图标", "/node_modules/tfp/src/components/iconpicker/IconPicker.tfp", '594px', '458px', args, function (ret) {
        that.value = ret;
      });
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      var btnIconPicker = this._jqObj.find(".tfp-iconpicker-choose");

      btnIconPicker.click(function () {
        that.showIconPicker();
      });

      var imgIconPicker = this._jqObj.find(".tfp-iconpicker-image");

      imgIconPicker.click(function () {
        that.showIconPicker();
      });
    }
  }]);
  return IconPicker;
}(_controller.FormInput);

exports["default"] = IconPicker;