"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 标题组件
 * @param {[type]} dataModel [description]
 */
var Heading = /*#__PURE__*/function (_VisibleComponent) {
  (0, _inherits2["default"])(Heading, _VisibleComponent);

  var _super = _createSuper(Heading);

  function Heading(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, Heading);
    return _super.call(this, __tfp, "Heading", dataModel, parent);
  } //标题值


  (0, _createClass2["default"])(Heading, [{
    key: "value",
    get: function get() {
      if (!this.dataModel.value) return this.headLevel.replace("h", "标题");
      return this.dataModel.value;
    },
    set: function set(value) {
      this.dataModel.value = value;

      if (this._jqObj) {
        this._jqObj.text(value);

        this.exeEventHandler("onChange");
      }
    }
  }, {
    key: "headLevel",
    get: function get() {
      return this.dataModel.headLevel ? this.dataModel.headLevel : "h1";
    },
    set: function set(value) {
      this.dataModel.headLevel = value;

      if (this._jqObj) {
        var nextEl = null;
        if (this._jqObj.next().length > 0) nextEl = this._jqObj.next();

        var parentEl = this._jqObj.parent();

        this._jqObj.remove();

        var Render = this._tfp.renders[this.type];
        var render = new Render(this._tfp, this.dataModel, this.level);

        if (nextEl) {
          nextEl.before(render.getHtml());
        } else {
          parentEl.append(render.getHtml());
        }

        this._jqObj = $("#" + this.id);
        this.el = this._jqObj.get(0);

        if (this._tfp.isDesigning) {
          this._tfp.initCptDesignSetting(this);

          window.parent.uiDesigner.selectCptEl(this); //this._jqObj.css("outline", "#CCCCCC dashed 1px");
        }
      }
    }
  }]);
  return Heading;
}(_controller.VisibleComponent);

exports["default"] = Heading;