"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "GridView",
  "comment": "数据表格",
  "cssFiles": ["style.{bgColorMode}.pc.css", "/node_modules/tfp/src/components/button/style.{bgColorMode}.css", {
    "src": "/node_modules/tfp/src/components/iconpicker/iconfont/iconfont.css",
    "onlyRuntime": true
  }, {
    "src": "/node_modules/tfp/src/components/button/iconfont/iconfont.css",
    "onlyRuntime": true
  }, {
    "src": "/node_modules/tfp/src/components/iconpicker/iconfont/iconfont_tb.css",
    "onlyDesigning": true
  }, {
    "src": "/node_modules/tfp/src/components/button/iconfont/iconfont_tb.css",
    "onlyDesigning": true
  }],
  "attrs": [{
    "name": "dataBindSetting",
    "comment": "数据绑定设置",
    "type": "group",
    "items": [{
      "name": "dataQuerySetting",
      "comment": "数据查询设置",
      "type": "Dialog",
      "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
      "width": "800px",
      "height": "640px"
    }, {
      "name": "notAutoLoadData",
      "comment": "不自动加载数据",
      "type": "Switch"
    }, {
      "name": "dataBindingKey",
      "comment": "数据主键字段名",
      "type": "String",
      "showModelFieldList": true
    }, {
      "name": "dataDeleteSetting",
      "comment": "数据删除设置",
      "type": "Dialog",
      "path": "taskbuilder-tfp-designer/DataDeleteSetting.tfp",
      "width": "700px",
      "height": "640px"
    }, {
      "name": "columns",
      "comment": "表格列设置",
      "type": "Dataset",
      "isGridCol": true,
      "keyCol": "name",
      "width": "800px",
      "height": "600px",
      "columns": [{
        "name": "base",
        "comment": "基本信息",
        "type": "group",
        "items": [{
          "id": "name",
          "name": "列名",
          "type": "String",
          "required": true
        }, {
          "id": "contentType",
          "name": "内容类型",
          "type": "Select",
          "default": "text",
          "options": [{
            "value": "text",
            "text": "文本"
          }, {
            "value": "button",
            "text": "按钮"
          }, {
            "value": "link",
            "text": "链接"
          }, {
            "value": "image",
            "text": "图片"
          }, {
            "value": "switch",
            "text": "开关"
          }, {
            "value": "progress",
            "text": "进度条"
          }, {
            "value": "custom",
            "text": "自定义"
          }]
        }, {
          "id": "align",
          "name": "水平对齐方式",
          "type": "Select",
          "default": "center",
          "options": [{
            "value": "left",
            "text": "左对齐"
          }, {
            "value": "center",
            "text": "居中对齐"
          }, {
            "value": "right",
            "text": "右对齐"
          }]
        }, {
          "id": "valign",
          "name": "垂直对齐方式",
          "type": "Select",
          "options": [{
            "value": "top",
            "text": "顶端对齐"
          }, {
            "value": "center",
            "text": "居中对齐"
          }, {
            "value": "right",
            "text": "底部对齐"
          }]
        }, {
          "id": "width",
          "name": "列宽度",
          "type": "Size"
        }, {
          "id": "fill",
          "name": "宽度弹性伸缩",
          "type": "Switch"
        }, {
          "id": "fixed",
          "name": "固定在列表左侧",
          "type": "Switch"
        }, {
          "id": "fixedOnRight",
          "name": "固定在列表右侧",
          "type": "Switch"
        }, {
          "id": "bgColor",
          "name": "背景颜色",
          "type": "Color"
        }, {
          "id": "format",
          "name": "数据绑定表达式",
          "type": "String",
          "wrap": true
        }, {
          "id": "onClick",
          "name": "点击后执行的脚本",
          "type": "Event",
          "wrap": true
        }, {
          "id": "class",
          "name": "CSS样式class",
          "type": "String",
          "wrap": true
        }, {
          "id": "style",
          "name": "自定义CSS样式",
          "type": "String",
          "wrap": true
        }]
      }, {
        "name": "text",
        "comment": "文本设置",
        "type": "group",
        "items": [{
          "id": "dataFormat",
          "name": "内容格式",
          "type": "Select",
          "default": "text",
          "options": [{
            "value": "text",
            "text": "文本"
          }, {
            "value": "int",
            "text": "整数"
          }, {
            "value": "decimal",
            "text": "小数"
          }, {
            "value": "filesize",
            "text": "文件大小：xxxKB,xxxMB,xxxGB,xxxTB"
          }, {
            "value": "money|0.00",
            "text": "金额：0.00"
          }, {
            "value": "money|0,000.00",
            "text": "金额：0,000.00"
          }, {
            "value": "week",
            "text": "星期：X"
          }, {
            "value": "week|星期",
            "text": "星期：星期X"
          }, {
            "value": "date|yyyy",
            "text": "年份：yyyy"
          }, {
            "value": "date|MM",
            "text": "月份：MM"
          }, {
            "value": "date|yyyy-MM",
            "text": "年月：yyyy-MM"
          }, {
            "value": "date|yyyy/MM",
            "text": "年月：yyyy/MM"
          }, {
            "value": "date|yyyy-MM-dd",
            "text": "日期：yyyy-MM-dd"
          }, {
            "value": "date|yyyy/MM/dd",
            "text": "日期：yyyy/MM/dd"
          }, {
            "value": "date|yyyy年MM月dd日",
            "text": "日期：yyyy年MM月dd日"
          }, {
            "value": "date|MM-dd",
            "text": "日期：MM-dd"
          }, {
            "value": "date|MM/dd",
            "text": "日期：MM/dd"
          }, {
            "value": "date|MM月dd日",
            "text": "日期：MM月dd日"
          }, {
            "value": "date|dd",
            "text": "日期：dd"
          }, {
            "value": "time|HH:mm",
            "text": "时间：HH:mm"
          }, {
            "value": "time|HH:mm:ss",
            "text": "时间：HH:mm:ss"
          }, {
            "value": "time|HH时mm分",
            "text": "时间：HH时mm分"
          }, {
            "value": "time|HH时mm分ss秒",
            "text": "时间：HH时mm分ss秒"
          }, {
            "value": "datetime|yyyy-MM-dd HH:mm",
            "text": "日期时间：yyyy-MM-dd HH:mm"
          }, {
            "value": "datetime|yyyy-MM-dd HH:mm:ss",
            "text": "日期时间：yyyy-MM-dd HH:mm:ss"
          }, {
            "value": "datetime|yyyy/MM/dd HH:mm",
            "text": "日期时间：yyyy/MM/dd HH:mm"
          }, {
            "value": "datetime|yyyy/MM/dd HH:mm:ss",
            "text": "日期时间：yyyy/MM/dd HH:mm:ss"
          }, {
            "value": "datetime|yyyy年MM月dd日 HH:mm",
            "text": "日期时间：yyyy年MM月dd日 HH:mm"
          }, {
            "value": "datetime|yyyy年MM月dd日 HH:mm:ss",
            "text": "日期时间：yyyy年MM月dd日 HH:mm:ss"
          }, {
            "value": "datetime|yyyy年MM月dd日 HH时mm分",
            "text": "日期时间：yyyy年MM月dd日 HH时mm分"
          }, {
            "value": "datetime|yyyy年MM月dd日 HH时mm分ss秒",
            "text": "日期时间：yyyy年MM月dd日 HH时mm分ss秒"
          }]
        }, {
          "id": "decimalCalcReg",
          "name": "小数取值规则",
          "type": "Select",
          "default": "",
          "options": [{
            "value": "",
            "text": "不处理"
          }, {
            "value": "trunc",
            "text": "取整"
          }, {
            "value": "round",
            "text": "四舍五入"
          }, {
            "value": "ceil",
            "text": "向上取整"
          }, {
            "value": "floor",
            "text": "向下取整"
          }, {
            "value": "toFixed",
            "text": "固定精度"
          }, {
            "value": "toPrecision",
            "text": "固定长度"
          }, {
            "value": "abs",
            "text": "求绝对值"
          }]
        }, {
          "id": "decimalLength",
          "name": "小数位数",
          "type": "Number"
        }, {
          "id": "maxLength",
          "name": "最多显示字符数(汉字算2位)",
          "type": "Number"
        }, {
          "id": "fontSize",
          "name": "文字字号",
          "type": "Number"
        }, {
          "id": "color",
          "name": "文字颜色",
          "type": "Color"
        }, {
          "id": "bold",
          "name": "文字加粗",
          "type": "Switch"
        }, {
          "id": "nowrap",
          "name": "不允许换行",
          "type": "Switch"
        }, {
          "id": "sum",
          "name": "计算合计值",
          "type": "Switch"
        }, {
          "id": "showMoreOnMouseOver",
          "name": "鼠标经过显示全部内容",
          "type": "Switch"
        }, {
          "id": "groupContent",
          "name": "分组显示内容",
          "type": "Switch"
        }, {
          "id": "groupSubTotal",
          "name": "显示分组小计",
          "type": "Switch"
        }, {
          "id": "allowEdit",
          "name": "允许编辑",
          "type": "Switch"
        }, {
          "id": "allowFilter",
          "name": "允许筛选",
          "type": "Switch"
        }, {
          "id": "subTotalRowBgColor",
          "name": "小计行背景颜色",
          "type": "Color"
        }, {
          "id": "icon",
          "name": "文本前面显示小图标",
          "type": "Icon"
        }, {
          "id": "iconSize",
          "name": "小图标大小",
          "type": "Size",
          "default": 20
        }, {
          "id": "iconRadius",
          "name": "小图标圆角",
          "type": "Size",
          "default": 4
        }]
      }, {
        "name": "link",
        "comment": "链接设置",
        "type": "group",
        "items": [{
          "id": "linkType",
          "name": "链接跳转方式",
          "type": "Select",
          "default": "self",
          "options": [{
            "value": "self",
            "text": "当前页面"
          }, {
            "value": "page",
            "text": "新页面"
          }, {
            "value": "dialog",
            "text": "对话框"
          }, {
            "value": "drawer",
            "text": "抽屉页"
          }, {
            "value": "window",
            "text": "新窗口"
          }]
        }, {
          "id": "targetTitle",
          "name": "跳转页面标题",
          "comment": "跳转页面标题",
          "type": "String"
        }, {
          "id": "linkUrl",
          "name": "跳转页面路径",
          "comment": "跳转页面路径",
          "type": "String",
          "wrap": true
        }, {
          "id": "dialogWidth",
          "name": "对话框宽度",
          "comment": "对话框宽度",
          "type": "Int"
        }, {
          "id": "dialogHeight",
          "name": "对话框高度",
          "comment": "对话框高度",
          "type": "Int"
        }, {
          "id": "linkFontSize",
          "name": "链接文字字号",
          "type": "Int"
        }, {
          "id": "linkFontColor",
          "name": "链接文字颜色",
          "type": "Color"
        }, {
          "id": "linkFontBold",
          "name": "链接文字加粗",
          "type": "Switch"
        }]
      }, {
        "name": "button",
        "comment": "按钮设置",
        "type": "group",
        "items": [{
          "id": "buttonType",
          "name": "按钮类型",
          "type": "Select",
          "options": [{
            "value": "default",
            "text": "默认按钮"
          }, {
            "value": "primary",
            "text": "主要按钮"
          }, {
            "value": "info",
            "text": "信息按钮"
          }, {
            "value": "warning",
            "text": "警告按钮"
          }, {
            "value": "success",
            "text": "成功按钮"
          }, {
            "value": "danger",
            "text": "危险按钮"
          }]
        }, {
          "id": "buttonTheme",
          "name": "按钮外观样式",
          "type": "Select",
          "default": "round",
          "options": [{
            "value": "rect",
            "text": "矩形"
          }, {
            "value": "round",
            "text": "圆角矩形"
          }, {
            "value": "ellipse",
            "text": "椭圆形"
          }]
        }, {
          "id": "buttonBgColor",
          "name": "按钮背景颜色",
          "type": "Color",
          "default": "#6666FF"
        }, {
          "id": "buttonFontColor",
          "name": "按钮文字颜色",
          "type": "Color",
          "default": "#FFFFFF"
        }, {
          "id": "buttonBorderColor",
          "name": "按钮边框颜色",
          "type": "Color"
        }, {
          "id": "buttonFontSize",
          "name": "按钮文字字号",
          "type": "Number"
        }, {
          "id": "buttonFontBold",
          "name": "按钮文字加粗",
          "type": "Switch"
        }, {
          "id": "buttonIcon",
          "name": "按钮图标",
          "type": "Icon"
        }, {
          "id": "showInMoreMenu",
          "name": "显示在更多菜单中",
          "type": "Switch"
        }]
      }, {
        "name": "image",
        "comment": "图片设置",
        "type": "group",
        "items": [{
          "id": "imgWidth",
          "name": "图片宽度",
          "type": "Size"
        }, {
          "id": "imgHeight",
          "name": "图片高度",
          "type": "Size"
        }]
      }, {
        "name": "switch",
        "comment": "开关设置",
        "type": "group",
        "items": [{
          "id": "selectedValue",
          "name": "开关选中值",
          "type": "String"
        }]
      }, {
        "name": "order",
        "comment": "排序设置",
        "type": "group",
        "items": [{
          "id": "allowOrder",
          "name": "启用点击列标题排序",
          "type": "Switch",
          "default": false
        }, {
          "id": "orderField",
          "name": "排序字段名",
          "type": "String"
        }, {
          "id": "orderType",
          "name": "默认排序方式",
          "type": "select",
          "options": [{
            "value": "",
            "text": "不排序"
          }, {
            "value": "asc",
            "text": "正序"
          }, {
            "value": "desc",
            "text": "倒序"
          }]
        }]
      }, {
        "name": "display",
        "comment": "显示条件",
        "type": "group",
        "items": []
      }, {
        "name": "crossTable",
        "comment": "行转列设置",
        "type": "group",
        "items": [{
          "id": "rowDataConvertToCol",
          "name": "转换类型",
          "type": "Select",
          "options": [{
            "value": "",
            "text": "不转换"
          }, {
            "value": "title",
            "text": "转换为列标题(只支持1列)"
          }, {
            "value": "data",
            "text": "转换为列数据"
          }]
        }, {
          "id": "crossTableTimeGroupType",
          "name": "按时间分组显示",
          "type": "Select",
          "options": [{
            "value": "",
            "text": "不按时间分组"
          }, {
            "value": "day",
            "text": "按日分组"
          }, {
            "value": "week",
            "text": "按周分组"
          }, {
            "value": "month",
            "text": "按月分组"
          }]
        }, {
          "id": "crossTableShowRowsSum",
          "name": "显示纵向合计值",
          "type": "Switch"
        }, {
          "id": "crossTableShowColsSum",
          "name": "显示横向合计值",
          "type": "Switch"
        }, {
          "id": "crossTableShowColsMin",
          "name": "显示横向最小值",
          "type": "Switch"
        }, {
          "id": "crossTableShowColsMax",
          "name": "显示横向最大值",
          "type": "Switch"
        }, {
          "id": "crossTableShowColsAvg",
          "name": "显示横向平均值",
          "type": "Switch"
        }, {
          "id": "crossTableShowColsPercent",
          "name": "显示横向百分比",
          "type": "Switch"
        }, {
          "id": "crossTableDefaultCellVal",
          "name": "值为空时显示",
          "type": "String",
          "default": "0"
        }]
      }]
    }]
  }, {
    "name": "toolBarSetting",
    "comment": "工具栏设置",
    "type": "group",
    "items": [{
      "name": "showToolBar",
      "comment": "显示工具栏",
      "type": "Switch",
      "default": false
    }, {
      "name": "showKeywordInput",
      "comment": "显示关键字搜索框",
      "type": "Switch",
      "default": false
    }, {
      "name": "queryKeywordFields",
      "comment": "关联关键字模糊查询的字段",
      "type": "Dialog",
      "inputType": "Dataset",
      "title": "关联关键字模糊查询的字段",
      "path": "taskbuilder-tfp-designer/selectFields.tfp",
      "width": "320px",
      "height": "480px"
    }, {
      "name": "showImportButton",
      "comment": "显示数据导入按钮",
      "type": "Switch",
      "default": false
    }, {
      "name": "dataImportSetting",
      "comment": "数据导入设置",
      "type": "Dialog",
      "path": "taskbuilder-tfp-designer/DataImportSetting.tfp",
      "width": "860px",
      "height": "640px"
    }, {
      "name": "showExportButton",
      "comment": "显示后台数据导出按钮",
      "type": "Switch",
      "default": false
    }, {
      "name": "dataExportSetting",
      "comment": "后台数据导出设置",
      "type": "Dialog",
      "path": "taskbuilder-tfp-designer/DataExportSetting.tfp",
      "width": "900px",
      "height": "640px"
    }, {
      "name": "showPageExportButton",
      "comment": "显示前端数据导出按钮",
      "type": "Switch",
      "default": false
    }, {
      "name": "onlyExportCheckedRow",
      "comment": "仅导出选中行数据",
      "type": "Switch",
      "default": false
    }, {
      "name": "pageExportFileName",
      "comment": "前端导出的文件名",
      "type": "String"
    }, {
      "name": "showPrintButton",
      "comment": "显示打印按钮",
      "type": "Switch",
      "default": false
    }, {
      "name": "printReportPath",
      "comment": "打印报表路径",
      "type": "PathPicker",
      "fileTypes": ["tpr"]
    },
    /*{
      "name": "showCustomQueryButton",
      "comment": "显示自定义查询按钮",
      "type": "Switch",
      "default": false
    },
    {
      "name": "customQueryFields",
      "comment": "自定义查询字段设置",
      "type": "Dialog",
      "inputType": "Dataset",
      "title": "自定义查询字段设置",
      "path": "taskbuilder-tfp-designer/selectFields.tfp",
      "width": "320px",
      "height": "480px"
    },*/
    {
      "name": "showCustomOrderButton",
      "comment": "显示自定义排序按钮",
      "type": "Switch",
      "default": false
    }, {
      "name": "customOrderFields",
      "comment": "自定义排序字段设置",
      "type": "Dialog",
      "inputType": "Dataset",
      "title": "自定义排序字段设置",
      "path": "taskbuilder-tfp-designer/selectFields.tfp",
      "width": "320px",
      "height": "480px"
    }, {
      "name": "showFilterColButton",
      "comment": "显示表格列筛选按钮",
      "type": "Switch",
      "default": false
    }, {
      "name": "toolButtons",
      "comment": "工具栏自定义按钮设置",
      "type": "Dataset",
      "isPro": true,
      "keyCol": "name",
      "width": "640px",
      "height": "460px",
      "columns": [{
        "id": "text",
        "name": "按钮文本",
        "type": "String",
        "required": true
      }, {
        "id": "title",
        "name": "按钮提示",
        "type": "String"
      }, {
        "id": "buttonType",
        "name": "按钮类型",
        "type": "Select",
        "options": [{
          "value": "default",
          "text": "默认按钮"
        }, {
          "value": "primary",
          "text": "主要按钮"
        }, {
          "value": "info",
          "text": "信息按钮"
        }, {
          "value": "warning",
          "text": "警告按钮"
        }, {
          "value": "success",
          "text": "成功按钮"
        }, {
          "value": "danger",
          "text": "危险按钮"
        }]
      }, {
        "id": "theme",
        "name": "按钮风格",
        "type": "Select",
        "options": [{
          "value": "rect",
          "text": "默认"
        }, {
          "value": "round",
          "text": "圆角矩形"
        }, {
          "value": "circle",
          "text": "椭圆形"
        }]
      }, {
        "id": "hiddenText",
        "name": "隐藏按钮文本",
        "type": "Switch",
        "default": false
      }, {
        "id": "buttonIcon",
        "name": "按钮图标",
        "type": "Icon"
      }, {
        "id": "bgColor",
        "name": "按钮背景颜色",
        "type": "color"
      }, {
        "id": "textColor",
        "name": "按钮文本颜色",
        "type": "color"
      }, {
        "id": "onClick",
        "name": "点击后执行的脚本",
        "type": "event"
      }]
    }]
  }, {
    "name": "headerSetting",
    "comment": "表头设置",
    "type": "group",
    "items": [{
      "name": "showHeader",
      "comment": "显示表头",
      "type": "Switch",
      "default": true
    }, {
      "name": "headerBold",
      "comment": "标题加粗",
      "type": "Switch",
      "default": true
    }, {
      "name": "headerBgColor",
      "comment": "标题栏背景色",
      "type": "Color",
      "default": "#F9F9F9"
    }, {
      "name": "headerTextColor",
      "comment": "标题栏文字颜色",
      "type": "Color",
      "default": "#333333"
    }, {
      "name": "headerHeight",
      "comment": "标题栏高度",
      "type": "Number",
      "default": "40"
    }]
  }, {
    "name": "bodySetting",
    "comment": "表体设置",
    "type": "group",
    "items": [{
      "name": "showRowNum",
      "comment": "显示序号",
      "type": "Switch",
      "default": false
    }, {
      "name": "showBorder",
      "comment": "显示边框",
      "type": "Switch",
      "default": true
    }, {
      "name": "showCheckbox",
      "comment": "显示选择框",
      "type": "Switch"
    }, {
      "name": "notChangeBgColorOnMouseOver",
      "comment": "鼠标滑过背景不变",
      "type": "Switch"
    }, {
      "name": "borderColor",
      "comment": "边框颜色",
      "type": "Color",
      "default": "#E6E6E6"
    }, {
      "name": "singleRowBgColor",
      "comment": "奇数行背景色",
      "type": "Color"
    }, {
      "name": "doubleRowBgColor",
      "comment": "偶数行背景色",
      "type": "Color"
    }, {
      "name": "selectedRowBgColor",
      "comment": "点击选中行背景色",
      "type": "Color"
    }, {
      "name": "rowHeight",
      "comment": "行高",
      "type": "Number",
      "default": "45"
    }]
  }, {
    "name": "footerSetting",
    "comment": "表尾设置",
    "type": "group",
    "items": [{
      "name": "showSumer",
      "comment": "显示合计栏",
      "type": "Switch"
    }, {
      "name": "allowPaging",
      "comment": "允许翻页",
      "type": "Switch",
      "default": false
    }, {
      "name": "pageSize",
      "comment": "每页显示数量",
      "type": "Select",
      "options": [{
        "value": "20",
        "text": "20"
      }, {
        "value": "30",
        "text": "30"
      }, {
        "value": "50",
        "text": "50"
      }, {
        "value": "100",
        "text": "100"
      }, {
        "value": "200",
        "text": "200"
      }, {
        "value": "300",
        "text": "300"
      }, {
        "value": "500",
        "text": "500"
      }]
    }]
  }, {
    "name": "treeSetting",
    "comment": "树形显示设置",
    "type": "group",
    "items": [{
      "name": "showTree",
      "comment": "支持树形显示",
      "type": "Switch"
    }, {
      "name": "expandAllNode",
      "comment": "默认展开全部节点",
      "type": "Switch",
      "default": true
    }, {
      "name": "dynamicLoadChildNodes",
      "comment": "动态加载子节点",
      "type": "Switch"
    }, {
      "name": "treeColIndex",
      "comment": "树形节点列索引",
      "type": "Number",
      "default": 0
    }, {
      "name": "gridNodeDataQuerySetting",
      "comment": "节点数据查询设置",
      "type": "Dialog",
      "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
      "width": "800px",
      "height": "640px",
      "isDataBindSetting": true
    }, {
      "name": "nodeIdField",
      "comment": "节点ID字段名",
      "type": "String",
      "default": "id"
    }, {
      "name": "parentNodeIdField",
      "comment": "父节点ID字段名",
      "type": "String",
      "default": "parent_id"
    }, {
      "name": "rootNodeId",
      "comment": "根节点的ID值",
      "type": "String",
      "default": "0"
    }, {
      "name": "rowDataIdField",
      "comment": "表格数据ID字段名",
      "type": "String",
      "showModelFieldList": true
    }, {
      "name": "rowDataParentIdField",
      "comment": "表格数据父节点ID字段名",
      "type": "String",
      "showModelFieldList": true
    }]
  }],
  "styles": ["size", "position", "background", "border", "margin", "other"],
  "defaultStyles": {
    "width": "100%",
    "height": "120px",
    "position": "absolute",
    "left": 0,
    "top": 0
  },
  "events": [{
    "name": "onAfterInitRuntime",
    "comment": "组件初始化后",
    "isNotHtmlEvent": true
  }, {
    "name": "onBeforeLoadData",
    "comment": "加载数据前",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "args",
      "type": "Object",
      "comment": "请求数据"
    }]
  }, {
    "name": "onAfterLoadData",
    "comment": "加载数据后",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "req",
      "type": "Object",
      "comment": "请求数据"
    }, {
      "name": "res",
      "type": "Object",
      "comment": "响应数据"
    }]
  }, {
    "name": "onBeforeBindData",
    "comment": "绑定数据前",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "data",
      "type": "Object",
      "comment": "绑定的数据"
    }]
  }, {
    "name": "onAfterBindData",
    "comment": "绑定数据后",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "data",
      "type": "Object",
      "comment": "绑定的数据"
    }]
  }, {
    "name": "onBeforeAddDataRow",
    "comment": "添加数据行前",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "rowIndex",
      "type": "Int",
      "comment": "行索引"
    }, {
      "name": "rowData",
      "type": "Object",
      "comment": "当前行数据"
    }]
  }, {
    "name": "onAfterAddDataRow",
    "comment": "添加数据行后",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "rowIndex",
      "type": "Int",
      "comment": "行索引"
    }, {
      "name": "rowData",
      "type": "Object",
      "comment": "当前行数据"
    }]
  }, {
    "name": "onBeforeDeleteData",
    "comment": "删除数据前",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "keyValue",
      "type": "string",
      "comment": "主键值"
    }, {
      "name": "args",
      "type": "Object",
      "comment": "请求参数"
    }, {
      "name": "res",
      "type": "Object",
      "comment": "响应参数"
    }]
  }, {
    "name": "onAfterDeleteData",
    "comment": "删除数据后",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "keyValue",
      "type": "string",
      "comment": "主键值"
    }, {
      "name": "args",
      "type": "Object",
      "comment": "请求参数"
    }, {
      "name": "res",
      "type": "Object",
      "comment": "响应参数"
    }]
  }, {
    "name": "onImport",
    "comment": "导入数据后",
    "isNotHtmlEvent": true
  }, {
    "name": "onExport",
    "comment": "导出数据后",
    "isNotHtmlEvent": true
  }, {
    "name": "onRowMouseOver",
    "comment": "鼠标进入行时",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "rowIndex",
      "type": "Int",
      "comment": "行索引"
    }]
  }, {
    "name": "onRowMouseOut",
    "comment": "鼠标离开行时",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "rowIndex",
      "type": "Int",
      "comment": "行索引"
    }]
  }, {
    "name": "onCellClick",
    "comment": "单击单元格时",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "rowIndex",
      "type": "Int",
      "comment": "行索引"
    }, {
      "name": "colIndex",
      "type": "Int",
      "comment": "列索引"
    }, {
      "name": "rowData",
      "type": "Object",
      "comment": "当前行数据"
    }]
  }, {
    "name": "onCellDblClick",
    "comment": "双击单元格时",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "rowIndex",
      "type": "Int",
      "comment": "行索引"
    }, {
      "name": "colIndex",
      "type": "Int",
      "comment": "列索引"
    }, {
      "name": "rowData",
      "type": "Object",
      "comment": "当前行数据"
    }]
  }, {
    "name": "onCellBindData",
    "isNotHtmlEvent": true,
    "comment": "绑定单元格数据时",
    "args": [{
      "name": "rowIndex",
      "type": "Int",
      "comment": "行索引"
    }, {
      "name": "colIndex",
      "type": "Int",
      "comment": "列索引"
    }, {
      "name": "rowData",
      "type": "Object",
      "comment": "当前行数据"
    }]
  }, {
    "name": "onClickCheckbox",
    "isNotHtmlEvent": true,
    "comment": "点击行选择框时",
    "args": [{
      "name": "rowIndex",
      "type": "Int",
      "comment": "行索引"
    }, {
      "name": "rowData",
      "type": "Object",
      "comment": "当前行数据"
    }, {
      "name": "checkbox",
      "type": "Object",
      "comment": "选择框元素"
    }, {
      "name": "checked",
      "type": "Boolean",
      "comment": "是否选中"
    }]
  }, {
    "name": "onClickCheckAll",
    "isNotHtmlEvent": true,
    "comment": "点击全选框时",
    "args": [{
      "name": "cbkAll",
      "type": "Object",
      "comment": "选择框元素"
    }, {
      "name": "checked",
      "type": "Boolean",
      "comment": "是否选中"
    }]
  }, {
    "name": "onExpandNode",
    "comment": "展开节点时",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "nodeId",
      "comment": "节点ID",
      "type": "String"
    }]
  }, {
    "name": "onFoldNode",
    "comment": "折叠节点时",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "nodeId",
      "comment": "节点ID",
      "type": "String"
    }]
  }],
  "methods": [{
    "name": "loadData",
    "comment": "加载数据",
    "args": [{
      "name": "toPage",
      "comment": "页数",
      "type": "Number",
      "required": true
    }]
  }, {
    "name": "reloadData",
    "comment": "重新加载数据"
  }, {
    "name": "reloadCurPage",
    "comment": "重新加载当前页数据"
  }, {
    "name": "bindData",
    "comment": "绑定数据",
    "args": [{
      "name": "data",
      "comment": "数据",
      "type": "Object",
      "required": true
    }]
  }, {
    "name": "getRow",
    "comment": "获得指定索引的行对象",
    "args": [{
      "name": "rowIndex",
      "comment": "行索引",
      "type": "Int",
      "required": true
    }, {
      "name": "retVarName",
      "comment": "返回给",
      "type": "varList",
      "width": "100px",
      "default": "row",
      "required": true,
      "isOnlyStr": true
    }]
  }, {
    "name": "getRowData",
    "comment": "获得指定索引行的数据",
    "args": [{
      "name": "rowIndex",
      "comment": "行索引",
      "type": "Int",
      "required": true
    }, {
      "name": "retVarName",
      "comment": "返回给",
      "type": "varList",
      "width": "100px",
      "default": "data",
      "required": true,
      "isOnlyStr": true
    }]
  }, {
    "name": "getCheckedKeys",
    "comment": "获得选中行的主键值",
    "args": [{
      "name": "retVarName",
      "comment": "返回给",
      "type": "varList",
      "width": "100px",
      "default": "keys",
      "required": true,
      "isOnlyStr": true
    }]
  }, {
    "name": "getCheckedData",
    "comment": "获得选中行的数据",
    "args": [{
      "name": "retVarName",
      "comment": "返回给",
      "type": "varList",
      "width": "100px",
      "default": "data",
      "required": true,
      "isOnlyStr": true
    }]
  }, {
    "name": "getRowsChecked",
    "comment": "获得选中行的对象",
    "args": [{
      "name": "retVarName",
      "comment": "返回给",
      "type": "varList",
      "width": "100px",
      "default": "rows",
      "required": true,
      "isOnlyStr": true
    }]
  }, {
    "name": "getSelectedRow",
    "comment": "获得当前点选行的对象",
    "args": [{
      "name": "retVarName",
      "comment": "返回给",
      "type": "varList",
      "width": "100px",
      "default": "row",
      "required": true,
      "isOnlyStr": true
    }]
  }, {
    "name": "getSelectedRowData",
    "comment": "获得当前点选行的数据",
    "args": [{
      "name": "retVarName",
      "comment": "返回给",
      "type": "varList",
      "width": "100px",
      "default": "data",
      "required": true,
      "isOnlyStr": true
    }]
  }, {
    "name": "getColumn",
    "comment": "获得指定索引的列",
    "args": [{
      "name": "colIndex",
      "comment": "列索引",
      "type": "Int",
      "required": true
    }, {
      "name": "retVarName",
      "comment": "返回给",
      "type": "varList",
      "width": "100px",
      "default": "col",
      "required": true,
      "isOnlyStr": true
    }]
  }, {
    "name": "getCell",
    "comment": "获得指定位置的单元格对象",
    "args": [{
      "name": "rowIndex",
      "comment": "行索引",
      "type": "Int",
      "required": true
    }, {
      "name": "colIndex",
      "comment": "列索引",
      "type": "Int",
      "required": true
    }, {
      "name": "retVarName",
      "comment": "返回给",
      "type": "varList",
      "width": "100px",
      "default": "cell",
      "required": true,
      "isOnlyStr": true
    }]
  }, {
    "name": "addRow",
    "comment": "添加行",
    "args": [{
      "name": "rowData",
      "comment": "行数据",
      "type": "Object",
      "required": true
    }]
  }, {
    "name": "checkRow",
    "comment": "选中指定索引的行",
    "args": [{
      "name": "rowIndex",
      "comment": "行索引",
      "type": "Int",
      "required": true
    }]
  }, {
    "name": "unCheckRow",
    "comment": "取消选中指定索引的行",
    "args": [{
      "name": "rowIndex",
      "comment": "行索引",
      "type": "Int",
      "required": true
    }]
  }, {
    "name": "checkAll",
    "comment": "全选"
  }, {
    "name": "unCheckAll",
    "comment": "取消全选"
  }, {
    "name": "deleteRowData",
    "comment": "删除指定主键值所在行",
    "args": [{
      "name": "keyValue",
      "comment": "主键值",
      "type": "String",
      "required": true
    }]
  }, {
    "name": "deleteCheckedRowsData",
    "comment": "删除选中行的数据"
  }, {
    "name": "removeRow",
    "comment": "移除指定行",
    "args": [{
      "name": "rowIndex",
      "comment": "行索引",
      "type": "Int",
      "required": true
    }]
  }, {
    "name": "scrollToTop",
    "comment": "滚动到顶部"
  }, {
    "name": "scrollToBottom",
    "comment": "滚动到底部"
  }, {
    "name": "scrollToLeft",
    "comment": "滚动到左侧"
  }, {
    "name": "scrollToRight",
    "comment": "滚动到右侧"
  }, {
    "name": "setColWidth",
    "comment": "设置指定列的宽度",
    "args": [{
      "name": "colIndex",
      "comment": "列索引",
      "type": "Int",
      "required": true
    }, {
      "name": "width",
      "comment": "列宽",
      "type": "Int",
      "required": true
    }]
  }, {
    "name": "getColWidth",
    "comment": "获得指定列的宽度",
    "args": [{
      "name": "colIndex",
      "comment": "列索引",
      "type": "Int",
      "required": true
    }, {
      "name": "retVarName",
      "comment": "返回给",
      "type": "varList",
      "width": "100px",
      "default": "width",
      "required": true,
      "isOnlyStr": true
    }]
  }, {
    "name": "addColumn",
    "comment": "添加列",
    "args": [{
      "name": "col",
      "comment": "列对象",
      "type": "Object",
      "required": true
    }]
  }, {
    "name": "showColumn",
    "comment": "显示列",
    "args": [{
      "name": "colIndex",
      "comment": "列索引",
      "type": "Int",
      "required": true
    }]
  }, {
    "name": "hideColumn",
    "comment": "隐藏列",
    "args": [{
      "name": "colIndex",
      "comment": "列索引",
      "type": "Int",
      "required": true
    }]
  }, {
    "name": "selectRow",
    "comment": "选中指定行",
    "args": [{
      "name": "rowIndex",
      "comment": "行索引",
      "type": "Int",
      "required": true
    }]
  }, {
    "name": "showRow",
    "comment": "显示行",
    "args": [{
      "name": "rowIndex",
      "comment": "行索引",
      "type": "Int",
      "required": true
    }]
  }, {
    "name": "hideRow",
    "comment": "隐藏行",
    "args": [{
      "name": "rowIndex",
      "comment": "行索引",
      "type": "Int",
      "required": true
    }]
  }, {
    "name": "getRowBgColor",
    "comment": "获得指定行背景色",
    "args": [{
      "name": "rowIndex",
      "comment": "行索引",
      "type": "Int",
      "required": true
    }, {
      "name": "retVarName",
      "comment": "返回给",
      "type": "varList",
      "width": "100px",
      "default": "bgColor",
      "required": true,
      "isOnlyStr": true
    }]
  }, {
    "name": "setRowBgColor",
    "comment": "设置指定行背景色",
    "args": [{
      "name": "rowIndex",
      "comment": "行索引",
      "type": "Int",
      "required": true
    }, {
      "name": "color",
      "comment": "背景颜色",
      "type": "String",
      "required": true
    }]
  }, {
    "name": "order",
    "comment": "根据指定字段的值进行排序",
    "args": [{
      "name": "field",
      "comment": "字段名",
      "type": "String",
      "required": true
    }, {
      "name": "type",
      "comment": "排序类型",
      "type": "String",
      "required": true
    }]
  }, {
    "name": "gotoPage",
    "comment": "跳转到指定页",
    "args": [{
      "name": "toPage",
      "comment": "页数",
      "type": "Number",
      "required": true
    }]
  }, {
    "name": "changePageSize",
    "comment": "设置每页显示记录数",
    "args": [{
      "name": "pageSize",
      "comment": "每页显示记录数",
      "type": "Int",
      "required": true
    }]
  }]
};
exports["default"] = _default;