"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "GridCell",
  "comment": "数据表格单元格",
  "attrs": [],
  "styles": ["background", "border", "margin", "other"],
  "defaultStyles": {
    "width": "100%",
    "position": "ralative"
  },
  "events": [{
    "name": "onClick",
    "comment": "点击时",
    "isNotHtmlEvent": true
  }, {
    "name": "onMouseOver",
    "comment": "鼠标经过时",
    "isNotHtmlEvent": true
  }, {
    "name": "onMouseOut",
    "comment": "鼠标移出时",
    "isNotHtmlEvent": true
  }, {
    "name": "beforeBindingData",
    "comment": "绑定数据前",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "rowIndex",
      "comment": "行索引",
      "type": "Int"
    }, {
      "name": "colIndex",
      "comment": "列索引",
      "type": "Int"
    }, {
      "name": "rowData",
      "comment": "行数据",
      "type": "Object"
    }]
  }, {
    "name": "afterBindingData",
    "comment": "绑定数据后",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "rowIndex",
      "comment": "行索引",
      "type": "Int"
    }, {
      "name": "colIndex",
      "comment": "列索引",
      "type": "Int"
    }, {
      "name": "rowData",
      "comment": "行数据",
      "type": "Object"
    }]
  }]
};
exports["default"] = _default;