"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _render = _interopRequireDefault(require("../render.js"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var GridRender = /*#__PURE__*/function (_TFPComponentRender) {
  (0, _inherits2["default"])(GridRender, _TFPComponentRender);

  var _super = _createSuper(GridRender);

  function GridRender(__tfp, _dataModel, _level) {
    (0, _classCallCheck2["default"])(this, GridRender);
    return _super.call(this, __tfp, _dataModel, _level);
  }

  (0, _createClass2["default"])(GridRender, [{
    key: "getBodyHtml",
    value: function getBodyHtml(getComponentsHtml) {
      var indent = this.getHtmlIndent();
      var html = "\r\n";
      var dataListTop = 0;

      if (this.dataModel.showHeader) {
        html += this.cpt.getHeaderHtml();
        dataListTop = this.cpt.headerHeight - 1;
      }

      var dataListBottom = 0;
      if (this.dataModel.showSumer) dataListBottom += 39;
      if (this.dataModel.allowPaging) dataListBottom += 49;
      html += indent + "\t<div class=\"tfp-grid-datalist\" style=\"bottom:" + dataListBottom + "px;top:" + dataListTop + "px;border-left: 1px solid " + this.cpt.borderColor + ";border-right: 1px solid " + this.cpt.borderColor + ";";
      if (!this.showHeader) html += "border-top:1px solid " + this.cpt.borderColor + ";";
      if (!this.showSumer && !this.allowPaging) html += "border-bottom:1px solid " + this.cpt.borderColor + ";";
      html += "\">\r\n";

      if (this._tfp.isDesigning) {
        html += this.cpt.getRowTemplate();
      }

      html += indent + "\t</div>\r\n";
      html += this.cpt.getSumerHtml();
      html += this.cpt.getFooterHtml();

      if (!this._tfp.isDesigning) {
        //在编译时，如果有自定义单元格，则需要生成单元格的模版HTML
        if (this.dataModel.components && this.dataModel.components.length > 0) {
          html += indent + "\t<div class=\"tfp-grid-datacell-template\" style=\"display:none;\">\r\n";
          var CellRender = this._tfp.renders["GridCell"];

          for (var i = 0; i < this.dataModel.components.length; i++) {
            var cellCdm = this.dataModel.components[i];
            this.cpt.setCptDataFormat(cellCdm);
            var cellRender = new CellRender(this._tfp, cellCdm);
            var cellHtml = cellRender.getHtml(true, indent, true);
            html += cellHtml;
          }

          html += indent + "\t</div>\r\n";
        }
      } //console.log(html);


      html += indent;
      return html;
    }
  }, {
    key: "getHtml",
    value: function getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
      return (0, _get2["default"])((0, _getPrototypeOf2["default"])(GridRender.prototype), "getHtml", this).call(this, "div", getComponentsHtml, parentIndent, retainStyleAttr);
    }
  }]);
  return GridRender;
}(_render["default"]);

exports["default"] = GridRender;