"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 数据表格组件
 * @param {[type]} dataModel [description]
 */
var Grid = /*#__PURE__*/function (_VisibleComponent) {
  (0, _inherits2["default"])(Grid, _VisibleComponent);

  var _super = _createSuper(Grid);

  function Grid(__tfp, dataModel, parent) {
    var _this;

    (0, _classCallCheck2["default"])(this, Grid);
    _this = _super.call(this, __tfp, "Grid", dataModel, parent);
    _this.pageSize = 20;
    _this.curPage = 0;
    _this.pageCount = 0;
    _this.rowsCount = 0;
    _this.dataList = [];

    if (__tfp.isDesigning) {
      if (!_this.dataModel.components || _this.dataModel.components.length == 0) {
        _this.dataModel.components = [{
          id: _this.id + "_DataRow",
          type: "GridDataRow",
          styles: {
            "position": "absolute",
            "top": "0",
            "left": "10px",
            "right": "10px",
            "height": "60px",
            "border": "1px solid #cccccc",
            "border-radius": "10px"
          }
        }];
      }
    }

    return _this;
  } //属性


  (0, _createClass2["default"])(Grid, [{
    key: "loadDataService",
    get: function get() {
      return this.dataModel.loadDataService;
    },
    set: function set(value) {
      this.dataModel.loadDataService = value;
    }
  }, {
    key: "dataBindingMember",
    get: function get() {
      return this.dataModel.dataBindingMember;
    },
    set: function set(value) {
      this.dataModel.dataBindingMember = value;
    }
  }, {
    key: "dataBindingKey",
    get: function get() {
      return this.dataModel.dataBindingKey;
    },
    set: function set(value) {
      this.dataModel.dataBindingKey = value;
    }
  }, {
    key: "showSearchBox",
    get: function get() {
      return this.dataModel.showSearchBox;
    },
    set: function set(value) {
      this.dataModel.showSearchBox = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.showSearchBox) {
          if (this._jqObj.find(".tfp-grid-searchbox").length > 0) {
            this._jqObj.find(".tfp-grid-searchbox").show();
          } else {
            $(this.getSearchBoxHtml()).insertBefore(this._jqObj.find(".tfp-grid-datalist"));
          }

          this._jqObj.find(".tfp-grid-datalist").css("top", "50px");
        } else {
          this._jqObj.find(".tfp-grid-searchbox").hide();

          this._jqObj.find(".tfp-grid-datalist").css("top", "0");
        }
      }
    }
  }, {
    key: "allowPaging",
    get: function get() {
      return this.dataModel.allowPaging;
    },
    set: function set(value) {
      this.dataModel.allowPaging = value ? true : false;

      if (this._jqObj) {
        if (this.dataModel.allowPaging) {
          if (this._jqObj.find(".tfp-grid-footer").length > 0) {
            this._jqObj.find(".tfp-grid-footer").show();
          } else {
            $(this.getFooterHtml()).insertAfter(this._jqObj.find(".tfp-grid-datalist"));
          }

          this._jqObj.find(".tfp-grid-datalist").css("bottom", "50px");
        } else {
          this._jqObj.find(".tfp-grid-footer").hide();

          this._jqObj.find(".tfp-grid-footer").css("bottom", "0");
        }
      }
    }
  }, {
    key: "containerEl",
    get: function get() {
      return this._jqObj.find(".tfp-grid-datalist").get(0);
    }
  }, {
    key: "deleteCptId",
    value: function deleteCptId(cptHtml) {
      var start = cptHtml.indexOf("id=\"");
      if (start < 0) return cptHtml;
      var end = cptHtml.indexOf("\"", start + 4);
      if (end < 0) return cptHtml;
      cptHtml = cptHtml.substr(0, start) + cptHtml.substr(end + 2);
      return this.deleteCptId(cptHtml);
    }
  }, {
    key: "setCptDataFormat",
    value: function setCptDataFormat(cdm) {
      //let cpt = this._tfp.get(cdm.id);
      if (cdm.dataBindingFormat) {
        cdm.value = cdm.dataBindingFormat;
      }

      if (cdm.components && cdm.components.length > 0) {
        for (var i = 0; i < cdm.components.length; i++) {
          this.setCptDataFormat(cdm.components[i]);
        }
      }
    }
  }, {
    key: "getSearchBoxHtml",
    value: function getSearchBoxHtml() {
      var html = "";

      if (this.showSearchBox) {
        var indent = this.getHtmlIndent();
        var imgUrl = this._tfp.rootPath + "/src/components/grid/images/search.png";
        var readonly = "";
        if (this._tfp.isDesigning) readonly = " readonly";
        html += indent + "\t<div class=\"tfp-grid-searchbox\">" + "<img src=\"" + imgUrl + "\" /><input type=\"text\"" + readonly + ">" + "<label>搜索</label></div>\r\n";
      }

      return html;
    }
  }, {
    key: "getFooterHtml",
    value: function getFooterHtml() {
      var html = "";

      if (this.allowPaging) {
        var indent = this.getHtmlIndent();
        html += indent + "\t<div class=\"tfp-grid-footer\">\r\n";
        html += indent + "\t\t<div style=\"border:0;\"></div>\r\n";
        html += indent + "\t\t<div>首页</div>\r\n";
        html += indent + "\t\t<div>上一页</div>\r\n";
        html += indent + "\t\t<div>下一页</div>\r\n";
        html += indent + "\t\t<div>尾页</div>\r\n";
        html += indent + "\t</div>\r\n";
      }

      return html;
    }
    /**
     * 动态创建行模板内的组件
     * @param  {[type]} cdm [description]
     * @return {[type]}     [description]
     */

  }, {
    key: "createRowCpt",
    value: function createRowCpt(parent, cdm, rowIndex, rowData) {
      $("#" + cdm.id).attr("id", cdm.id + "_" + rowIndex);
      cdm.id = cdm.id + "_" + rowIndex;
      var cptClass = this._tfp.controllers[cdm.type];

      if (!cptClass) {
        console.log("未找到名为[" + cdm.type + "]的组件控制器！");
        return;
      } //绑定组件属性中的动态数据


      for (var pname in cdm) {
        if (["id", "type"].includes(pname)) continue;
        var pval = cdm[pname];
        if (!pval || typeof pval != "string") continue;

        if (pval.indexOf("{") >= 0 && pval.indexOf("}") > 0) {
          try {
            pval = this._tfp.replaceDataField(rowData, pval);
            pval = this._tfp.exeExpress(pval);
          } catch (e) {
            console.log(e);
            return;
          }

          cdm[pname] = pval;
        }
      }

      var cpt = new cptClass(this._tfp, cdm, parent);
      window[cpt.id] = cpt;
      cpt._jqObj = $("#" + cpt.id);
      cpt.isRendered = true;
      if (cpt._jqObj.length > 0) cpt.el = cpt._jqObj[0];
      if (!cdm.components || cdm.components.length == 0) return;

      for (var i = 0; i < cdm.components.length; i++) {
        this.createRowCpt(cpt, cdm.components[i], rowIndex, rowData);
      }
    }
  }, {
    key: "bindData",
    value: function bindData(data) {
      if (!data || !Array.isArray(data)) return;
      this.dataList = data;
      var top = 0;

      for (var i = 0; i < this.dataModel.components.length; i++) {
        this._tfp.remove(this.dataModel.components[i]);
      }

      this.dataModel.components = [];

      var dataListDiv = this._jqObj.find(".tfp-grid-datalist");

      dataListDiv.empty();
      if (!this.showSearchBox) dataListDiv.css("top", "0");

      for (var i = 0; i < data.length; i++) {
        var rowData = data[i];
        var rowIndex = i;

        if (this.templateRowCdm.beforeBindingData) {
          try {
            rowData = eval(this.templateRowCdm.beforeBindingData);
          } catch (err) {
            console.log(err);
          }
        }

        var dataRowHtml = this.dataRowHtmlTemplate;
        top = i * (this.rowHeight + 10);

        try {
          dataRowHtml = this._tfp.replaceDataField(rowData, dataRowHtml);
          dataRowHtml = this._tfp.exeExpress(dataRowHtml);
        } catch (e) {
          console.log(e);
          return;
        }

        dataListDiv.append(dataRowHtml);
        var cdmRow = JSON.parse(JSON.stringify(this.templateRowCdm));
        this.createRowCpt(this, cdmRow, i, rowData);

        this._tfp.initCptRuntime(this._tfp.components[cdmRow.id]);

        var newRow = dataListDiv.find(".tfp-griddatarow").last();
        newRow.css("top", top + "px");
        var that = this;

        if (this.dataModel.onClickDataRow) {
          newRow.click(function () {
            var rowIndex = $(this).index();
            var rowData = that.dataList[rowIndex];

            try {
              eval(that.dataModel.onClickDataRow);
            } catch (err) {
              console.log(err.message);
            }
          });
        }

        if (this.templateRowCdm.afterBindingData) {
          try {
            eval(this.templateRowCdm.afterBindingData);
          } catch (err) {
            console.log(err);
          }
        }
      }

      dataListDiv.get(0).scrollTop = 0;
      if (this.allowPaging) this._jqObj.find(".tfp-grid-footer").find("div").eq(0).html(this.curPage + "/" + this.pageCount);
    }
  }, {
    key: "onLoadData",
    value: function onLoadData(req, res) {
      var data = [];

      if (this.dataModel.dataBindingMember) {
        data = res[this.dataModel.dataBindingMember];
      } else if (this.dataModel.dataQuerySetting && this.dataModel.dataQuerySetting.dataMember) {
        data = res[this.dataModel.dataQuerySetting.dataMember];
      }

      if (!data) return;

      if (this.allowPaging) {
        this.curPage = data.toPage;
        this.rowsCount = data.rowsCount;
        this.pageCount = data.pageCount;
        this.pageSize = data.pageSize;
        this.bindData(data.rows);
      } else {
        this.bindData(data);
      }
    }
  }, {
    key: "loadData",
    value: function loadData(toPage) {
      var args = {};

      if (this.allowPaging) {
        args = {
          pageSize: this.pageSize,
          toPage: toPage
        };
      }

      if (this.showSearchBox) {
        var keyword = this._jqObj.find(".tfp-grid-searchbox").find("input").val();

        if (keyword.trim() != "") args.keyword = keyword;
      }

      (0, _get2["default"])((0, _getPrototypeOf2["default"])(Grid.prototype), "loadData", this).call(this, args);
    }
  }, {
    key: "reloadData",
    value: function reloadData() {
      this.loadData(1);
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      var templateRow = this._jqObj.find(".tfp-griddatarow-template");

      this.dataRowHtmlTemplate = templateRow.get(0).outerHTML;
      this.dataRowHtmlTemplate = this.dataRowHtmlTemplate.replace("tfp-griddatarow-template", "tfp-griddatarow");
      this.rowHeight = templateRow.height();
      var tmpCdm = this.dataModel.components[0];
      this.templateRowCdm = JSON.parse(JSON.stringify(tmpCdm));
      this.dataModel.components = [];

      this._tfp.remove(tmpCdm.id);

      this._jqObj.find(".tfp-griddatarow-template").remove();

      this._jqObj.find(".tfp-grid-searchbox").find("label").click(function () {
        that.loadData(1);
      });

      if (this.allowPaging) {
        var footerDivs = this._jqObj.find(".tfp-grid-footer").find("div");

        var _that = this;

        footerDivs.eq(1).click(function () {
          _that.loadData(1);
        });
        footerDivs.eq(2).click(function () {
          var prevPage = _that.curPage - 1;
          if (prevPage < 1) prevPage = 1;

          _that.loadData(prevPage);
        });
        footerDivs.eq(3).click(function () {
          var nextPage = _that.curPage + 1;
          if (nextPage > _that.pageCount) nextPage = _that.pageCount;

          _that.loadData(nextPage);
        });
        footerDivs.eq(4).click(function () {
          _that.loadData(_that.pageCount);
        });
      } //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载


      if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService || this.dataModel.dataQuerySetting && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)) {
        this.loadData(1);
      }
    }
  }]);
  return Grid;
}(_controller.VisibleComponent);

exports["default"] = Grid;