"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  "name": "GanttChart",
  "comment": "甘特图",
  "cssFiles": ["style.css", "dhtmlxgantt.css", {
    "src": "/inc/dhtmlx-gantt/codebase/dhtmlxgantt.css",
    "onlyRuntime": true
  }],
  "jsFiles": ["dhtmlxgantt.js", {
    "src": "/inc/dhtmlx-gantt/codebase/dhtmlxgantt.js",
    "onlyRuntime": true
  } // , {
  //   "src": "http://export.dhtmlx.com/gantt/api.js",
  //   "onlyRuntime": true
  // }
  ],
  "attrs": [{
    "name": "dataBindSetting",
    "comment": "数据绑定设置",
    "type": "group",
    "items": [{
      "name": "loadDataService",
      "comment": "加载数据服务",
      "type": "Service"
    }]
  }, {
    "name": "taskDataBind",
    "comment": "任务数据绑定",
    "type": "group",
    "items": [{
      "name": "taskDataQuerySetting",
      "comment": "任务数据查询设置",
      "type": "Dialog",
      "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
      "width": "800px",
      "height": "640px",
      "isDataBindSetting": true
    }, {
      "name": "parentTaskID",
      "comment": "父任务ID",
      "type": "String",
      "default": "parent",
      "dataBindSetting": "taskDataQuerySetting",
      "showModelFieldList": true
    }, {
      "name": "taskID",
      "comment": "任务ID",
      "type": "String",
      "default": "id",
      "dataBindSetting": "taskDataQuerySetting",
      "showModelFieldList": true
    }, {
      "name": "taskStartDate",
      "comment": "任务开始日期",
      "type": "String",
      "default": "start_date",
      "dataBindSetting": "taskDataQuerySetting",
      "showModelFieldList": true
    }, {
      "name": "taskEndDate",
      "comment": "任务结束日期",
      "type": "String",
      "default": "end_date",
      "dataBindSetting": "taskDataQuerySetting",
      "showModelFieldList": true
    }, {
      "name": "taskHead",
      "comment": "任务负责人",
      "type": "String",
      "default": "task_head",
      "dataBindSetting": "taskDataQuerySetting",
      "showModelFieldList": true
    }, {
      "name": "taskText",
      "comment": "任务描述",
      "type": "String",
      "default": "text",
      "dataBindSetting": "taskDataQuerySetting",
      "showModelFieldList": true
    }, {
      "name": "taskProgress",
      "comment": "任务完成度",
      "type": "String",
      "default": "progress",
      "dataBindSetting": "taskDataQuerySetting",
      "showModelFieldList": true
    }, {
      "name": "taskDuration",
      "comment": "任务持续周期",
      "type": "String",
      "default": "duration",
      "dataBindSetting": "taskDataQuerySetting",
      "showModelFieldList": true
    }, {
      "name": "taskColor",
      "comment": "任务条颜色",
      "type": "String",
      "default": "color",
      "dataBindSetting": "taskDataQuerySetting",
      "showModelFieldList": true
    }, {
      "name": "taskMilestone",
      "comment": "任务类型",
      "type": "String",
      "default": "type",
      "dataBindSetting": "taskDataQuerySetting",
      "showModelFieldList": true
    }, {
      "name": "taskRollup",
      "comment": "里程碑显示方式",
      "type": "String",
      "default": "rollup",
      "dataBindSetting": "taskDataQuerySetting",
      "showModelFieldList": true
    }]
  }, {
    "name": "lineDataBind",
    "comment": "关联线数据绑定",
    "type": "group",
    "items": [{
      "name": "lineDataQuerySetting",
      "comment": "关联线数据查询设置",
      "type": "Dialog",
      "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
      "width": "800px",
      "height": "640px",
      "isDataBindSetting": true
    }, {
      "name": "lineId",
      "comment": "关联线ID",
      "type": "String",
      "default": "id",
      "dataBindSetting": "lineDataQuerySetting",
      "showModelFieldList": true
    }, {
      "name": "sourceTaskID",
      "comment": "数据源任务ID",
      "type": "String",
      "default": "source",
      "dataBindSetting": "lineDataQuerySetting",
      "showModelFieldList": true
    }, {
      "name": "targetTaskID",
      "comment": "目标源任务ID",
      "type": "String",
      "default": "targrt",
      "dataBindSetting": "lineDataQuerySetting",
      "showModelFieldList": true
    }, {
      "name": "lineType",
      "comment": "关联线类型",
      "type": "String",
      "default": "type",
      "dataBindSetting": "lineDataQuerySetting",
      "showModelFieldList": true
    }]
  }, {
    "name": "expandAll",
    "comment": "展开所有节点",
    "type": "Switch"
  }, {
    "name": "showNodeAddButton",
    "comment": "显示节点添加按钮",
    "type": "Switch"
  }, {
    "name": "readonly",
    "comment": "只读",
    "type": "Switch"
  }],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
    "width": "100%",
    "height": "100%"
  },
  "events": [{
    "name": "onAfterInitRuntime",
    "comment": "组件初始化后",
    "isNotHtmlEvent": true
  }, // {
  //   "name": "onClickNode",
  //   "comment": "单击节点时",
  //   "isNotHtmlEvent": true,
  //   "args": [
  //     {
  //       "name": "id",
  //       "comment": "节点ID",
  //       "type": "String"
  //     }
  //   ]
  // }, {
  //   "name": "onDblClickNode",
  //   "comment": "双击节点时",
  //   "isNotHtmlEvent": true,
  //   "args": [
  //     {
  //       "name": "id",
  //       "comment": "节点ID",
  //       "type": "String"
  //     }
  //   ]
  // },
  {
    "name": "onClickNodeAddButton",
    "comment": "点击节点的添加按钮时",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "id",
      "comment": "节点ID",
      "type": "String"
    }]
  }, {
    "name": "onLinkCreated",
    "comment": "任务之间创建新链接时",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "links",
      "comment": "链接对象",
      "type": "Object"
    }]
  }, {
    "name": "onAfterTaskDrag",
    "comment": "拖放任务时",
    "isNotHtmlEvent": true,
    "args": [{
      "name": "id",
      "type": "Int",
      "comment": "节点ID"
    }, {
      "name": "links",
      "type": "Object",
      "comment": "节点数据"
    }]
  }]
};
exports["default"] = _default;