"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _controller = require("../controller.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * 甘特图组件
 * @param {[type]} dataModel [description]
 */
var GanttChart = /*#__PURE__*/function (_FormInput) {
  (0, _inherits2["default"])(GanttChart, _FormInput);

  var _super = _createSuper(GanttChart);

  function GanttChart(__tfp, dataModel, parent) {
    (0, _classCallCheck2["default"])(this, GanttChart);
    return _super.call(this, __tfp, "GanttChart", dataModel, parent);
  }

  (0, _createClass2["default"])(GanttChart, [{
    key: "expandAll",
    get: function get() {
      return this.dataModel.expandAll;
    },
    set: function set(value) {
      this.dataModel.expandAll = value ? true : false;
    }
  }, {
    key: "showNodeAddButton",
    get: function get() {
      return this.dataModel.showNodeAddButton;
    },
    set: function set(value) {
      this.dataModel.showNodeAddButton = value ? true : false;
    }
  }, {
    key: "loadDataService",
    get: function get() {
      return this.dataModel.loadDataService;
    },
    set: function set(value) {
      this.dataModel.loadDataService = value;
    }
  }, {
    key: "taskDataMember",
    get: function get() {
      return this.dataModel.taskDataMember;
    },
    set: function set(value) {
      this.dataModel.taskDataMember = value;
    }
  }, {
    key: "parentTaskID",
    get: function get() {
      return this.dataModel.parentTaskID;
    },
    set: function set(value) {
      this.dataModel.parentTaskID = value;
    }
  }, {
    key: "taskID",
    get: function get() {
      return this.dataModel.taskID;
    },
    set: function set(value) {
      this.dataModel.taskID = value;
    }
  }, {
    key: "taskStartDate",
    get: function get() {
      return this.dataModel.taskStartDate;
    },
    set: function set(value) {
      this.dataModel.taskStartDate = value;
    }
  }, {
    key: "taskEndDate",
    get: function get() {
      return this.dataModel.taskEndDate;
    },
    set: function set(value) {
      this.dataModel.taskEndDate = value;
    }
  }, {
    key: "taskHead",
    get: function get() {
      return this.dataModel.taskHead;
    },
    set: function set(value) {
      this.dataModel.taskHead = value;
    }
  }, {
    key: "taskText",
    get: function get() {
      return this.dataModel.taskText;
    },
    set: function set(value) {
      this.dataModel.taskText = value;
    }
  }, {
    key: "taskProgress",
    get: function get() {
      return this.dataModel.taskProgress;
    },
    set: function set(value) {
      this.dataModel.taskProgress = value;
    }
  }, {
    key: "taskDuration",
    get: function get() {
      return this.dataModel.taskDuration;
    },
    set: function set(value) {
      this.dataModel.taskDuration = value;
    }
  }, {
    key: "taskColor",
    get: function get() {
      return this.dataModel.taskColor;
    },
    set: function set(value) {
      this.dataModel.taskColor = value;
    }
  }, {
    key: "taskMilestone",
    get: function get() {
      return this.dataModel.taskMilestone;
    },
    set: function set(value) {
      this.dataModel.taskMilestone = value;
    }
  }, {
    key: "taskRollup",
    get: function get() {
      return this.dataModel.taskRollup;
    },
    set: function set(value) {
      this.dataModel.taskRollup = value;
    }
  }, {
    key: "lineDataMember",
    get: function get() {
      return this.dataModel.lineDataMember;
    },
    set: function set(value) {
      this.dataModel.lineDataMember = value;
    }
  }, {
    key: "lineId",
    get: function get() {
      return this.dataModel.lineId;
    },
    set: function set(value) {
      this.dataModel.lineId = value;
    }
  }, {
    key: "sourceTaskID",
    get: function get() {
      return this.dataModel.sourceTaskID;
    },
    set: function set(value) {
      this.dataModel.sourceTaskID = value;
    }
  }, {
    key: "targetTaskID",
    get: function get() {
      return this.dataModel.targetTaskID;
    },
    set: function set(value) {
      this.dataModel.targetTaskID = value;
    }
  }, {
    key: "lineType",
    get: function get() {
      return this.dataModel.lineType;
    },
    set: function set(value) {
      this.dataModel.lineType = value;
    }
  }, {
    key: "loadLinkData",
    value: function loadLinkData(resTask, tasks) {
      if (this.dataModel.lineDataMember && resTask[this.dataModel.lineDataMember]) {
        this.bindData(tasks, resTask[this.dataModel.lineDataMember]);
        return;
      }

      if (!this.dataModel.lineDataQuerySetting || !(this.dataModel.lineDataQuerySetting.servicePath || this.dataModel.lineDataQuerySetting.serviceCpt)) {
        this.bindData(tasks, []);
        return;
      }

      var that = this;

      if (this.dataModel.lineDataQuerySetting && this.dataModel.lineDataQuerySetting.servicePath) {
        var options = {
          servicePath: this.dataModel.lineDataQuerySetting.servicePath,
          autoShowError: true,
          showLoading: true
        };

        if (this.dataModel.lineDataQuerySetting.requestArgs && this.dataModel.lineDataQuerySetting.requestArgs.length > 0) {
          options.argSettings = this.dataModel.lineDataQuerySetting.requestArgs;
        }

        if (this.dataModel.lineDataQuerySetting.encryptRequestArgs) options.encryptRequestArgs = this.dataModel.lineDataQuerySetting.encryptRequestArgs;
        if (this.dataModel.lineDataQuerySetting.encryptResponseArgs) options.encryptResponseArgs = this.dataModel.lineDataQuerySetting.encryptResponseArgs;

        this._tfp.request(options, function (req, res) {
          that.bindData(resTask, res[that.dataModel.lineDataQuerySetting.dataMember]);
        });

        return;
      }

      var serviceId = serviceId = this.dataModel.leafNodeDataQuerySetting.serviceCpt;

      var serviceCpt = this._tfp.get(serviceId);

      if (!serviceCpt) {
        this._tfp.showMsg("ID为[" + serviceId + "]的组件不存在！");

        return;
      }

      serviceCpt.status = 0;
      serviceCpt.request(null, function (req, res) {
        that.bindData(resTask, res[that.dataModel.lineDataQuerySetting.dataMember]);
      });
    }
  }, {
    key: "loadData",
    value: function loadData() {
      if (!this.dataModel.loadDataService && !this.dataModel.taskDataQuerySetting) {
        alert("请为[" + this.id + "]设置加载数据服务！");
        return;
      }

      var taskDataMember = this.dataModel.taskDataMember;
      if (this.dataModel.taskDataQuerySetting && this.dataModel.taskDataQuerySetting.dataMember) taskDataMember = this.dataModel.taskDataQuerySetting.dataMember;

      if (!taskDataMember) {
        alert("请为[" + this.id + "]设置任务数据成员！");
        return;
      }

      var that = this;

      if (this.dataModel.onBeforeLoadTaskData) {
        try {
          eval(this.dataModel.onBeforeLoadTaskData);
        } catch (err) {
          console.log(err);
        }
      }

      if (this.dataModel.taskDataQuerySetting && this.dataModel.taskDataQuerySetting.servicePath) {
        this._tfp.use("Service", function () {
          var service = that._tfp["new"]("Service");

          service.path = that.dataModel.taskDataQuerySetting.servicePath;

          if (that.dataModel.taskDataQuerySetting.requestArgs && that.dataModel.taskDataQuerySetting.requestArgs.length > 0) {
            service.argSettings = that.dataModel.taskDataQuerySetting.requestArgs;
          }

          if (that.dataModel.taskDataQuerySetting.encryptRequestArgs) service.encryptRequestArgs = that.dataModel.taskDataQuerySetting.encryptRequestArgs;
          if (that.dataModel.taskDataQuerySetting.encryptResponseArgs) service.encryptResponseArgs = that.dataModel.taskDataQuerySetting.encryptResponseArgs;
          service.request(null, function (req, res) {
            if (res.code != 0) {
              that._tfp.showMsg(res.message);

              return;
            }

            if (that.dataModel.onAfterLoadTaskData) {
              try {
                eval(that.dataModel.onAfterLoadTaskData);
              } catch (err) {
                console.log(err);
              }
            }

            that.loadLinkData(res, res[taskDataMember]);
          });
        });

        return;
      }

      var serviceId = this.dataModel.loadDataService;
      if (this.dataModel.taskDataQuerySetting && this.dataModel.taskDataQuerySetting.serviceCpt) serviceId = this.dataModel.taskDataQuerySetting.serviceCpt;
      var serviceCpt = this._tfp.components[serviceId];

      if (!serviceCpt) {
        this._tfp.showMsg("ID为[" + serviceId + "]的组件不存在！");

        return;
      } //与服务组件建立绑定


      if (!serviceCpt.bindCpts) serviceCpt.bindCpts = [];
      if (!serviceCpt.bindCpts.contains(this.id)) serviceCpt.bindCpts.push(this.id);
      serviceCpt.request(null, function (req, res) {
        that.loadLinkData(res, res[taskDataMember]);
      });
    }
  }, {
    key: "bindData",
    value: function bindData(data, links) {
      if (isNull(data) || !Array.isArray(data)) return;
      var options = [];

      for (var i = 0; i < data.length; i++) {
        var row = data[i];
        var option = {};

        try {
          var parentTaskID = "parent";
          if (this.dataModel.parentTaskID) parentTaskID = this.dataModel.parentTaskID;
          if (parentTaskID.indexOf("{") < 0 && parentTaskID.indexOf("#[") < 0) parentTaskID = "{" + parentTaskID + "}";
          option.parent = this._tfp.replaceDataField(row, parentTaskID);
          if (option.parent) option.parent = this._tfp.exeExpress(option.parent);
        } catch (e) {
          console.log(e);
          return;
        }

        try {
          var taskID = "id";
          if (this.dataModel.taskID) taskID = this.dataModel.taskID;
          if (taskID.indexOf("{") < 0 && taskID.indexOf("#[") < 0) taskID = "{" + taskID + "}";
          option.id = this._tfp.replaceDataField(row, taskID);
          if (option.id) option.id = this._tfp.exeExpress(option.id);
        } catch (e) {
          console.log(e);
          return;
        }

        try {
          var taskStartDate = "start_date";
          if (this.dataModel.taskStartDate) taskStartDate = this.dataModel.taskStartDate;
          if (taskStartDate.indexOf("{") < 0 && taskStartDate.indexOf("#[") < 0) taskStartDate = "{" + taskStartDate + "}";
          option.start_date = this._tfp.replaceDataField(row, taskStartDate);
          if (option.start_date) option.start_date = this._tfp.exeExpress(option.start_date);
        } catch (e) {
          console.log(e);
          return;
        }

        try {
          var taskEndDate = "end_date";
          if (this.dataModel.taskEndDate) taskEndDate = this.dataModel.taskEndDate;
          if (taskEndDate.indexOf("{") < 0 && taskEndDate.indexOf("#[") < 0) taskEndDate = "{" + taskEndDate + "}";
          option.end_date = this._tfp.replaceDataField(row, taskEndDate);
          if (option.end_date) option.end_date = this._tfp.exeExpress(option.end_date);
        } catch (e) {
          console.log(e);
          return;
        }

        try {
          var taskHead = "task_head";
          if (this.dataModel.taskHead) taskHead = this.dataModel.taskHead;
          if (taskHead.indexOf("{") < 0 && taskHead.indexOf("#[") < 0) taskHead = "{" + taskHead + "}";
          option.task_head = this._tfp.replaceDataField(row, taskHead);
          if (option.task_head) option.task_head = this._tfp.exeExpress(option.task_head);
        } catch (e) {
          console.log(e);
          return;
        }

        try {
          var taskText = "text";
          if (this.dataModel.taskText) taskText = this.dataModel.taskText;
          if (taskText.indexOf("{") < 0 && taskText.indexOf("#[") < 0) taskText = "{" + taskText + "}";
          option.text = this._tfp.replaceDataField(row, taskText);
          if (option.text) option.text = this._tfp.exeExpress(option.text);
        } catch (e) {
          console.log(e);
          return;
        }

        try {
          var taskProgress = "progress";
          if (this.dataModel.taskProgress) taskProgress = this.dataModel.taskProgress;
          if (taskProgress.indexOf("{") < 0 && taskProgress.indexOf("#[") < 0) taskProgress = "{" + taskProgress + "}";
          option.progress = this._tfp.replaceDataField(row, taskProgress);
          if (option.progress) option.progress = this._tfp.exeExpress(option.progress);
        } catch (e) {
          console.log(e);
          return;
        }

        try {
          var taskDuration = "duration";
          if (this.dataModel.taskDuration) taskDuration = this.dataModel.taskDuration;
          if (taskDuration.indexOf("{") < 0 && taskDuration.indexOf("#[") < 0) taskDuration = "{" + taskDuration + "}";
          option.duration = this._tfp.replaceDataField(row, taskDuration);
          if (option.duration) option.duration = this._tfp.exeExpress(option.duration);
        } catch (e) {
          console.log(e);
          return;
        }

        try {
          var taskColor = "color";
          if (this.dataModel.taskColor) taskColor = this.dataModel.taskColor;
          if (taskColor.indexOf("{") < 0 && taskColor.indexOf("#[") < 0) taskColor = "{" + taskColor + "}";
          option.color = this._tfp.replaceDataField(row, taskColor);
          if (option.color) option.color = this._tfp.exeExpress(option.color);
        } catch (e) {
          console.log(e);
          return;
        }

        try {
          var taskMilestone = "type";
          if (this.dataModel.taskMilestone) taskMilestone = this.dataModel.taskMilestone;
          if (taskMilestone.indexOf("{") < 0 && taskMilestone.indexOf("#[") < 0) taskMilestone = "{" + taskMilestone + "}";
          option.type = this._tfp.replaceDataField(row, taskMilestone);
          if (option.type) option.type = this._tfp.exeExpress(option.type);
        } catch (e) {
          console.log(e);
          return;
        }

        try {
          var taskRollup = "rollup";
          if (this.dataModel.taskRollup) taskRollup = this.dataModel.taskRollup;
          if (taskRollup.indexOf("{") < 0 && taskRollup.indexOf("#[") < 0) taskRollup = "{" + taskRollup + "}";
          option.rollup = this._tfp.replaceDataField(row, taskRollup);
          if (option.rollup) option.rollup = this._tfp.exeExpress(option.rollup);
        } catch (e) {
          console.log(e);
          return;
        }

        options.push(option);
      }

      this.bindLinks(links, options);
    }
  }, {
    key: "bindLinks",
    value: function bindLinks(links, data) {
      if (isNull(links) || !Array.isArray(links)) return;
      var options = [];

      for (var i = 0; i < links.length; i++) {
        var row = links[i];
        var option = {};

        try {
          var lineId = "id";
          if (this.dataModel.lineId) lineId = this.dataModel.lineId;
          if (lineId.indexOf("{") < 0 && lineId.indexOf("#[") < 0) lineId = "{" + lineId + "}";
          option.id = this._tfp.replaceDataField(row, lineId);
          if (option.id) option.id = this._tfp.exeExpress(option.id);
        } catch (e) {
          console.log(e);
          return;
        }

        try {
          var sourceTaskID = "source";
          if (this.dataModel.sourceTaskID) sourceTaskID = this.dataModel.sourceTaskID;
          if (sourceTaskID.indexOf("{") < 0 && sourceTaskID.indexOf("#[") < 0) sourceTaskID = "{" + sourceTaskID + "}";
          option.source = this._tfp.replaceDataField(row, sourceTaskID);
          if (option.source) option.source = this._tfp.exeExpress(option.source);
        } catch (e) {
          console.log(e);
          return;
        }

        try {
          var targetTaskID = "target";
          if (this.dataModel.targetTaskID) targetTaskID = this.dataModel.targetTaskID;
          if (targetTaskID.indexOf("{") < 0 && targetTaskID.indexOf("#[") < 0) targetTaskID = "{" + targetTaskID + "}";
          option.target = this._tfp.replaceDataField(row, targetTaskID);
          if (option.target) option.target = this._tfp.exeExpress(option.target);
        } catch (e) {
          console.log(e);
          return;
        }

        try {
          var lineType = "type";
          if (this.dataModel.lineType) lineType = this.dataModel.lineType;
          if (lineType.indexOf("{") < 0 && lineType.indexOf("#[") < 0) lineType = "{" + lineType + "}";
          option.type = this._tfp.replaceDataField(row, lineType);
          if (option.type) option.type = this._tfp.exeExpress(option.type);
        } catch (e) {
          console.log(e);
          return;
        }

        options.push(option);
      }

      this.tasks = {
        data: data,
        links: options
      };
      this.getGanttChart();
    }
  }, {
    key: "getGanttChart",
    value: function getGanttChart() {
      var type = "day";
      var that = this;
      gantt.i18n.setLocale("cn");
      gantt.config.xml_date = "%Y-%m-%d %H:%i"; // 初始化类型

      this.setScaleConfig(type); // 展开节点

      if (this.dataModel.expandAll) gantt.config.open_tree_initially = true; //关闭所有错误提示信息：gantt有自己的异常消息，如果不关闭可能页面会弹出异常消息

      gantt.config.show_errors = false; // //单击节点事件
      // gantt.attachEvent("onTaskClick", function (id, e) {
      //   if (that.dataModel.onClickNode) {
      //     let eventFucName = that._tfp.getCptEventFuncName(that.dataModel.onClickNode);
      //     eval(eventFucName + "('" + id + "')");
      //   }
      //   return false;
      // });
      // //双击节点事件
      // gantt.attachEvent("onTaskDblClick", function (id, e) {
      //   if (that.dataModel.onDblClickNode) {
      //     let eventFucName = that._tfp.getCptEventFuncName(that.dataModel.onDblClickNode);
      //     eval(eventFucName + "('" + id + "')");
      //   }
      //   return false;
      // });
      // 点击"+"事件

      gantt.attachEvent("onTaskCreated", function (task) {
        var id = null;
        if (task.parent) id = parseInt(task.parent);

        if (that.dataModel.onClickNodeAddButton) {
          var eventFucName = that._tfp.getCptEventFuncName(that.dataModel.onClickNodeAddButton);

          eval(eventFucName + "('" + id + "')");
        }

        return false;
      }); // 阻止打开灯箱

      gantt.attachEvent("onBeforeLightbox", function (id) {
        return false;
      }); // 任务之间创建新链接时

      gantt.attachEvent("onLinkCreated", function (link) {
        var links = link;

        if (that.dataModel.onLinkCreated) {
          try {
            eval(that.dataModel.onLinkCreated);
          } catch (e) {
            console.log(e);
          }
        }

        return true;
      }); // 拖放任务时

      gantt.attachEvent("onAfterTaskDrag", function (id, mode, e) {
        var task = gantt.getTask(id);
        var links = {
          id: task.id,
          text: task.text,
          start_date: new Date(task.start_date).format("yyyy-MM-dd"),
          end_date: new Date(task.end_date).format("yyyy-MM-dd"),
          duration: task.duration,
          progress: task.progress,
          parent: task.parent,
          color: task.color,
          type: task.type,
          rollup: task.rollup
        };

        if (that.dataModel.onAfterTaskDrag) {
          try {
            eval(that.dataModel.onAfterTaskDrag);
          } catch (e) {
            console.log(e);
          }
        }

        return true;
      }); // 里程碑文字提示

      gantt.templates.rightside_text = function (start, end, task) {
        if (task.type == "milestone") {
          return task.text;
        }

        return "";
      }; // 隐藏"+"


      if (!this.dataModel.showNodeAddButton) {
        gantt.config.columns = [{
          name: "text",
          label: "任务",
          tree: true,
          resize: true,
          width: 180
        }, {
          name: "start_date",
          label: "计划开始",
          align: "center",
          resize: true,
          width: 100
        }, {
          name: "end_date",
          label: "计划结束",
          align: "center",
          resize: true,
          width: 100
        }, {
          name: "task_head",
          label: "任务负责人",
          align: "center",
          resize: true,
          width: 100
        }, {
          name: "add",
          label: "",
          hide: true,
          width: 30
        }];
      } else {
        gantt.config.columns = [{
          name: "text",
          label: "任务",
          tree: true,
          resize: true,
          width: 180
        }, {
          name: "start_date",
          label: "计划开始",
          align: "center",
          resize: true,
          width: 100
        }, {
          name: "end_date",
          label: "计划结束",
          align: "center",
          resize: true,
          width: 100
        }, {
          name: "task_head",
          label: "任务负责人",
          align: "center",
          resize: true,
          width: 100
        }, {
          name: "add",
          label: "",
          width: 0
        }];
      } // 设计时只读


      if (this._tfp.isDesigning || this.dataModel.readonly) gantt.config.readonly = true;
      gantt.init("tfp-ganttchart-gantt");
      gantt.clearAll();
      gantt.parse(this.tasks);
    } // 动态设置Scale

  }, {
    key: "setScaleConfig",
    value: function setScaleConfig(level) {
      var weekScaleTemplate = function weekScaleTemplate(date) {
        var dateToStr = gantt.date.date_to_str('%M-%d日');
        var weekNum = gantt.date.date_to_str('(%W周)');
        var endDate = gantt.date.add(gantt.date.add(date, 1, 'week'), -1, 'day');
        return dateToStr(date) + '~' + dateToStr(endDate) + '' + weekNum(date);
      };

      switch (level) {
        case 'day':
          gantt.config.scale_height = 28 * 4;
          gantt.config.subscales = [{
            unit: 'year',
            step: 1,
            date: '%Y年'
          }, {
            unit: 'month',
            step: 1,
            date: '%F'
          }, {
            unit: 'week',
            step: 1,
            template: weekScaleTemplate
          }];
          gantt.config.scale_unit = 'day';
          gantt.config.date_scale = '周%D,%d日';
          gantt.render();
          break;

        case 'week':
          gantt.config.subscales = [{
            unit: 'year',
            step: 1,
            date: '%Y年'
          }, {
            unit: 'week',
            step: 1,
            template: weekScaleTemplate
          }];
          gantt.config.scale_height = 28 * 3;
          gantt.config.scale_unit = 'month';
          gantt.config.date_scale = '%F';
          gantt.render();
          break;

        case 'month':
          gantt.config.subscales = [{
            unit: 'year',
            step: 1,
            date: '%Y年'
          }];
          gantt.config.scale_unit = 'month';
          gantt.config.date_scale = '%F';
          gantt.config.scale_height = 28 * 2;
          gantt.render();
          break;

        case 'year':
          gantt.config.subscales = [];
          gantt.config.scale_unit = 'year';
          gantt.config.date_scale = '%Y年';
          gantt.config.scale_height = 28 * 2;
          gantt.render();
          break;
      }
    }
  }, {
    key: "initRuntime",
    value: function initRuntime() {
      var that = this;

      if (this.dataModel.loadDataService || this.dataModel.taskDataQuerySetting) {
        this.loadData();
      } else {
        this.initDesigning();
      } // this._jqObj.find(".tfp-ganttchart-export input").click(function () {
      //   let index = $(this).index();
      //   if (index == 0) {
      //     gantt.exportToPDF({
      //       name: "mygantt.pdf",
      //       locale: "cn",
      //       data: that.tasks
      //     });
      //   } else if (index == 1) {
      //     gantt.exportToPNG({
      //       name: "mygantt.png",
      //       locale: "cn",
      //       data: that.tasks
      //     });
      //   } else if (index == 2) {
      //     gantt.exportToICal({
      //       name: "mygantt.xlsx",
      //       locale: "cn",
      //       data: that.tasks
      //     });
      //   }
      // });


      this._jqObj.find(".tfp-ganttchart-type label").click(function () {
        var index = $(this).index();
        var type = "day";
        if (index == 0) return;

        if (index == 2) {
          type = "week";
        } else if (index == 3) {
          type = "month";
        } else if (index == 4) {
          type = "year";
        }

        that.setScaleConfig(type);
      });
    }
  }, {
    key: "initDesigning",
    value: function initDesigning() {
      this.tasks = {
        data: [{
          id: 1,
          text: "项目 #1",
          start_date: "2023-07-01",
          end_date: "2023-07-08",
          task_head: "负责人 #1",
          progress: 0.6,
          open: true,
          color: "#f56c6c"
        }, {
          id: 2,
          text: "项目 #2",
          start_date: "2023-07-01",
          end_date: "2023-07-09",
          task_head: "负责人 #2",
          progress: 1,
          open: true,
          color: "#ff9900"
        }, {
          id: 3,
          text: "项目 #3",
          start_date: "2023-07-02",
          end_date: "2023-07-08",
          task_head: "负责人 #3",
          progress: 0.5,
          open: true,
          color: "#e7ed6c",
          parent: 1
        }, {
          id: 4,
          text: "项目 #4",
          start_date: "2023-07-01",
          end_date: "2023-07-07",
          task_head: "负责人 #4",
          progress: 1,
          open: true,
          color: "#0099ff"
        }]
      };
      this.getGanttChart();
    }
  }]);
  return GanttChart;
}(_controller.FormInput);

exports["default"] = GanttChart;